#  SHIBOKEN_INCLUDE_DIR        - Directories to include to use SHIBOKEN
#  SHIBOKEN_LIBRARY            - Files to link against to use SHIBOKEN
#  SHIBOKEN_BINARY             - Executable name
#  SHIBOKEN_BUILD_TYPE         - Tells if Shiboken was compiled in Release or Debug mode.
#  SHIBOKEN_PYTHON_INTERPRETER - Python interpreter (regular or debug) to be used with the bindings.
#  SHIBOKEN_PYTHON_LIBRARIES   - Python libraries (regular or debug) Shiboken is linked against.

SET(SHIBOKEN_INCLUDE_DIR "/usr/include/shiboken2")
if(MSVC)
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken2.cpython-37m-x86_64-linux-gnu.lib")
elseif(CYGWIN)
    SET(SHIBOKEN_LIBRARY "/usr/lib/shiboken2.cpython-37m-x86_64-linux-gnu")
elseif(WIN32)
    SET(SHIBOKEN_LIBRARY "/usr/bin/libshiboken2.cpython-37m-x86_64-linux-gnu.so")
else()
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken2.cpython-37m-x86_64-linux-gnu.so")
endif()
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/python3.7m")
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/python3.7m")
SET(SHIBOKEN_PYTHON_INTERPRETER "/usr/bin/python3")
SET(SHIBOKEN_PYTHON_VERSION_MAJOR "3")
SET(SHIBOKEN_PYTHON_VERSION_MINOR "7")
SET(SHIBOKEN_PYTHON_VERSION_PATCH "1")
SET(SHIBOKEN_PYTHON_LIBRARIES "")
SET(SHIBOKEN_PYTHON_EXTENSION_SUFFIX ".cpython-37m-x86_64-linux-gnu")
SET(SHIBOKEN_PYTHON_SHARED_LIBRARY_SUFFIX ".cpython-37m-x86_64-linux-gnu")
SET(SHIBOKEN_PYTHON_CONFIG_SUFFIX ".cpython-37m-x86_64-linux-gnu")
SET(SHIBOKEN_SO_VERSION "5.11")
message(STATUS "libshiboken built for Release")


set(SHIBOKEN_BINARY "/usr/bin/shiboken2")
