/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;

public class FnResolveURI
extends Function {
    private static Collection _expected_args = null;

    public FnResolveURI() {
        super(new QName("resolve-uri"), 1, 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnResolveURI.resolveURI(args, this.dynamic_context());
    }

    public static ResultSequence resolveURI(Collection args, DynamicContext d_context) throws DynamicError {
        if (d_context.base_uri() == null) {
            throw DynamicError.noBaseURI();
        }
        Collection cargs = args;
        Iterator argit = cargs.iterator();
        ResultSequence relativeRS = (ResultSequence)argit.next();
        ResultSequence baseUriRS = null;
        if (argit.hasNext()) {
            baseUriRS = (ResultSequence)argit.next();
        }
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (relativeRS.empty()) {
            return rs;
        }
        AnyType relativeURI = relativeRS.first();
        String resolvedURI = null;
        if (baseUriRS == null) {
            resolvedURI = FnResolveURI.resolveURI(d_context.base_uri().string_value(), relativeURI.string_value());
        } else {
            AnyType baseURI = baseUriRS.first();
            resolvedURI = FnResolveURI.resolveURI(baseURI.string_value(), relativeURI.string_value());
        }
        rs.add(new XSAnyURI(resolvedURI));
        return rs;
    }

    private static String resolveURI(String base, String relative) throws DynamicError {
        String resolved = null;
        try {
            URI baseURI = new URI(base);
            resolved = baseURI.resolve(relative).toString();
        }
        catch (Exception ex) {
            throw DynamicError.errorResolvingURI();
        }
        return resolved;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(3));
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

