/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertRowOperationBase
extends AbstractTableOperation {
    private static final String ARGUMENT_XPATH_LOCATION = "insertLocation";
    private static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    private ArgumentDescriptor[] arguments = this.getOperationArguments();

    protected ArgumentDescriptor[] getOperationArguments() {
        ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_LOCATION, 2, "An XPath expression indicating the insert location for the new table row.\nNote: If it is not defined then the insert location will be at the caret.");
        argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RELATIVE_LOCATION, 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
        ArgumentDescriptor[] argumentDescriptorArray = new ArgumentDescriptor[]{argumentDescriptor, argumentDescriptor, NAMESPACE_ARGUMENT_DESCRIPTOR};
        return argumentDescriptorArray;
    }

    public InsertRowOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        try {
            AuthorElement authorElement;
            String string;
            Object object = argumentsMap.getArgumentValue("namespace");
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            AuthorElement authorElement2 = this.getElementAncestor(authorNode, 2);
            if (authorElement2 != null && (string = this.getRowXMLFragment(authorAccess, authorElement2, authorElement = this.useCurrentRowTemplateOnInsert() ? this.getElementAncestor(authorNode, 1) : null, (String)object)) != null) {
                authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string, (String)argumentsMap.getArgumentValue(ARGUMENT_XPATH_LOCATION), (String)argumentsMap.getArgumentValue(ARGUMENT_RELATIVE_LOCATION));
                if (authorElement != null) {
                    this.incrementRowSpans(authorElement2, authorElement, authorAccess, 1);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    public String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement authorElement, String string, String string2, int n2) throws BadLocationException {
        String string3;
        int n3 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
        StringBuilder stringBuilder = null;
        if (string2 != null && n2 <= n3 && (string3 = this.getRowElementName(authorElement)) != null) {
            String string4;
            int n4;
            stringBuilder = new StringBuilder("<").append(string3);
            if (string != null) {
                n4 = string3.indexOf(":");
                string4 = null;
                if (n4 > 0) {
                    string4 = string3.substring(0, n4);
                }
                stringBuilder.append(" xmlns");
                if (string4 != null) {
                    stringBuilder.append(":").append(string4);
                }
                stringBuilder.append("=\"").append(string).append("\"");
            }
            stringBuilder.append(">");
            for (n4 = 0; n4 < n3; ++n4) {
                string4 = this.getCellElementName(authorElement, n4);
                if (n4 == n2) {
                    stringBuilder.append(string2);
                }
                if (string4 == null) continue;
                String string5 = this.getDefaultContentForEmptyCells();
                if (string5 != null) {
                    stringBuilder.append("<").append(string4).append(">");
                    stringBuilder.append(string5);
                    stringBuilder.append("</").append(string4).append(">");
                    continue;
                }
                stringBuilder.append("<").append(string4).append("/>");
            }
            if (n2 == n3) {
                stringBuilder.append(string2);
            }
            stringBuilder.append("</").append(string3).append(">");
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    public String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement authorElement, AuthorElement authorElement2, String string) throws BadLocationException {
        StringBuilder stringBuilder = null;
        String string2 = authorElement2 != null ? authorElement2.getName() : this.getRowElementName(authorElement);
        String string3 = string = authorElement2 != null ? authorElement2.getNamespace() : string;
        if (string2 != null) {
            Object object;
            int n2;
            stringBuilder = new StringBuilder("<").append(string2);
            if (string != null) {
                n2 = string2.indexOf(":");
                object = null;
                if (n2 > 0) {
                    object = string2.substring(0, n2);
                }
                stringBuilder.append(" xmlns");
                if (object != null) {
                    stringBuilder.append(":").append((String)object);
                }
                stringBuilder.append("=\"").append(string).append("\"");
            }
            stringBuilder.append(">");
            if (authorElement2 != null) {
                AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
                object = authorElement2.getContentNodes();
                String[] stringArray = InsertRowOperationBase.mergeArrays(this.tableHelper.getIgnoredRowAttributes(), this.tableHelper.getIgnoredCellIDAttributes());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Integer n3;
                    AuthorNode authorNode = (AuthorNode)iterator.next();
                    if (authorNode.getType() != 0 || (n3 = authorTableCellSpanProvider.getRowSpan((AuthorElement)authorNode)) != null && n3 >= 2) continue;
                    String string4 = this.createCellXMLFragment((AuthorElement)authorNode, stringArray, this.getDefaultContentForEmptyCells());
                    stringBuilder.append(string4);
                }
            } else {
                n2 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string5 = this.getCellElementName(authorElement, i2);
                    if (string5 == null) continue;
                    String string6 = this.getDefaultContentForEmptyCells();
                    if (string6 != null) {
                        stringBuilder.append("<").append(string5).append(">");
                        stringBuilder.append(string6);
                        stringBuilder.append("</").append(string5).append(">");
                        continue;
                    }
                    stringBuilder.append("<").append(string5).append("/>");
                }
            }
            stringBuilder.append("</").append(string2).append(">");
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    private static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected String createCellXMLFragment(AuthorElement authorElement, String[] stringArray, String string) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        if (authorElement != null) {
            stringBuilder.append("<").append(authorElement.getName());
            int n2 = authorElement.getAttributesCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = authorElement.getAttributeAtIndex(i2);
                AttrValue attrValue = authorElement.getAttribute(string2);
                if (!attrValue.isSpecified()) continue;
                boolean bl = false;
                for (String string3 : stringArray) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuilder.append(" ").append(string2).append("=\"").append(attrValue.getRawValue()).append("\"");
            }
            if (string != null && string.length() > 0) {
                stringBuilder.append(">");
                stringBuilder.append(string);
                stringBuilder.append("</").append(authorElement.getName()).append(">");
            } else {
                stringBuilder.append("/>");
            }
        }
        return stringBuilder.toString();
    }

    private void incrementRowSpans(AuthorElement authorElement, AuthorElement authorElement2, AuthorAccess authorAccess, int n2) throws BadLocationException {
        int n3 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
        AuthorTableCellSpanProvider authorTableCellSpanProvider = null;
        List<AuthorNode> list = authorElement2.getContentNodes();
        int n4 = list.size();
        for (AuthorNode authorNode : list) {
            Integer n5;
            if (authorNode.getType() != 0 || !this.tableHelper.isTableCell(authorNode)) continue;
            AuthorElement authorElement3 = (AuthorElement)authorNode;
            if (authorTableCellSpanProvider == null) {
                authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
            }
            if ((n5 = authorTableCellSpanProvider.getRowSpan(authorElement3)) == null || n5 <= 1 || n5 < n2) continue;
            this.tableHelper.updateTableRowSpan(authorAccess, authorElement3, n5 + 1);
        }
        if (n3 != n4) {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorElement2.getStartOffset() - 1);
            ++n2;
            if (authorNode.getType() == 0 && this.tableHelper.isTableRow(authorNode)) {
                this.incrementRowSpans(authorElement, (AuthorElement)authorNode, authorAccess, n2);
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Insert a table row.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected abstract String getRowElementName(AuthorElement var1);

    protected boolean useCurrentRowTemplateOnInsert() {
        return false;
    }

    protected String getDefaultContentForEmptyCells() {
        return null;
    }
}

