/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorInputEvent {
    public static final int SHIFT_PRESSED = 1;
    public static final int CTRL_PRESSED = 2;
    public static final int META_PRESSED = 4;
    public static final int ALT_PRESSED = 8;
    public static final int ALT_GRAPH_PRESSED = 32;
    public final int modifiers;
    public boolean consumed;

    public AuthorInputEvent(int n2) {
        this.modifiers = n2;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public boolean isShiftPressed() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isCtrlPressed() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isAltPressed() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphPressed() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isMetaPressed() {
        return (this.modifiers & 4) != 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

