/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.editor.ButtonEditor;
import ro.sync.ecss.component.editor.f;
import ro.sync.ecss.extensions.api.AuthorExtensionActionProvider;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.IAuthorExtensionAction;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.exml.m;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.yb;
import ro.sync.ui.Icons;
import ro.sync.ui.application.mb;
import ro.sync.ui.c.c;
import ro.sync.ui.ld;
import ro.sync.util.PlatformDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ButtonGroupEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    private static final yb lsd = m.e();
    private final JToggleButton msd = new JToggleButton(){

        @Override
        public JToolTip createToolTip() {
            c c2 = new c();
            c2.setComponent(this);
            return c2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isContentAreaFilled() && (this.getModel().isRollover() || this.isSelected())) {
                ButtonEditor.pxc(graphics, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
        }
    };
    private final mb osd;
    private ActionListener jsd;
    private KeyListener psd;
    private final java.awt.Font isd = this.msd.getFont();
    private final Color ksd = this.msd.getForeground();
    private Border nsd = this.msd.getBorder();

    public ButtonGroupEditor() {
        this.osd = new mb(null, null);
        this.osd.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.msd.setSelected(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.msd.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.msd.setSelected(false);
            }
        });
    }

    @Override
    public String getDescription() {
        return "A button group that shows a popup to choose among several extension actions";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.czc(authorInplaceContext);
        return this.msd;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.msd.requestFocus();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void stopEditing() {
        this.osd.setVisible(false);
        this.fireEditingStopped(new EditingEvent((String)null));
    }

    @Override
    public void cancelEditing() {
        this.osd.setVisible(false);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.czc(authorInplaceContext);
        return this.msd;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return null;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return this.hzc(authorInplaceContext);
    }

    private java.awt.Font azc(AuthorInplaceContext authorInplaceContext) {
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            return new java.awt.Font(font.getName(), font.getStyle(), font.getSize());
        }
        return this.isd;
    }

    private Color nzc(AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return this.ksd;
    }

    private Icon gzc(String string) throws FileNotFoundException {
        Icon icon = ld.f(string);
        if (icon == null && (icon = ld.h(string)) == null) {
            throw new FileNotFoundException("File " + string + " not found.");
        }
        return icon;
    }

    private Icon ezc(AuthorInplaceContext authorInplaceContext) {
        Object object = authorInplaceContext.getArguments().get("icon");
        if (object instanceof String) {
            Icon icon;
            try {
                icon = this.gzc((String)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                icon = Icons.getIcon("/images/MissingProject10.png");
            }
            authorInplaceContext.getArguments().put("icon", icon);
            return icon;
        }
        return (Icon)object;
    }

    private String zyc(AuthorInplaceContext authorInplaceContext) {
        return (String)authorInplaceContext.getArguments().get("label");
    }

    private String hzc(AuthorInplaceContext authorInplaceContext) {
        return (String)authorInplaceContext.getArguments().get("tooltip");
    }

    public static List<IAuthorExtensionAction> processActions(AuthorExtensionActionProvider authorExtensionActionProvider, String string) {
        ArrayList<IAuthorExtensionAction> arrayList = new ArrayList<IAuthorExtensionAction>();
        for (String string2 : string.split(",")) {
            string2 = string2.trim();
            IAuthorExtensionAction iAuthorExtensionAction = null;
            if (authorExtensionActionProvider != null) {
                iAuthorExtensionAction = authorExtensionActionProvider.getExtensionAction(string2);
            }
            if (iAuthorExtensionAction == null) {
                throw new IllegalArgumentException("Invalid extension action ID: \"" + string2 + "\".");
            }
            arrayList.add(iAuthorExtensionAction);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("No action was specified.");
        }
        return arrayList;
    }

    private List<IAuthorExtensionAction> fzc(AuthorInplaceContext authorInplaceContext) {
        List list = (List)authorInplaceContext.getArguments().get("actionIDs");
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static f._b processActionDisplayStyle(String string) {
        try {
            if (string.equals(string.toLowerCase())) {
                return f._b.valueOf(string.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid actionDisplayStyle value. Valid ones are: text, icon, both.");
    }

    private f._b yyc(AuthorInplaceContext authorInplaceContext) {
        f._b _b2 = (f._b)((Object)authorInplaceContext.getArguments().get("actionStyle"));
        return _b2 != null ? _b2 : f._b.b;
    }

    private void czc(final AuthorInplaceContext authorInplaceContext) {
        this.msd.setFont(this.azc(authorInplaceContext));
        this.msd.setForeground(this.nzc(authorInplaceContext));
        Icon icon = this.ezc(authorInplaceContext);
        this.msd.setIcon(icon);
        String string = this.zyc(authorInplaceContext);
        if (icon != null) {
            this.msd.setText(null);
        } else if (string != null) {
            this.msd.setText(string);
        } else {
            this.msd.setText(lsd.b("Unknown"));
        }
        this.msd.setToolTipText(this.hzc(authorInplaceContext));
        ButtonEditor.nxc(this.msd, authorInplaceContext, this.nsd);
        if (this.jsd != null) {
            this.msd.removeActionListener(this.jsd);
        }
        if (this.psd != null) {
            this.msd.removeKeyListener(this.psd);
        }
        this.jsd = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonGroupEditor.this.kzc(authorInplaceContext);
            }
        };
        this.msd.addActionListener(this.jsd);
        this.psd = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    ButtonGroupEditor.this.fireEditingCanceled();
                } else if (keyEvent.getKeyCode() == 10) {
                    ButtonGroupEditor.this.kzc(authorInplaceContext);
                }
            }
        };
        this.msd.addKeyListener(this.psd);
    }

    private void kzc(AuthorInplaceContext authorInplaceContext) {
        this.osd.setFont(this.azc(authorInplaceContext));
        this.osd.setForeground(this.nzc(authorInplaceContext));
        this.osd.removeAll();
        f._b _b2 = this.yyc(authorInplaceContext);
        if (_b2 != f._b.e) {
            for (IAuthorExtensionAction iAuthorExtensionAction : this.fzc(authorInplaceContext)) {
                this.osd.add(new _b(iAuthorExtensionAction, _b2));
            }
        } else {
            Insets insets = new Insets(2, 2, 2, 2);
            int n2 = 0;
            int n3 = 0;
            for (IAuthorExtensionAction object2 : this.fzc(authorInplaceContext)) {
                _b n5 = new _b(object2, _b2);
                if (_b2 == f._b.e) {
                    JMenuItem n6 = new JMenuItem(n5);
                    this.osd.add(n6);
                    n6.setHideActionText(true);
                    n6.setIconTextGap(0);
                    n6.setMargin(insets);
                    Insets insets2 = n6.getBorder().getBorderInsets(n6);
                    int n4 = insets2.left + insets.left + n6.getIcon().getIconWidth() + insets.right + insets2.right;
                    if (PlatformDetector.isMacOS()) {
                        n4 += 20;
                    }
                    n2 = Math.max(n2, n4);
                    n3 += insets2.top + insets.top + n6.getIcon().getIconHeight() + insets.bottom + insets2.bottom;
                    continue;
                }
                this.osd.add(n5);
            }
            Insets insets3 = this.osd.getMargin();
            Insets insets4 = this.osd.getBorder().getBorderInsets(this.osd);
            int n5 = insets4.left + insets3.left + n2 + insets3.right + insets4.right;
            int n6 = insets4.top + insets3.top + n3 + insets3.bottom + insets4.bottom;
            this.osd.setPreferredSize(new Dimension(n5, n6));
        }
        this.osd.show(this.msd, 0, this.msd.getBounds().height);
    }

    private static Icon xyc(IAuthorExtensionAction iAuthorExtensionAction, f._b _b2) {
        switch (_b2) {
            case e: 
            case d: {
                String string = (String)iAuthorExtensionAction.getValue("small_icon_path");
                Icon icon = ld.f(string);
                if (icon == null && _b2 == f._b.e) {
                    icon = Icons.getIcon("/images/MissingProject10.png");
                }
                return icon;
            }
        }
        return null;
    }

    private static String ozc(IAuthorExtensionAction iAuthorExtensionAction, f._b _b2) {
        switch (_b2) {
            case d: 
            case b: {
                String string = (String)iAuthorExtensionAction.getValue("action_name");
                assert (string != null);
                return string;
            }
        }
        return null;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.czc(authorInplaceContext);
        return ButtonEditor.mxc(this.msd, authorInplaceContext);
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
    }

    private class _b
    extends AbstractAction {
        private IAuthorExtensionAction c;

        public _b(IAuthorExtensionAction iAuthorExtensionAction, f._b _b2) {
            super(ButtonGroupEditor.ozc(iAuthorExtensionAction, _b2), ButtonGroupEditor.xyc(iAuthorExtensionAction, _b2));
            this.putValue("ShortDescription", iAuthorExtensionAction.getValue("description"));
            this.c = iAuthorExtensionAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ButtonGroupEditor.this.fireEditingStopped(new EditingEvent(this.c));
            ButtonGroupEditor.this.osd.setVisible(false);
        }
    }
}

