/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNReturnValueCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffGenerator
implements ISvnDiffGenerator {
    protected static final String WC_REVISION_LABEL = "(working copy)";
    protected static final String PROPERTIES_SEPARATOR = "___________________________________________________________________";
    protected static final String HEADER_SEPARATOR = "===================================================================";
    protected static final String HEADER_ENCODING = "UTF-8";
    private SvnTarget originalTarget1 = null;
    private SvnTarget originalTarget2 = null;
    private SvnTarget baseTarget;
    private SvnTarget relativeToTarget;
    private SvnTarget repositoryRoot;
    private String encoding;
    private byte[] eol;
    private boolean useGitFormat;
    private boolean forcedBinaryDiff;
    private boolean diffDeleted = true;
    private boolean diffAdded = true;
    private List<String> rawDiffOptions;
    private boolean forceEmpty;
    private Set<String> visitedPaths = new HashSet<String>();
    private String externalDiffCommand;
    private SVNDiffOptions diffOptions;
    private boolean fallbackToAbsolutePath;
    private ISVNOptions options;
    private boolean propertiesOnly;
    private boolean ignoreProperties;

    private String getDisplayPath(SvnTarget svnTarget) {
        String string;
        if (this.baseTarget == null) {
            string = null;
        } else {
            String string2 = svnTarget.getPathOrUrlDecodedString();
            String string3 = this.baseTarget.getPathOrUrlDecodedString();
            string = this.getRelativePath(string2, string3);
        }
        return string != null ? string : svnTarget.getPathOrUrlString();
    }

    private String getRelativeToRootPath(SvnTarget svnTarget, SvnTarget svnTarget2) {
        String string;
        if (this.repositoryRoot == null) {
            string = null;
        } else if (this.repositoryRoot.isFile() == svnTarget.isFile()) {
            String string2 = svnTarget.getPathOrUrlDecodedString();
            String string3 = this.repositoryRoot.getPathOrUrlDecodedString();
            string = this.getRelativePath(string2, string3);
        } else {
            String string4 = svnTarget.getPathOrUrlDecodedString();
            String string5 = new File("").getAbsolutePath();
            string = this.getRelativePath(string4, string5);
        }
        return string != null ? string : svnTarget.getPathOrUrlString();
    }

    private String getRelativePath(String string, String string2) {
        String string3;
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        if (string2 != null) {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if ((string3 = SVNPathUtil.getPathAsChild((String)string2, (String)string)) != null) {
            return string3;
        }
        if (string.equals(string2)) {
            return "";
        }
        return null;
    }

    private String getChildPath(String string, String string2) {
        if (this.relativeToTarget == null) {
            return null;
        }
        String string3 = this.getRelativePath(string, string2);
        if (string3 == null) {
            return string;
        }
        if (string3.length() > 0) {
            return string3;
        }
        if (string2.equals(string)) {
            return ".";
        }
        return null;
    }

    public void setBaseTarget(SvnTarget svnTarget) {
        this.baseTarget = svnTarget;
    }

    public void setUseGitFormat(boolean bl) {
        this.useGitFormat = bl;
    }

    public void setOriginalTargets(SvnTarget svnTarget, SvnTarget svnTarget2) {
        this.originalTarget1 = svnTarget;
        this.originalTarget2 = svnTarget2;
    }

    public void setRelativeToTarget(SvnTarget svnTarget) {
        this.relativeToTarget = svnTarget;
    }

    public void setAnchors(SvnTarget svnTarget, SvnTarget svnTarget2) {
    }

    public void setRepositoryRoot(SvnTarget svnTarget) {
        this.repositoryRoot = svnTarget;
    }

    public void setForceEmpty(boolean bl) {
        this.forceEmpty = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getGlobalEncoding() {
        ISVNOptions iSVNOptions = this.getOptions();
        if (iSVNOptions != null && iSVNOptions instanceof DefaultSVNOptions) {
            DefaultSVNOptions defaultSVNOptions = (DefaultSVNOptions)iSVNOptions;
            return defaultSVNOptions.getGlobalCharset();
        }
        return null;
    }

    public void setEOL(byte[] byArray) {
        this.eol = byArray;
    }

    public byte[] getEOL() {
        return this.eol;
    }

    public boolean isForcedBinaryDiff() {
        return this.forcedBinaryDiff;
    }

    public void setForcedBinaryDiff(boolean bl) {
        this.forcedBinaryDiff = bl;
    }

    public boolean isPropertiesOnly() {
        return this.propertiesOnly;
    }

    public void setPropertiesOnly(boolean bl) {
        this.propertiesOnly = bl;
    }

    public boolean isIgnoreProperties() {
        return this.ignoreProperties;
    }

    public void setIgnoreProperties(boolean bl) {
        this.ignoreProperties = bl;
    }

    public void displayDeletedDirectory(SvnTarget svnTarget, String string, String string2, OutputStream outputStream) throws SVNException {
    }

    public void displayAddedDirectory(SvnTarget svnTarget, String string, String string2, OutputStream outputStream) throws SVNException {
    }

    public void displayPropsChanged(SvnTarget svnTarget, String string, String string2, boolean bl, SVNProperties sVNProperties, SVNProperties sVNProperties2, OutputStream outputStream) throws SVNException {
        boolean bl2;
        String string3;
        String string4;
        if (this.isIgnoreProperties()) {
            return;
        }
        this.ensureEncodingAndEOLSet();
        String string5 = this.getDisplayPath(svnTarget);
        String string6 = this.originalTarget1.getPathOrUrlDecodedString();
        String string7 = this.originalTarget2.getPathOrUrlDecodedString();
        if (string5 == null || string5.length() == 0) {
            string5 = ".";
        }
        if (this.useGitFormat) {
            string6 = this.adjustRelativeToReposRoot(string6);
            string7 = this.adjustRelativeToReposRoot(string7);
        }
        String string8 = string5;
        String string9 = string6;
        String string10 = string7;
        String string11 = SVNPathUtil.getCommonPathAncestor((String)string9, (String)string10);
        int n2 = string11 == null ? 0 : string11.length();
        string9 = string9.substring(n2);
        string10 = string10.substring(n2);
        string9 = this.computeLabel(string8, string9);
        string10 = this.computeLabel(string8, string10);
        if (this.relativeToTarget != null) {
            String string12;
            String string13;
            String string14 = this.relativeToTarget.getPathOrUrlDecodedString();
            string4 = svnTarget.getPathOrUrlDecodedString();
            string3 = this.getChildPath(string4, string14);
            if (string3 == null) {
                this.throwBadRelativePathException(string4, string14);
            }
            if ((string13 = this.getChildPath(string9, string14)) == null) {
                this.throwBadRelativePathException(string9, string14);
            }
            if ((string12 = this.getChildPath(string10, string14)) == null) {
                this.throwBadRelativePathException(string10, string14);
            }
            string5 = string3;
            string9 = string13;
            string10 = string12;
        }
        boolean bl3 = bl2 = !this.visitedPaths.contains(string5);
        if (bl2) {
            string4 = this.getLabel(string9, string);
            string3 = this.getLabel(string10, string2);
            boolean bl4 = this.displayHeader(outputStream, string5, false, false, SvnDiffCallback.OperationKind.Modified);
            this.visitedPaths.add(string5);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, SvnDiffCallback.OperationKind.Modified, this.getRelativeToRootPath(svnTarget, this.originalTarget1), this.getRelativeToRootPath(svnTarget, this.originalTarget2), null);
            }
            if (bl4) {
                return;
            }
            if (this.useGitFormat) {
                this.displayGitHeaderFields(outputStream, svnTarget, string, string2, SvnDiffCallback.OperationKind.Modified, null);
            } else {
                this.displayHeaderFields(outputStream, string4, string3);
            }
        }
        this.displayPropertyChangesOn(this.useGitFormat ? this.getRelativeToRootPath(svnTarget, this.originalTarget1) : string5, outputStream);
        this.displayPropDiffValues(outputStream, sVNProperties2, sVNProperties);
    }

    private void throwBadRelativePathException(String string, String string2) throws SVNException {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.BAD_RELATIVE_PATH, (String)"Path ''{0}'' must be an immediate child of the directory ''{0}''", (Object[])new Object[]{string, string2});
        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.CLIENT);
    }

    private void displayGitHeaderFields(OutputStream outputStream, SvnTarget svnTarget, String string, String string2, SvnDiffCallback.OperationKind operationKind, String string3) throws SVNException {
        String string4 = string3 != null ? string3 : this.getRelativeToRootPath(svnTarget, this.originalTarget1);
        String string5 = this.getRelativeToRootPath(svnTarget, this.originalTarget2);
        try {
            this.displayString(outputStream, "--- ");
            this.displayFirstGitLabelPath(outputStream, string4, string, operationKind);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "+++ ");
            this.displaySecondGitLabelPath(outputStream, string5, string2, operationKind);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private String adjustRelativeToReposRoot(String string) {
        if (this.repositoryRoot != null) {
            String string2 = this.repositoryRoot.getPathOrUrlDecodedString();
            String string3 = this.getRelativePath(string, string2);
            return string3 == null ? "" : string3;
        }
        return string;
    }

    private String computeLabel(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            return string + "\t(..." + string2 + ")";
        }
        return string + "\t(.../" + string2 + ")";
    }

    public void displayContentChanged(SvnTarget svnTarget, File file, File file2, String string, String string2, String string3, String string4, SvnDiffCallback.OperationKind operationKind, File file3, SVNProperties sVNProperties, SVNProperties sVNProperties2, OutputStream outputStream) throws SVNException {
        String string5;
        String string6;
        String string7;
        if (this.isPropertiesOnly()) {
            return;
        }
        this.ensureEncodingAndEOLSet();
        String string8 = this.getDisplayPath(svnTarget);
        String string9 = this.originalTarget1.getPathOrUrlDecodedString();
        String string10 = this.originalTarget2.getPathOrUrlDecodedString();
        if (this.useGitFormat) {
            string9 = this.adjustRelativeToReposRoot(string9);
            string10 = this.adjustRelativeToReposRoot(string10);
        }
        String string11 = string8;
        String string12 = string9;
        String string13 = string10;
        String string14 = SVNPathUtil.getCommonPathAncestor((String)string12, (String)string13);
        int n2 = string14 == null ? 0 : string14.length();
        string12 = string12.substring(n2);
        string13 = string13.substring(n2);
        string12 = this.computeLabel(string11, string12);
        string13 = this.computeLabel(string11, string13);
        if (this.relativeToTarget != null) {
            String string15;
            string7 = this.relativeToTarget.getPathOrUrlDecodedString();
            string6 = svnTarget.getPathOrUrlDecodedString();
            String string16 = this.getChildPath(string6, string7);
            if (string16 == null) {
                this.throwBadRelativePathException(string6, string7);
            }
            if ((string15 = this.getChildPath(string12, string7)) == null) {
                this.throwBadRelativePathException(string12, string7);
            }
            if ((string5 = this.getChildPath(string13, string7)) == null) {
                this.throwBadRelativePathException(string13, string7);
            }
            string8 = string16;
            string12 = string15;
            string13 = string5;
        }
        string7 = this.getLabel(string12, string);
        string6 = this.getLabel(string13, string2);
        boolean bl = false;
        boolean bl2 = false;
        if (string3 != null) {
            bl = SVNProperty.isBinaryMimeType((String)string3);
        }
        if (string4 != null) {
            bl2 = SVNProperty.isBinaryMimeType((String)string4);
        }
        if (!this.forcedBinaryDiff && (bl || bl2)) {
            boolean bl3 = this.displayHeader(outputStream, string8, file2 == null, file == null, operationKind);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, operationKind, this.getRelativeToRootPath(svnTarget, this.originalTarget1), this.getRelativeToRootPath(svnTarget, this.originalTarget2), null);
            }
            this.visitedPaths.add(string8);
            if (bl3) {
                return;
            }
            this.displayBinary(string3, string4, outputStream, bl, bl2);
            return;
        }
        string5 = this.getExternalDiffCommand();
        if (string5 != null) {
            boolean bl4 = this.displayHeader(outputStream, string8, file2 == null, file == null, operationKind);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(outputStream, operationKind, this.getRelativeToRootPath(svnTarget, this.originalTarget1), this.getRelativeToRootPath(svnTarget, this.originalTarget2), null);
            }
            this.visitedPaths.add(string8);
            if (bl4) {
                return;
            }
            this.runExternalDiffCommand(outputStream, string5, file, file2, string7, string6);
        } else {
            this.internalDiff(svnTarget, outputStream, string8, file, file2, string7, string6, operationKind, file3 == null ? null : file3.getPath(), string, string2);
        }
    }

    private void displayBinary(String string, String string2, OutputStream outputStream, boolean bl, boolean bl2) throws SVNException {
        this.displayCannotDisplayFileMarkedBinary(outputStream);
        if (bl && !bl2) {
            this.displayMimeType(outputStream, string);
        } else if (!bl && bl2) {
            this.displayMimeType(outputStream, string2);
        } else if (bl && bl2) {
            if (string.equals(string2)) {
                this.displayMimeType(outputStream, string);
            } else {
                this.displayMimeTypes(outputStream, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDiff(SvnTarget svnTarget, OutputStream outputStream, String string, File file, File file2, String string2, String string3, SvnDiffCallback.OperationKind operationKind, String string4, String string5, String string6) throws SVNException {
        String string7 = this.getHeaderString(svnTarget, string, file2 == null, file == null, operationKind, string4);
        if (file2 == null && !this.isDiffDeleted()) {
            try {
                this.displayString(outputStream, string7);
            }
            catch (IOException iOException) {
                this.wrapException(iOException);
            }
            this.visitedPaths.add(string);
            return;
        }
        if (file == null && !this.isDiffAdded()) {
            try {
                this.displayString(outputStream, string7);
            }
            catch (IOException iOException) {
                this.wrapException(iOException);
            }
            this.visitedPaths.add(string);
            return;
        }
        String string8 = this.getHeaderFieldsString(svnTarget, string, string2, string3, string5, string6, operationKind, string4);
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            String string9;
            randomAccessFile = file == null ? null : SVNFileUtil.openRAFileForReading((File)file);
            randomAccessFile2 = file2 == null ? null : SVNFileUtil.openRAFileForReading((File)file2);
            QDiffUniGenerator.setup();
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
            sVNHashMap.put("eol", new String(this.getEOL()));
            if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                sVNHashMap.put("ignore-space", "all-space");
            } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                sVNHashMap.put("ignore-space", "space-change");
            }
            if (this.forceEmpty || this.useGitFormat) {
                this.displayString(outputStream, string7);
                string9 = string8;
                this.visitedPaths.add(string);
            } else {
                string9 = string7 + string8;
            }
            QDiffUniGenerator qDiffUniGenerator = new QDiffUniGenerator((Map)sVNHashMap, string9);
            EmptyDetectionOutputStream emptyDetectionOutputStream = new EmptyDetectionOutputStream(outputStream);
            QDiffManager.generateTextDiff((RandomAccessFile)randomAccessFile, (RandomAccessFile)randomAccessFile2, (OutputStream)emptyDetectionOutputStream, (QDiffGenerator)qDiffUniGenerator);
            if (emptyDetectionOutputStream.isSomethingWritten()) {
                this.visitedPaths.add(string);
            }
            emptyDetectionOutputStream.flush();
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)iOException.getMessage());
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (Throwable)iOException, (SVNLogType)SVNLogType.DEFAULT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(randomAccessFile);
                SVNFileUtil.closeFile(randomAccessFile2);
                throw throwable;
            }
            SVNFileUtil.closeFile((RandomAccessFile)randomAccessFile);
            SVNFileUtil.closeFile((RandomAccessFile)randomAccessFile2);
        }
        SVNFileUtil.closeFile((RandomAccessFile)randomAccessFile);
        SVNFileUtil.closeFile((RandomAccessFile)randomAccessFile2);
    }

    private String getHeaderFieldsString(SvnTarget svnTarget, String string, String string2, String string3, String string4, String string5, SvnDiffCallback.OperationKind operationKind, String string6) throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.useGitFormat) {
                this.displayGitHeaderFields(byteArrayOutputStream, svnTarget, string4, string5, operationKind, string6);
            } else {
                this.displayHeaderFields(byteArrayOutputStream, string2, string3);
            }
        }
        catch (SVNException sVNException) {
            SVNFileUtil.closeFile((OutputStream)byteArrayOutputStream);
            try {
                byteArrayOutputStream.writeTo(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw sVNException;
        }
        try {
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString(HEADER_ENCODING);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private String getHeaderString(SvnTarget svnTarget, String string, boolean bl, boolean bl2, SvnDiffCallback.OperationKind operationKind, String string2) throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            boolean bl3 = this.displayHeader(byteArrayOutputStream, string, bl, bl2, operationKind);
            if (this.useGitFormat) {
                this.displayGitDiffHeader(byteArrayOutputStream, operationKind, this.getRelativeToRootPath(svnTarget, this.originalTarget1), this.getRelativeToRootPath(svnTarget, this.originalTarget2), string2);
            }
        }
        catch (SVNException sVNException) {
            SVNFileUtil.closeFile((OutputStream)byteArrayOutputStream);
            try {
                byteArrayOutputStream.writeTo(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw sVNException;
        }
        try {
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString(HEADER_ENCODING);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExternalDiffCommand(OutputStream outputStream, final String string, File file, File file2, String string2, String string3) throws SVNException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (this.rawDiffOptions != null) {
            arrayList.addAll(this.rawDiffOptions);
        } else {
            Collection collection = this.getDiffOptions().toOptionsCollection();
            arrayList.addAll(collection);
            arrayList.add("-u");
        }
        if (string2 != null) {
            arrayList.add("-L");
            arrayList.add(string2);
        }
        if (string3 != null) {
            arrayList.add("-L");
            arrayList.add(string3);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (file == null) {
            file = SVNFileUtil.createTempFile((String)"svn.", (String)".tmp");
            bl = true;
        }
        if (file2 == null) {
            file2 = SVNFileUtil.createTempFile((String)"svn.", (String)".tmp");
            bl2 = true;
        }
        String string4 = file.getAbsolutePath().replace(File.separatorChar, '/');
        String string5 = file2.getAbsolutePath().replace(File.separatorChar, '/');
        arrayList.add(string4);
        arrayList.add(string5);
        try {
            final OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
            SVNFileUtil.execCommand((String[])arrayList.toArray(new String[arrayList.size()]), (boolean)true, (ISVNReturnValueCallback)new ISVNReturnValueCallback(){

                public void handleReturnValue(int n2) throws SVNException {
                    if (n2 != 0 && n2 != 1) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.EXTERNAL_PROGRAM, (String)"''{0}'' returned {1}", (Object[])new Object[]{string, String.valueOf(n2)});
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.DEFAULT);
                    }
                }

                public void handleChar(char c2) throws SVNException {
                    try {
                        outputStreamWriter.write(c2);
                    }
                    catch (IOException iOException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)iOException.getMessage());
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (Throwable)iOException, (SVNLogType)SVNLogType.DEFAULT);
                    }
                }

                public boolean isHandleProgramOutput() {
                    return true;
                }
            });
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)iOException.getMessage());
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (Throwable)iOException, (SVNLogType)SVNLogType.DEFAULT);
        }
        finally {
            try {
                if (bl) {
                    SVNFileUtil.deleteFile((File)file);
                }
                if (bl2) {
                    SVNFileUtil.deleteFile((File)file2);
                }
            }
            catch (SVNException sVNException) {}
        }
    }

    private String getExternalDiffCommand() {
        return this.externalDiffCommand;
    }

    private void displayMimeType(OutputStream outputStream, String string) throws SVNException {
        try {
            this.displayString(outputStream, "svn:mime-type");
            this.displayString(outputStream, " = ");
            this.displayString(outputStream, string);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayMimeTypes(OutputStream outputStream, String string, String string2) throws SVNException {
        try {
            this.displayString(outputStream, "svn:mime-type");
            this.displayString(outputStream, " = (");
            this.displayString(outputStream, string);
            this.displayString(outputStream, ", ");
            this.displayString(outputStream, string2);
            this.displayString(outputStream, ")");
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayCannotDisplayFileMarkedBinary(OutputStream outputStream) throws SVNException {
        try {
            this.displayString(outputStream, "Cannot display: file marked as a binary type.");
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void ensureEncodingAndEOLSet() {
        if (this.getEOL() == null) {
            this.setEOL(SVNProperty.EOL_LF_BYTES);
        }
        if (this.getEncoding() == null) {
            ISVNOptions iSVNOptions = this.getOptions();
            if (iSVNOptions != null && iSVNOptions.getNativeCharset() != null) {
                this.setEncoding(iSVNOptions.getNativeCharset());
            } else {
                this.setEncoding(HEADER_ENCODING);
            }
        }
    }

    private void displayPropDiffValues(OutputStream outputStream, SVNProperties sVNProperties, SVNProperties sVNProperties2) throws SVNException {
        for (String string : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties2 != null ? sVNProperties2.getSVNPropertyValue(string) : null;
            SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
            String string2 = null;
            string2 = sVNPropertyValue == null ? "Added: " : (sVNPropertyValue2 == null ? "Deleted: " : "Modified: ");
            try {
                this.displayString(outputStream, string2 + string);
                this.displayEOL(outputStream);
                if ("svn:mergeinfo".equals(string)) {
                    this.displayMergeInfoDiff(outputStream, sVNPropertyValue == null ? null : sVNPropertyValue.getString(), sVNPropertyValue2 == null ? null : sVNPropertyValue2.getString());
                    continue;
                }
                byte[] byArray = this.getPropertyAsBytes(sVNPropertyValue, this.getEncoding());
                byte[] byArray2 = this.getPropertyAsBytes(sVNPropertyValue2, this.getEncoding());
                byArray = byArray == null ? new byte[]{} : this.maybeAppendEOL(byArray);
                boolean bl = byArray2 != null && byArray2.length > 0 && (byArray2[byArray2.length - 1] == SVNProperty.EOL_CR_BYTES[0] || byArray2[byArray2.length - 1] == SVNProperty.EOL_LF_BYTES[0]);
                byArray2 = byArray2 == null ? new byte[]{} : this.maybeAppendEOL(byArray2);
                QDiffUniGenerator.setup();
                SVNHashMap sVNHashMap = new SVNHashMap();
                sVNHashMap.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
                sVNHashMap.put("eol", new String(this.getEOL()));
                sVNHashMap.put("hunk-delimiter", "##");
                if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                    sVNHashMap.put("ignore-space", "all-space");
                } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                    sVNHashMap.put("ignore-space", "space-change");
                }
                QDiffUniGenerator qDiffUniGenerator = new QDiffUniGenerator((Map)sVNHashMap, "");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
                QDiffManager.generateTextDiff((InputStream)new ByteArrayInputStream(byArray), (InputStream)new ByteArrayInputStream(byArray2), null, (Writer)outputStreamWriter, (QDiffGenerator)qDiffUniGenerator);
                ((Writer)outputStreamWriter).flush();
                if (bl) continue;
                this.displayString(outputStream, "\\ No newline at end of property");
                this.displayEOL(outputStream);
            }
            catch (IOException iOException) {
                this.wrapException(iOException);
            }
        }
    }

    private byte[] maybeAppendEOL(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        byte by = byArray[byArray.length - 1];
        if (by == SVNProperty.EOL_CR_BYTES[0]) {
            return byArray;
        }
        if (by != SVNProperty.EOL_LF_BYTES[0]) {
            byte[] byArray2 = new byte[byArray.length + this.getEOL().length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(this.getEOL(), 0, byArray2, byArray.length, this.getEOL().length);
            return byArray2;
        }
        return byArray;
    }

    private String getGitDiffLabel1(SvnDiffCallback.OperationKind operationKind, String string, String string2, String string3, String string4) {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            return this.getLabel("a/" + string, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            return this.getLabel("a/" + string3, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Added) {
            return this.getLabel("/dev/null", string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            return this.getLabel("a/" + string, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            return this.getLabel("a/" + string3, string4);
        }
        throw new IllegalArgumentException("Unsupported operation: " + operationKind);
    }

    private String getGitDiffLabel2(SvnDiffCallback.OperationKind operationKind, String string, String string2, String string3, String string4) {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            return this.getLabel("/dev/null", string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            return this.getLabel("b/" + string2, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Added) {
            return this.getLabel("b/" + string2, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            return this.getLabel("b/" + string2, string4);
        }
        if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            return this.getLabel("b/" + string2, string4);
        }
        throw new IllegalArgumentException("Unsupported operation: " + operationKind);
    }

    private void displayGitDiffHeader(OutputStream outputStream, SvnDiffCallback.OperationKind operationKind, String string, String string2, String string3) throws SVNException {
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            this.displayGitDiffHeaderDeleted(outputStream, string, string2, string3);
        } else if (operationKind == SvnDiffCallback.OperationKind.Copied) {
            this.displayGitDiffHeaderCopied(outputStream, string, string2, string3);
        } else if (operationKind == SvnDiffCallback.OperationKind.Added) {
            this.displayGitDiffHeaderAdded(outputStream, string, string2, string3);
        } else if (operationKind == SvnDiffCallback.OperationKind.Modified) {
            this.displayGitDiffHeaderModified(outputStream, string, string2, string3);
        } else if (operationKind == SvnDiffCallback.OperationKind.Moved) {
            this.displayGitDiffHeaderRenamed(outputStream, string, string2, string3);
        }
    }

    private void displayGitDiffHeaderAdded(OutputStream outputStream, String string, String string2, String string3) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, string);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, string2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "new file mode 10644");
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayGitDiffHeaderDeleted(OutputStream outputStream, String string, String string2, String string3) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, string);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, string2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "deleted file mode 10644");
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayGitDiffHeaderCopied(OutputStream outputStream, String string, String string2, String string3) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, string3);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, string2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "copy from ");
            this.displayString(outputStream, string3);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "copy to ");
            this.displayString(outputStream, string2);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayGitDiffHeaderRenamed(OutputStream outputStream, String string, String string2, String string3) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, string3);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, string2);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "rename from ");
            this.displayString(outputStream, string3);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "rename to ");
            this.displayString(outputStream, string2);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayGitDiffHeaderModified(OutputStream outputStream, String string, String string2, String string3) throws SVNException {
        try {
            this.displayString(outputStream, "diff --git ");
            this.displayFirstGitPath(outputStream, string);
            this.displayString(outputStream, " ");
            this.displaySecondGitPath(outputStream, string2);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayFirstGitPath(OutputStream outputStream, String string) throws IOException {
        this.displayGitPath(outputStream, string, "a/", false);
    }

    private void displaySecondGitPath(OutputStream outputStream, String string) throws IOException {
        this.displayGitPath(outputStream, string, "b/", false);
    }

    private void displayFirstGitLabelPath(OutputStream outputStream, String string, String string2, SvnDiffCallback.OperationKind operationKind) throws IOException {
        String string3 = "a/";
        if (operationKind == SvnDiffCallback.OperationKind.Added) {
            string = "/dev/null";
            string3 = "";
        }
        this.displayGitPath(outputStream, this.getLabel(string, string2), string3, true);
    }

    private void displaySecondGitLabelPath(OutputStream outputStream, String string, String string2, SvnDiffCallback.OperationKind operationKind) throws IOException {
        String string3 = "b/";
        if (operationKind == SvnDiffCallback.OperationKind.Deleted) {
            string = "/dev/null";
            string3 = "";
        }
        this.displayGitPath(outputStream, this.getLabel(string, string2), string3, true);
    }

    private void displayGitPath(OutputStream outputStream, String string, String string2, boolean bl) throws IOException {
        this.displayString(outputStream, string2);
        this.displayString(outputStream, string);
    }

    private String getAdjustedPathWithLabel(String string, String string2, String string3, String string4) {
        String string5 = this.getAdjustedPath(string, string2, string4);
        return this.getLabel(string5, string3);
    }

    private String getAdjustedPath(String string, String string2, String string3) {
        String string4 = this.getRelativePath(string2, string3);
        string4 = string4 == null || string4.length() == 0 ? string : (string4.charAt(0) == '/' ? string + "\t(..." + string4 + ")" : string + "\t(.../" + string4 + ")");
        return string4;
    }

    protected String getLabel(String string, String string2) {
        string2 = string2 == null ? WC_REVISION_LABEL : string2;
        return string + "\t" + string2;
    }

    protected boolean displayHeader(OutputStream outputStream, String string, boolean bl, boolean bl2, SvnDiffCallback.OperationKind operationKind) throws SVNException {
        try {
            if (bl && !this.isDiffDeleted()) {
                this.displayString(outputStream, "Index: ");
                this.displayString(outputStream, string);
                this.displayString(outputStream, " (deleted)");
                this.displayEOL(outputStream);
                this.displayString(outputStream, HEADER_SEPARATOR);
                this.displayEOL(outputStream);
                return true;
            }
            if (bl2 && !this.isDiffAdded()) {
                this.displayString(outputStream, "Index: ");
                this.displayString(outputStream, string);
                this.displayString(outputStream, " (added)");
                this.displayEOL(outputStream);
                this.displayString(outputStream, HEADER_SEPARATOR);
                this.displayEOL(outputStream);
                return true;
            }
            this.displayString(outputStream, "Index: ");
            this.displayString(outputStream, string);
            this.displayEOL(outputStream);
            this.displayString(outputStream, HEADER_SEPARATOR);
            this.displayEOL(outputStream);
            return false;
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
            return false;
        }
    }

    protected void displayHeaderFields(OutputStream outputStream, String string, String string2) throws SVNException {
        try {
            this.displayString(outputStream, "--- ");
            this.displayString(outputStream, string);
            this.displayEOL(outputStream);
            this.displayString(outputStream, "+++ ");
            this.displayString(outputStream, string2);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private void displayPropertyChangesOn(String string, OutputStream outputStream) throws SVNException {
        try {
            this.displayEOL(outputStream);
            this.displayString(outputStream, "Property changes on: " + (this.useLocalFileSeparatorChar() ? string.replace('/', File.separatorChar) : string));
            this.displayEOL(outputStream);
            this.displayString(outputStream, PROPERTIES_SEPARATOR);
            this.displayEOL(outputStream);
        }
        catch (IOException iOException) {
            this.wrapException(iOException);
        }
    }

    private byte[] getPropertyAsBytes(SVNPropertyValue sVNPropertyValue, String string) {
        if (sVNPropertyValue == null) {
            return null;
        }
        if (sVNPropertyValue.isString()) {
            try {
                return sVNPropertyValue.getString().getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return sVNPropertyValue.getString().getBytes();
            }
        }
        return sVNPropertyValue.getBytes();
    }

    private void displayMergeInfoDiff(OutputStream outputStream, String string, String string2) throws SVNException, IOException {
        SVNMergeRangeList sVNMergeRangeList;
        Map map = null;
        Map map2 = null;
        if (string != null) {
            map = SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(string), null);
        }
        if (string2 != null) {
            map2 = SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(string2), null);
        }
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfo(treeMap, treeMap2, (Map)map, (Map)map2, (boolean)true);
        for (String string3 : treeMap.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)treeMap.get(string3);
            this.displayString(outputStream, "   Reverse-merged " + string3 + ":r");
            this.displayString(outputStream, sVNMergeRangeList.toString());
            this.displayEOL(outputStream);
        }
        for (String string3 : treeMap2.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)treeMap2.get(string3);
            this.displayString(outputStream, "   Merged " + string3 + ":r");
            this.displayString(outputStream, sVNMergeRangeList.toString());
            this.displayEOL(outputStream);
        }
    }

    private boolean useLocalFileSeparatorChar() {
        return true;
    }

    public boolean isDiffDeleted() {
        return this.diffDeleted;
    }

    public boolean isDiffAdded() {
        return this.diffAdded;
    }

    private void wrapException(IOException iOException) throws SVNException {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (Throwable)iOException);
        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (Throwable)iOException, (SVNLogType)SVNLogType.WC);
    }

    private void displayString(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(HEADER_ENCODING));
    }

    private void displayEOL(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEOL());
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.diffOptions == null) {
            this.diffOptions = new SVNDiffOptions();
        }
        return this.diffOptions;
    }

    public void setExternalDiffCommand(String string) {
        this.externalDiffCommand = string;
    }

    public void setRawDiffOptions(List<String> list) {
        this.rawDiffOptions = list;
    }

    public void setDiffOptions(SVNDiffOptions sVNDiffOptions) {
        this.diffOptions = sVNDiffOptions;
    }

    public void setDiffDeleted(boolean bl) {
        this.diffDeleted = bl;
    }

    public void setDiffAdded(boolean bl) {
        this.diffAdded = bl;
    }

    public void setBasePath(File file) {
        this.setBaseTarget(SvnTarget.fromFile((File)file));
    }

    public void setFallbackToAbsolutePath(boolean bl) {
        this.fallbackToAbsolutePath = bl;
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        this.options = iSVNOptions;
    }

    public ISVNOptions getOptions() {
        return this.options;
    }

    private class EmptyDetectionOutputStream
    extends OutputStream {
        private final OutputStream outputStream;
        private boolean somethingWritten;

        public EmptyDetectionOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            this.somethingWritten = false;
        }

        public boolean isSomethingWritten() {
            return this.somethingWritten;
        }

        @Override
        public void write(int n2) throws IOException {
            this.somethingWritten = true;
            this.outputStream.write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.somethingWritten = byArray.length > 0;
            this.outputStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.somethingWritten = n3 > 0;
            this.outputStream.write(byArray, n2, n3);
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }
    }
}

