/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XPathMatcher {
    protected String fXpathDefaultNamespace;
    protected Object fMatchedString;
    LocationPathMatcher[] lpMatchers;

    public XPathMatcher(XPath xPath) {
        XPath.LocationPath[] locationPathArray = xPath.getLocationPaths();
        this.lpMatchers = new LocationPathMatcher[locationPathArray.length];
        for (int i2 = 0; i2 < locationPathArray.length; ++i2) {
            this.lpMatchers[i2] = new LocationPathMatcher(locationPathArray[i2]);
        }
    }

    public boolean isMatched() {
        for (LocationPathMatcher locationPathMatcher : this.lpMatchers) {
            if (!locationPathMatcher.isMatched()) continue;
            return true;
        }
        return false;
    }

    protected void handleContent(XSTypeDefinition xSTypeDefinition, boolean bl, Object object, short s2, ShortList shortList) {
    }

    protected void matched(Object object, short s2, ShortList shortList, boolean bl) {
    }

    public void startDocumentFragment() {
        for (LocationPathMatcher locationPathMatcher : this.lpMatchers) {
            locationPathMatcher.reset();
        }
        this.fMatchedString = null;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes) {
        for (LocationPathMatcher locationPathMatcher : this.lpMatchers) {
            locationPathMatcher.onStartElement(qName, xMLAttributes);
        }
    }

    public void endElement(QName qName, XSTypeDefinition xSTypeDefinition, boolean bl, Object object, short s2, ShortList shortList) {
        if (this.isMatched()) {
            this.handleContent(xSTypeDefinition, bl, object, s2, shortList);
        }
        for (LocationPathMatcher locationPathMatcher : this.lpMatchers) {
            locationPathMatcher.onEndElement();
        }
    }

    private static boolean matches(XPath.NodeTest nodeTest, QName qName) {
        if (nodeTest.type == 1) {
            return nodeTest.name.equals((Object)qName);
        }
        if (nodeTest.type == 4) {
            return nodeTest.name.uri == qName.uri;
        }
        return true;
    }

    public void setXPathDefaultNamespace(String string) {
        this.fXpathDefaultNamespace = string;
    }

    public class LocationPathMatcher {
        private XPath.LocationPath lp;
        private int[] indices;
        private IntStack indicesStack = new IntStack();
        private int[] nextIndices;
        private int nextSize;

        public LocationPathMatcher(XPath.LocationPath locationPath) {
            this.lp = locationPath;
            this.nextIndices = new int[locationPath.steps.length + 1];
            this.reset();
        }

        public void reset() {
            this.indices = new int[]{0};
            this.indicesStack.clear();
        }

        public void onStartElement(QName qName, XMLAttributes xMLAttributes) {
            int n2;
            this.nextSize = 0;
            for (n2 = 0; n2 < this.indices.length; ++n2) {
                this.matchAtStep(this.indices[n2], qName, xMLAttributes);
            }
            for (n2 = 0; n2 < this.indices.length; ++n2) {
                this.indicesStack.push(this.indices[n2]);
            }
            this.indicesStack.push(this.indices.length);
            if (this.indices.length != this.nextSize) {
                this.indices = new int[this.nextSize];
            }
            System.arraycopy(this.nextIndices, 0, this.indices, 0, this.nextSize);
        }

        public void onEndElement() {
            int n2 = this.indicesStack.pop();
            if (this.indices.length != n2) {
                this.indices = new int[n2];
            }
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                this.indices[i2] = this.indicesStack.pop();
            }
        }

        public boolean isMatched() {
            return this.indices.length > 0 && this.indices[this.indices.length - 1] == this.lp.steps.length;
        }

        private void matchAtStep(int n2, QName qName, XMLAttributes xMLAttributes) {
            if (n2 == this.lp.steps.length) {
                return;
            }
            XPath.Step step = this.lp.steps[n2];
            XPath.NodeTest nodeTest = step.nodeTest;
            if (nodeTest.name.uri == null) {
                nodeTest.name.uri = XPathMatcher.this.fXpathDefaultNamespace;
            }
            if (step.axis.type == 4) {
                this.addNextIndex(n2);
                this.matchAtStep(n2 + 1, qName, xMLAttributes);
            } else if (step.axis.type == 3 || step.axis.type == 1 && XPathMatcher.matches(step.nodeTest, qName)) {
                int n3;
                for (n3 = n2 + 1; n3 < this.lp.steps.length && this.lp.steps[n3].axis.type == 3; ++n3) {
                }
                if (n3 < this.lp.steps.length && this.lp.steps[n3].axis.type == 2) {
                    int n4 = xMLAttributes.getLength();
                    QName qName2 = new QName();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        xMLAttributes.getName(i2, qName2);
                        if (this.lp.steps[n3].nodeTest.name.uri == null) {
                            this.lp.steps[n3].nodeTest.name.uri = XPathMatcher.this.fXpathDefaultNamespace;
                        }
                        if (!XPathMatcher.matches(this.lp.steps[n3].nodeTest, qName2) || n3 + 1 != this.lp.steps.length) continue;
                        AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(i2).getItem("ATTRIBUTE_PSVI");
                        XPathMatcher.this.fMatchedString = attributePSVI.getActualNormalizedValue();
                        XPathMatcher.this.matched(XPathMatcher.this.fMatchedString, attributePSVI.getActualNormalizedValueType(), attributePSVI.getItemValueTypes(), false);
                    }
                } else {
                    this.addNextIndex(n3);
                }
            }
        }

        private void addNextIndex(int n2) {
            if (this.nextSize == 0 || this.nextIndices[this.nextSize - 1] != n2) {
                this.nextIndices[this.nextSize++] = n2;
            }
        }
    }
}

