/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.relaxng.match.MatchContext;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.match.NameClass;
import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivFunction;
import com.thaiopensource.relaxng.pattern.FindElementFunction;
import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.util.Equal;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.util.Name;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public class PatternMatcher
implements Cloneable,
Matcher {
    private PatternMemo memo;
    private boolean textTyped;
    private boolean hadError;
    private boolean ignoreNextEndTagOrAttributeValue;
    private String errorMessage;
    private final Shared shared;
    private List<DataDerivFailure> dataDerivFailureList = new ArrayList<DataDerivFailure>();
    private String errorKey;
    private String[] errorArgs;
    private static final int UNDEFINED_TOKEN_INDEX = -3;
    private static final int INCONSISTENT_TOKEN_INDEX = -2;
    static final String[] GENERATED_PREFIXES = new String[]{"ns", "ns-", "ns_", "NS", "NS-", "NS_"};
    private static final int FORMAT_NAMES_ELEMENT = 0;
    private static final int FORMAT_NAMES_ATTRIBUTE = 1;
    private static final int FORMAT_NAMES_AND = 0;
    private static final int FORMAT_NAMES_OR = 2;

    public PatternMatcher(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
        this.shared = new Shared(pattern, validatorPatternBuilder);
        this.memo = validatorPatternBuilder.getPatternMemo(pattern);
    }

    private PatternMatcher(PatternMemo patternMemo, Shared shared) {
        this.memo = patternMemo;
        this.shared = shared;
    }

    public Matcher start() {
        return new PatternMatcher(this.shared.builder.getPatternMemo(this.shared.start), this.shared);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PatternMatcher)) {
            return false;
        }
        PatternMatcher patternMatcher = (PatternMatcher)object;
        return this.memo == patternMatcher.memo && this.hadError == patternMatcher.hadError && Equal.equal((Object)this.errorMessage, (Object)patternMatcher.errorMessage) && this.ignoreNextEndTagOrAttributeValue == patternMatcher.ignoreNextEndTagOrAttributeValue && this.textTyped == patternMatcher.textTyped;
    }

    public int hashCode() {
        return this.memo.hashCode();
    }

    public final Object clone() {
        try {
            PatternMatcher patternMatcher = (PatternMatcher)super.clone();
            patternMatcher.dataDerivFailureList = new ArrayList<DataDerivFailure>();
            return patternMatcher;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Matcher copy() {
        return (Matcher)this.clone();
    }

    public boolean matchStartDocument() {
        if (this.memo.isNotAllowed()) {
            return this.error("schema_allows_nothing");
        }
        return true;
    }

    public boolean matchEndDocument() {
        return true;
    }

    public boolean matchStartTagOpen(Name name, String string, MatchContext matchContext) {
        if (this.setMemo(this.memo.startTagOpenDeriv(name))) {
            return true;
        }
        PatternMemo patternMemo = this.memo.startTagOpenRecoverDeriv(name);
        boolean bl = this.ignoreError();
        if (!patternMemo.isNotAllowed()) {
            if (!bl) {
                Set<Name> set = this.requiredElementNames();
                if (!set.isEmpty()) {
                    this.error(set.size() == 1 ? "unexpected_element_required_element_missing" : "unexpected_element_required_elements_missing", this.errorArgQName(string, name, matchContext, false), PatternMatcher.formatNames(set, 0, matchContext));
                } else {
                    this.error("element_not_allowed_yet", this.errorArgQName(string, name, matchContext, false), this.expectedContent(matchContext));
                }
            }
        } else {
            ValidatorPatternBuilder validatorPatternBuilder = this.shared.builder;
            patternMemo = validatorPatternBuilder.getPatternMemo(validatorPatternBuilder.makeAfter(this.shared.findElement(name), this.memo.getPattern()));
            if (!bl) {
                this.error(patternMemo.isNotAllowed() ? "unknown_element" : "out_of_context_element", this.errorArgQName(string, name, matchContext, false), this.expectedContent(matchContext));
            }
        }
        this.memo = patternMemo;
        return bl;
    }

    public boolean matchAttributeName(Name name, String string, MatchContext matchContext) {
        if (this.setMemo(this.memo.startAttributeDeriv(name))) {
            return true;
        }
        this.ignoreNextEndTagOrAttributeValue = true;
        boolean bl = this.ignoreError();
        if (bl) {
            return true;
        }
        string = this.errorArgQName(string, name, matchContext, true);
        NormalizedNameClass normalizedNameClass = this.memo.possibleAttributeNames();
        if (normalizedNameClass.isEmpty()) {
            this.error("no_attributes_allowed", string);
        } else {
            this.error("invalid_attribute_name", string, this.expectedAttributes(matchContext));
        }
        return false;
    }

    public boolean matchAttributeValue(String string, Name name, String string2, MatchContext matchContext) {
        if (this.ignoreNextEndTagOrAttributeValue) {
            this.ignoreNextEndTagOrAttributeValue = false;
            return true;
        }
        this.dataDerivFailureList.clear();
        if (this.setMemo(this.memo.dataDeriv(string, (ValidationContext)matchContext, this.dataDerivFailureList))) {
            return true;
        }
        boolean bl = this.error("invalid_attribute_value", this.errorArgQName(string2, name, matchContext, true), this.formatDataDerivFailures(string, matchContext));
        this.memo = this.memo.recoverAfter();
        return bl;
    }

    public boolean matchStartTagClose(Name name, String string, MatchContext matchContext) {
        boolean bl;
        if (this.setMemo(this.memo.endAttributes())) {
            bl = true;
        } else {
            bl = this.ignoreError();
            if (!bl) {
                Set<Name> set = this.requiredAttributeNames();
                if (set.isEmpty()) {
                    this.error("required_attributes_missing_expected", this.errorArgQName(string, name, matchContext, false), this.expectedAttributes(matchContext));
                } else {
                    this.error(set.size() == 1 ? "required_attribute_missing" : "required_attributes_missing", this.errorArgQName(string, name, matchContext, false), PatternMatcher.formatNames(set, 1, matchContext));
                }
            }
            this.memo = this.memo.ignoreMissingAttributes();
        }
        this.textTyped = this.memo.getPattern().getContentType() == 3;
        return bl;
    }

    public boolean matchTextBeforeEndTag(String string, Name name, String string2, MatchContext matchContext) {
        if (this.textTyped) {
            this.ignoreNextEndTagOrAttributeValue = true;
            return this.setDataDeriv(string, name, string2, matchContext);
        }
        return this.matchUntypedText(string, matchContext);
    }

    public boolean matchTextBeforeStartTag(String string, MatchContext matchContext) {
        return this.matchUntypedText(string, matchContext);
    }

    private boolean matchUntypedText(String string, MatchContext matchContext) {
        if (DataDerivFunction.isBlank((String)string)) {
            return true;
        }
        return this.matchUntypedText(matchContext);
    }

    public boolean matchUntypedText(MatchContext matchContext) {
        if (this.setMemo(this.memo.mixedTextDeriv())) {
            return true;
        }
        return this.error("text_not_allowed", this.expectedContent(matchContext));
    }

    public boolean isTextTyped() {
        return this.textTyped;
    }

    private boolean setDataDeriv(String string, Name name, String string2, MatchContext matchContext) {
        this.textTyped = false;
        PatternMemo patternMemo = this.memo.textOnly();
        this.dataDerivFailureList.clear();
        if (this.setMemo(patternMemo.dataDeriv(string, (ValidationContext)matchContext, this.dataDerivFailureList))) {
            return true;
        }
        PatternMemo patternMemo2 = this.memo.recoverAfter();
        boolean bl = this.ignoreError();
        if (!(bl || patternMemo2.isNotAllowed() && !patternMemo.emptyAfter().dataDeriv(string, (ValidationContext)matchContext).isNotAllowed())) {
            NormalizedNameClass normalizedNameClass = this.memo.possibleStartTagNames();
            if (!normalizedNameClass.isEmpty() && DataDerivFunction.isBlank((String)string)) {
                this.error("blank_not_allowed", this.errorArgQName(string2, name, matchContext, false), this.expectedContent(matchContext));
            } else {
                this.error("invalid_element_value", this.errorArgQName(string2, name, matchContext, false), this.formatDataDerivFailures(string, matchContext));
            }
        }
        this.memo = patternMemo2;
        return bl;
    }

    public boolean matchEndTag(Name name, String string, MatchContext matchContext) {
        if (this.ignoreNextEndTagOrAttributeValue) {
            this.ignoreNextEndTagOrAttributeValue = false;
            return true;
        }
        if (this.textTyped) {
            return this.setDataDeriv("", name, string, matchContext);
        }
        if (this.setMemo(this.memo.endTagDeriv())) {
            return true;
        }
        boolean bl = this.ignoreError();
        PatternMemo patternMemo = this.memo.recoverAfter();
        if (!(bl || patternMemo.isNotAllowed() && !this.memo.emptyAfter().endTagDeriv().isNotAllowed())) {
            Set<Name> set = this.requiredElementNames();
            if (!set.isEmpty()) {
                this.error(set.size() == 1 ? "incomplete_element_required_element_missing" : "incomplete_element_required_elements_missing", this.errorArgQName(string, name, matchContext, false), PatternMatcher.formatNames(set, 0, matchContext));
            } else {
                this.error("incomplete_element_required_elements_missing_expected", this.errorArgQName(string, name, matchContext, false), this.expectedContent(matchContext));
            }
        }
        this.memo = patternMemo;
        return bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public String[] getErrorArgs() {
        return this.errorArgs;
    }

    public boolean isValidSoFar() {
        return !this.hadError;
    }

    public NameClass possibleStartTagNames() {
        return this.memo.possibleStartTagNames();
    }

    public NameClass possibleAttributeNames() {
        return this.memo.possibleAttributeNames();
    }

    public Set<Name> requiredElementNames() {
        return (Set)this.memo.getPattern().apply(this.shared.builder.getRequiredElementsFunction());
    }

    public Set<Name> requiredAttributeNames() {
        return (Set)this.memo.getPattern().apply(this.shared.builder.getRequiredAttributesFunction());
    }

    private boolean setMemo(PatternMemo patternMemo) {
        if (patternMemo.isNotAllowed()) {
            return false;
        }
        this.memo = patternMemo;
        return true;
    }

    private boolean ignoreError() {
        return this.hadError && this.memo.isNotAllowed();
    }

    private boolean error(String string) {
        return this.error(string, new String[0]);
    }

    private boolean error(String string, String string2) {
        return this.error(string, new String[]{string2});
    }

    private boolean error(String string, String string2, String string3) {
        return this.error(string, new String[]{string2, string3});
    }

    private boolean error(String string, String string2, String string3, String string4) {
        return this.error(string, new String[]{string2, string3, string4});
    }

    private boolean error(String string, String[] stringArray) {
        if (this.ignoreError()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = PatternMatcher.localizer().message(string, (Object[])stringArray);
        this.errorKey = string;
        this.errorArgs = stringArray;
        return false;
    }

    private String errorArgQName(String string, Name name, MatchContext matchContext, boolean bl) {
        if (this.ignoreError()) {
            return null;
        }
        if (string == null || string.length() == 0) {
            String string2;
            String string3 = name.getNamespaceUri();
            String string4 = name.getLocalName();
            string = string3.length() == 0 || !bl && string3.equals(matchContext.resolveNamespacePrefix("")) ? string4 : ((string2 = matchContext.getPrefix(string3)) != null ? string2 + ":" + string4 : "{" + string3 + "}" + string4);
        }
        return PatternMatcher.quoteQName(string);
    }

    private String formatDataDerivFailures(String string, MatchContext matchContext) {
        AbstractCollection abstractCollection;
        if (this.ignoreError()) {
            return null;
        }
        if (this.dataDerivFailureList.size() == 0) {
            return "";
        }
        if (this.dataDerivFailureList.size() > 1) {
            abstractCollection = new HashSet();
            abstractCollection.addAll(this.dataDerivFailureList);
            this.dataDerivFailureList.clear();
            this.dataDerivFailureList.addAll(abstractCollection);
        }
        abstractCollection = new ArrayList();
        HashSet<Name> hashSet = new HashSet<Name>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = -3;
        int n3 = -1;
        int n4 = -1;
        block4: for (DataDerivFailure dataDerivFailure : this.dataDerivFailureList) {
            Object object;
            Datatype datatype = dataDerivFailure.getDatatype();
            String string2 = dataDerivFailure.getStringValue();
            if (string2 != null) {
                object = dataDerivFailure.getValue();
                if (object instanceof Name && datatype instanceof Datatype2) {
                    hashSet.add((Name)object);
                } else if (object instanceof String && datatype instanceof Datatype2) {
                    abstractCollection.add((String)object);
                } else {
                    abstractCollection.add(string2);
                }
            } else {
                object = dataDerivFailure.getMessage();
                if (object != null) {
                    arrayList.add((String)object);
                } else {
                    if (dataDerivFailure.getExcept() != null) {
                        return "";
                    }
                    arrayList.add(PatternMatcher.localizer().message("require_datatype", (Object)dataDerivFailure.getDatatypeName().getLocalName()));
                }
            }
            switch (n2) {
                case -2: {
                    continue block4;
                }
                case -3: {
                    n2 = dataDerivFailure.getTokenIndex();
                    n3 = dataDerivFailure.getTokenStart();
                    n4 = dataDerivFailure.getTokenEnd();
                    continue block4;
                }
            }
            if (n2 == dataDerivFailure.getTokenIndex()) continue;
            n2 = -2;
        }
        if (abstractCollection.size() > 0) {
            Collections.sort(abstractCollection);
            for (int i2 = 0; i2 < abstractCollection.size(); ++i2) {
                abstractCollection.set(i2, this.quoteValue((String)abstractCollection.get(i2)));
            }
            arrayList.add(PatternMatcher.localizer().message("require_values", (Object)PatternMatcher.formatList((List<String>)((Object)abstractCollection), "or")));
        }
        if (hashSet.size() > 0) {
            arrayList.add(PatternMatcher.localizer().message("require_qnames", (Object)PatternMatcher.formatNames(hashSet, 2, matchContext)));
        }
        if (arrayList.size() == 0) {
            return "";
        }
        String string3 = PatternMatcher.formatList(arrayList, "or");
        if (n2 >= 0 && n3 >= 0 && n4 <= string.length()) {
            if (n3 == string.length()) {
                return PatternMatcher.localizer().message("missing_token", (Object)string3);
            }
            return PatternMatcher.localizer().message("token_failures", (Object)this.quoteValue(string.substring(n3, n4)), (Object)string3);
        }
        return PatternMatcher.localizer().message("data_failures", (Object)string3);
    }

    private String quoteValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        PatternMatcher.appendAttributeValue(stringBuilder, string);
        return stringBuilder.toString();
    }

    private String expectedAttributes(MatchContext matchContext) {
        if (this.ignoreError()) {
            return null;
        }
        NormalizedNameClass normalizedNameClass = this.memo.possibleAttributeNames();
        if (normalizedNameClass.isEmpty()) {
            return "";
        }
        Set set = normalizedNameClass.getIncludedNames();
        if (!set.isEmpty()) {
            return PatternMatcher.localizer().message(normalizedNameClass.isAnyNameIncluded() || !normalizedNameClass.getIncludedNamespaces().isEmpty() ? "expected_attribute_or_other_ns" : "expected_attribute", (Object)PatternMatcher.formatNames(set, 3, matchContext));
        }
        return "";
    }

    private String expectedContent(MatchContext matchContext) {
        if (this.ignoreError()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.memo.endTagDeriv().isNotAllowed()) {
            arrayList.add(PatternMatcher.localizer().message("element_end_tag"));
        }
        switch (this.memo.emptyAfter().getPattern().getContentType()) {
            case 2: {
                if (this.memo.mixedTextDeriv().isNotAllowed()) break;
                arrayList.add(PatternMatcher.localizer().message("text"));
                break;
            }
            case 3: {
                arrayList.add(PatternMatcher.localizer().message("data"));
            }
        }
        NormalizedNameClass normalizedNameClass = this.memo.possibleStartTagNames();
        Set set = normalizedNameClass.getIncludedNames();
        if (!set.isEmpty()) {
            arrayList.add(PatternMatcher.localizer().message("element_list", (Object)PatternMatcher.formatNames(set, 2, matchContext)));
            if (normalizedNameClass.isAnyNameIncluded() || !normalizedNameClass.getIncludedNamespaces().isEmpty()) {
                arrayList.add(PatternMatcher.localizer().message("element_other_ns"));
            }
        }
        if (arrayList.isEmpty()) {
            return "";
        }
        return PatternMatcher.localizer().message("expected", (Object)PatternMatcher.formatList(arrayList, "or"));
    }

    private static String formatNames(Set<Name> set, int n2, MatchContext matchContext) {
        if (set.isEmpty()) {
            return "";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = PatternMatcher.generateQNames(set, n2, matchContext, hashMap);
        Collections.sort(list);
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            list.set(i2, PatternMatcher.quoteQName(list.get(i2)));
        }
        String string = PatternMatcher.formatList(list, (n2 & 2) != 0 ? "or" : "and");
        if (hashMap.size() != 0) {
            string = PatternMatcher.localizer().message("qnames_nsdecls", (Object)string, (Object)PatternMatcher.formatNamespaceDecls(hashMap));
        }
        return string;
    }

    private static List<String> generateQNames(Set<Name> set, int n2, MatchContext matchContext, Map<String, String> map) {
        Name name2;
        String string;
        if ((n2 & 1) != 0) {
            string = "";
        } else {
            string = matchContext.resolveNamespacePrefix("");
            for (Name name2 : set) {
                if (name2.getNamespaceUri().length() != 0) continue;
                if (string != null) {
                    map.put("", "");
                }
                string = "";
                break;
            }
        }
        ArrayList arrayList = new ArrayList();
        name2 = new HashSet();
        ArrayList<Name> arrayList2 = new ArrayList<Name>();
        for (Name name3 : set) {
            String string2;
            String string3 = name3.getNamespaceUri();
            if (string3.equals(string)) {
                string2 = "";
            } else {
                string2 = matchContext.getPrefix(string3);
                if ((n2 & 1) != 0 && "".equals(string2) && !"".equals(string3)) {
                    string2 = null;
                }
            }
            if (string2 == null) {
                name2.add(string3);
                arrayList2.add(name3);
                continue;
            }
            arrayList.add(PatternMatcher.makeQName(string2, name3.getLocalName()));
        }
        if (arrayList2.isEmpty()) {
            return arrayList;
        }
        if (name2.size() == 1 && string == null) {
            map.put((String)name2.iterator().next(), "");
        } else {
            PatternMatcher.choosePrefixes((Set<String>)name2, matchContext, map);
        }
        for (Name name3 : arrayList2) {
            arrayList.add(PatternMatcher.makeQName(map.get(name3.getNamespaceUri()), name3.getLocalName()));
        }
        return arrayList;
    }

    private static void choosePrefixes(Set<String> set, MatchContext matchContext, Map<String, String> map) {
        int n2;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList);
        int n3 = arrayList.size();
        int n4 = 0;
        do {
            if (n4 < GENERATED_PREFIXES.length) {
                string = GENERATED_PREFIXES[n4];
            } else {
                string = "_" + GENERATED_PREFIXES[0];
                for (n2 = GENERATED_PREFIXES.length; n2 < n4; ++n2) {
                    string = string + "_" + string;
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (matchContext.resolveNamespacePrefix(n3 == 1 ? string : string + (n2 + 1)) == null) continue;
                string = null;
                break;
            }
            ++n4;
        } while (string == null);
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = (String)arrayList.get(n2);
            map.put(string2, n3 == 1 ? string : string + (n2 + 1));
        }
    }

    private static String formatList(List<String> list, String string) {
        int n2 = list.size();
        switch (n2) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
            case 2: {
                return PatternMatcher.localizer().message(string + "_list_pair", (Object)list.get(0), (Object)list.get(1));
            }
        }
        String string2 = PatternMatcher.localizer().message(string + "_list_many_first", (Object)list.get(0));
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            string2 = PatternMatcher.localizer().message(string + "_list_many_middle", (Object)string2, (Object)list.get(i2));
        }
        return PatternMatcher.localizer().message(string + "_list_many_last", (Object)string2, (Object)list.get(n2 - 1));
    }

    private static String formatNamespaceDecls(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> object : map.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = object.getValue();
            if (string.length() == 0) {
                stringBuilder.append("xmlns");
            } else {
                stringBuilder.append("xmlns:").append(string);
            }
            stringBuilder.append('=');
            PatternMatcher.appendAttributeValue(stringBuilder, object.getKey());
            arrayList.add(stringBuilder.toString());
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String quoteForAttributeValue(char c2) {
        switch (c2) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return "&#xA;";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\t': {
                return "&#x9;";
            }
        }
        return null;
    }

    private static StringBuilder appendAttributeValue(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            String string2 = PatternMatcher.quoteForAttributeValue(c2);
            if (string2 != null) {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    private static String makeQName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return string + ":" + string2;
    }

    private static String quoteQName(String string) {
        return PatternMatcher.localizer().message("qname", (Object)string);
    }

    private static Localizer localizer() {
        return SchemaBuilderImpl.localizer;
    }

    private static class Shared {
        private final Pattern start;
        private final ValidatorPatternBuilder builder;
        private Map<Name, Pattern> recoverPatternTable;

        Shared(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
            this.start = pattern;
            this.builder = validatorPatternBuilder;
        }

        Pattern findElement(Name name) {
            Pattern pattern;
            if (this.recoverPatternTable == null) {
                this.recoverPatternTable = new HashMap<Name, Pattern>();
            }
            if ((pattern = this.recoverPatternTable.get(name)) == null) {
                pattern = FindElementFunction.findElement((ValidatorPatternBuilder)this.builder, (Name)name, (Pattern)this.start);
                this.recoverPatternTable.put(name, pattern);
            }
            return pattern;
        }
    }
}

