/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSOutputStream
extends OutputStream
implements ISVNDeltaConsumer {
    public static final int SVN_DELTA_WINDOW_SIZE = 102400;
    public static final int WRITE_BUFFER_SIZE = 204800;
    private boolean isHeaderWritten;
    private CountingOutputStream myTargetFileOS;
    private File myTargetFile;
    private long myDeltaStart;
    private long myRepSize;
    private long myRepOffset;
    private InputStream mySourceStream;
    private SVNDeltaGenerator myDeltaGenerator;
    private FSRevisionNode myRevNode;
    private MessageDigest myMD5Digest;
    private MessageDigest mySHA1Digest;
    private FSTransactionRoot myTxnRoot;
    private long mySourceOffset;
    private ByteArrayOutputStream myTextBuffer;
    private boolean myIsClosed;
    private boolean myIsCompress;
    private FSWriteLock myTxnLock;

    private FSOutputStream(FSRevisionNode revNode, CountingOutputStream targetFileOS, File targetFile, InputStream source, long deltaStart, long repSize, long repOffset, FSTransactionRoot txnRoot, boolean compress, FSWriteLock txnLock) throws SVNException {
        SVNErrorMessage err;
        this.myTxnRoot = txnRoot;
        this.myTargetFileOS = targetFileOS;
        this.myTargetFile = targetFile;
        this.mySourceStream = source;
        this.myDeltaStart = deltaStart;
        this.myRepSize = repSize;
        this.myRepOffset = repOffset;
        this.isHeaderWritten = false;
        this.myRevNode = revNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myTxnLock = txnLock;
        this.myDeltaGenerator = new SVNDeltaGenerator(102400);
        this.myTextBuffer = new ByteArrayOutputStream();
        try {
            this.myMD5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        try {
            this.mySHA1Digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "SHA1 implementation not found: {0}", (Object)nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        this.myIsCompress = compress;
    }

    private void reset(FSRevisionNode revNode, CountingOutputStream targetFileOS, File targetFile, InputStream source, long deltaStart, long repSize, long repOffset, FSTransactionRoot txnRoot, FSWriteLock txnLock) {
        this.myTxnRoot = txnRoot;
        this.myTargetFileOS = targetFileOS;
        this.myTargetFile = targetFile;
        this.mySourceStream = source;
        this.myDeltaStart = deltaStart;
        this.myRepSize = repSize;
        this.myRepOffset = repOffset;
        this.isHeaderWritten = false;
        this.myRevNode = revNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myMD5Digest.reset();
        this.mySHA1Digest.reset();
        this.myTextBuffer.reset();
        this.myTxnLock = txnLock;
    }

    public static OutputStream createStream(FSRevisionNode revNode, FSTransactionRoot txnRoot, OutputStream dstStream, boolean compress) throws SVNException {
        SVNErrorMessage err;
        if (revNode.getType() != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to set textual contents of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!revNode.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to set textual contents of an immutable node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        OutputStream targetOS = null;
        InputStream sourceStream = null;
        long offset = -1L;
        long deltaStart = -1L;
        FSWriteLock txnLock = null;
        try {
            txnLock = FSWriteLock.getWriteLockForTxn(txnRoot.getTxnID(), txnRoot.getOwner());
            txnLock.lock();
            File targetFile = txnRoot.getTransactionProtoRevFile();
            offset = targetFile.length();
            targetOS = SVNFileUtil.openFileForWriting(targetFile, true);
            CountingOutputStream revWriter = new CountingOutputStream(targetOS, offset);
            FSRepresentation baseRep = revNode.chooseDeltaBase(txnRoot.getOwner());
            sourceStream = FSInputStream.createDeltaStream(new SVNDeltaCombiner(), baseRep, txnRoot.getOwner());
            String header = baseRep != null ? "DELTA " + baseRep.getRevision() + " " + baseRep.getOffset() + " " + baseRep.getSize() + "\n" : "DELTA\n";
            revWriter.write(header.getBytes("UTF-8"));
            deltaStart = revWriter.getPosition();
            if (dstStream instanceof FSOutputStream) {
                FSOutputStream fsOS = (FSOutputStream)dstStream;
                fsOS.reset(revNode, revWriter, targetFile, sourceStream, deltaStart, 0L, offset, txnRoot, txnLock);
                return dstStream;
            }
            return new FSOutputStream(revNode, revWriter, targetFile, sourceStream, deltaStart, 0L, offset, txnRoot, compress, txnLock);
        }
        catch (IOException ioe) {
            SVNFileUtil.closeFile(targetOS);
            SVNFileUtil.closeFile(sourceStream);
            txnLock.unlock();
            FSWriteLock.release(txnLock);
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err2, ioe, SVNLogType.FSFS);
        }
        catch (SVNException svne) {
            if (txnLock != null) {
                txnLock.unlock();
                FSWriteLock.release(txnLock);
            }
            SVNFileUtil.closeFile(targetOS);
            SVNFileUtil.closeFile(sourceStream);
            throw svne;
        }
        return null;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myMD5Digest.update(b, off, len);
        this.mySHA1Digest.update(b, off, len);
        this.myRepSize += (long)len;
        int toWrite = 0;
        while (len > 0) {
            toWrite = len;
            this.myTextBuffer.write(b, off, toWrite);
            if (this.myTextBuffer.size() >= 204800) {
                try {
                    ByteArrayInputStream target = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
                    this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, target, this, false);
                }
                catch (SVNException svne) {
                    throw new IOException(svne.getMessage());
                }
                this.myTextBuffer.reset();
            }
            off += toWrite;
            len -= toWrite;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myIsClosed) {
            return;
        }
        this.myIsClosed = true;
        final long[] truncateToSize = new long[]{-1L};
        try {
            ByteArrayInputStream target = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
            this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, target, this, false);
            final FSRepresentation rep = new FSRepresentation();
            rep.setOffset(this.myRepOffset);
            long offset = this.myTargetFileOS.getPosition();
            rep.setSize(offset - this.myDeltaStart);
            rep.setExpandedSize(this.myRepSize);
            rep.setTxnId(this.myRevNode.getId().getTxnID());
            String uniqueSuffix = this.myTxnRoot.getNewTxnNodeId();
            String uniquifier = rep.getTxnId() + '/' + uniqueSuffix;
            rep.setUniquifier(uniquifier);
            rep.setRevision(-1L);
            rep.setMD5HexDigest(SVNFileUtil.toHexDigest(this.myMD5Digest));
            rep.setSHA1HexDigest(SVNFileUtil.toHexDigest(this.mySHA1Digest));
            FSFS fsfs = this.myTxnRoot.getOwner();
            final IFSRepresentationCacheManager reposCacheManager = fsfs.getRepositoryCacheManager();
            if (reposCacheManager != null) {
                try {
                    reposCacheManager.runReadTransaction(new IFSSqlJetTransaction(){

                        @Override
                        public void run() throws SVNException {
                            FSRepresentation oldRep = reposCacheManager.getRepresentationByHash(rep.getSHA1HexDigest());
                            if (oldRep != null) {
                                oldRep.setUniquifier(rep.getUniquifier());
                                oldRep.setMD5HexDigest(rep.getMD5HexDigest());
                                truncateToSize[0] = FSOutputStream.this.myRepOffset;
                                FSOutputStream.this.myRevNode.setTextRepresentation(oldRep);
                            }
                        }
                    });
                }
                catch (SVNException e) {
                    SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
                }
            }
            if (truncateToSize[0] < 0L) {
                this.myTargetFileOS.write("ENDREP\n".getBytes("UTF-8"));
                this.myRevNode.setTextRepresentation(rep);
            }
            this.myRevNode.setIsFreshTxnRoot(false);
            fsfs.putTxnRevisionNode(this.myRevNode.getId(), this.myRevNode);
        }
        catch (SVNException svne) {
            throw new IOException(svne.getMessage());
        }
        finally {
            this.closeStreams(truncateToSize[0]);
            try {
                this.myTxnLock.unlock();
            }
            catch (SVNException e) {}
            FSWriteLock.release(this.myTxnLock);
        }
    }

    public void closeStreams(long truncateToSize) throws IOException {
        SVNFileUtil.closeFile(this.myTargetFileOS);
        SVNFileUtil.closeFile(this.mySourceStream);
        if (truncateToSize >= 0L) {
            SVNFileUtil.truncate(this.myTargetFile, truncateToSize);
        }
    }

    public FSRevisionNode getRevisionNode() {
        return this.myRevNode;
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.mySourceOffset += (long)diffWindow.getSourceViewLength();
        try {
            diffWindow.writeTo(this.myTargetFileOS, !this.isHeaderWritten, this.myIsCompress);
            this.isHeaderWritten = true;
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
    }
}

