/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.d;
import com.jidesoft.docking.h;
import com.jidesoft.docking.k;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class WindowFloatingContainer
extends ResizableWindow
implements FloatingContainer {
    private final DockingManager kg;
    private final FloatingContainer.FloatingContainerManager jg;
    private int ig = 0;

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame) throws HeadlessException {
        this(dockingManager, floatingContainerManager, frame, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame, String string) throws HeadlessException {
        this(dockingManager, floatingContainerManager, frame, string, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame, String string, boolean bl) throws HeadlessException {
        super(frame);
        this.kg = dockingManager;
        this.jg = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog) throws HeadlessException {
        this(dockingManager, floatingContainerManager, dialog, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog, String string) throws HeadlessException {
        this(dockingManager, floatingContainerManager, dialog, string, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog, String string, boolean bl) throws HeadlessException {
        super(dialog);
        this.kg = dockingManager;
        this.jg = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window window) throws HeadlessException {
        this(dockingManager, floatingContainerManager, window, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window window, String string) throws HeadlessException {
        this(dockingManager, floatingContainerManager, window, string, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window window, String string, boolean bl) throws HeadlessException {
        super(window);
        this.kg = dockingManager;
        this.jg = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    protected void initComponents() {
        this.setName("Window");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        super.initComponents();
    }

    protected void initWindowFloatingContainer() {
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    protected void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                if (!(windowEvent.getOppositeWindow() instanceof FloatingContainer) && WindowFloatingContainer.this.jg != null) {
                    WindowFloatingContainer.this.jg.floatingFrameActivated(windowEvent);
                }
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                super.windowDeactivated(windowEvent);
                if (WindowFloatingContainer.this.jg != null) {
                    WindowFloatingContainer.this.jg.floatingFrameDeactivated(windowEvent);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                WindowFloatingContainer.this.doHideFloatingFrame();
            }

            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                WindowFloatingContainer.this.doHideFloatingFrame();
            }
        });
    }

    protected void initKeyBindings() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (WindowFloatingContainer.this.isFocusOwner() && keyEvent.getKeyCode() == 115 && keyEvent.isAltDown()) {
                    WindowFloatingContainer.this.doHideFloatingFrame();
                    keyEvent.consume();
                }
            }
        });
    }

    protected void doHideFloatingFrame() {
        DockableFrame dockableFrame;
        if (this.getDockingManager() == null || !this.getDockingManager().isHidable()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DockableFrame dockableFrame2 = this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey());
        if (dockableFrame2 != null && SwingUtilities.isDescendingFrom(dockableFrame2, this) && !dockableFrame2.isHidden() && dockableFrame2.isHidable() && !dockableFrame2.shouldVetoHiding() && !arrayList.contains(dockableFrame2.getKey())) {
            arrayList.add(dockableFrame2.getKey());
        }
        List<String> list = this.getDockingManager().getAllFrameNames();
        for (String string : list) {
            dockableFrame = this.getDockingManager().getFrame(string);
            if (dockableFrame == null || !SwingUtilities.isDescendingFrom(dockableFrame, this) || dockableFrame.isHidden() || !dockableFrame.isHidable() || dockableFrame.shouldVetoHiding() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.hide"));
            for (String string : arrayList) {
                dockableFrame = this.getDockingManager().getFrame(string);
                if (dockableFrame == null || dockableFrame.getCloseAction() == null || !dockableFrame.getCloseAction().isEnabled()) continue;
                ActionEvent actionEvent = new ActionEvent(this, 1001, "hiddenByParentContainer");
                dockableFrame.getCloseAction().actionPerformed(actionEvent);
            }
        }
    }

    public Component getRoutingComponent() {
        return this.kg.getMainContainer();
    }

    public boolean hasTitleBar() {
        return UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    public Rectangle getInitialBounds(Rectangle rectangle) {
        return rectangle;
    }

    public void updateUndecorated() {
        boolean bl = this.isVisible();
        this.setVisible(false);
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            k.qb(this.getContentPane(), border);
        } else {
            BorderUIResource borderUIResource = new BorderUIResource(BorderFactory.createEmptyBorder());
            k.qb(this.getContentPane(), borderUIResource);
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (bl || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
    }

    public void updateBorders() {
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            k.jb(this.getContentPane(), border);
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            k.jb(this.getContentPane(), border);
        }
    }

    public DockingManager getDockingManager() {
        return this.kg;
    }

    public Component asComponent() {
        return this;
    }

    public void hideItselfIfEmpty() {
        List<DockableFrame> list = k.ac(this.getContentPane());
        if (list == null || list.size() == 0) {
            this.setVisible(false);
        }
    }

    public int getDockID() {
        return this.ig;
    }

    public void setDockID(int n2) {
        this.ig = n2;
    }

    public void resetDockID() {
        this.ig = -1;
        if (this.kg != null) {
            this.ig = h.f(this.kg).h(this.getDockID());
        }
    }

    public boolean isUndecorated() {
        return false;
    }

    public void updateTitle() {
    }

    public void setResizable(boolean bl) {
        this.getResizable().setResizableCorners(bl ? 255 : 0);
    }

    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }

    protected class CloseFloatingDockableFrameAction
    extends AbstractAction {
        public CloseFloatingDockableFrameAction() {
            super(WindowFloatingContainer.this.getDockingManager() != null ? WindowFloatingContainer.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : d.b(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowFloatingContainer.this.doHideFloatingFrame();
        }
    }
}

