/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.d;
import com.jidesoft.docking.h;
import com.jidesoft.docking.k;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class DialogFloatingContainer
extends ResizableDialog
implements FloatingContainer {
    private final DockingManager pg;
    private final FloatingContainer.FloatingContainerManager og;
    private int ng = 0;

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame) throws HeadlessException {
        this(dockingManager, floatingContainerManager, frame, "", false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame, String string) throws HeadlessException {
        this(dockingManager, floatingContainerManager, frame, string, false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame frame, String string, boolean bl) throws HeadlessException {
        super(frame, string, bl);
        this.setDefaultCloseOperation(2);
        this.pg = dockingManager;
        this.og = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog) throws HeadlessException {
        this(dockingManager, floatingContainerManager, dialog, "", false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog, String string) throws HeadlessException {
        this(dockingManager, floatingContainerManager, dialog, string, false);
    }

    public DialogFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog dialog, String string, boolean bl) throws HeadlessException {
        super(dialog, string, bl);
        this.pg = dockingManager;
        this.og = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                if (!(windowEvent.getOppositeWindow() instanceof FloatingContainer) && DialogFloatingContainer.this.og != null) {
                    DialogFloatingContainer.this.og.floatingFrameActivated(windowEvent);
                }
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                super.windowDeactivated(windowEvent);
                if (DialogFloatingContainer.this.og != null) {
                    DialogFloatingContainer.this.og.floatingFrameDeactivated(windowEvent);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                DialogFloatingContainer.this.doHideFloatingFrame();
            }

            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                DialogFloatingContainer.this.doHideFloatingFrame();
            }
        });
    }

    protected void initKeyBindings() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (DialogFloatingContainer.this.isFocusOwner() && keyEvent.getKeyCode() == 115 && keyEvent.isAltDown()) {
                    DialogFloatingContainer.this.doHideFloatingFrame();
                    keyEvent.consume();
                }
            }
        });
    }

    protected void doHideFloatingFrame() {
        DockableFrame dockableFrame;
        if (this.getDockingManager() == null || !this.getDockingManager().isHidable()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DockableFrame dockableFrame2 = this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey());
        if (dockableFrame2 != null && SwingUtilities.isDescendingFrom(dockableFrame2, this) && !dockableFrame2.isHidden() && dockableFrame2.isHidable() && !dockableFrame2.shouldVetoHiding() && !arrayList.contains(dockableFrame2.getKey())) {
            arrayList.add(dockableFrame2.getKey());
        }
        List<String> list = this.getDockingManager().getAllFrameNames();
        for (String string : list) {
            dockableFrame = this.getDockingManager().getFrame(string);
            if (dockableFrame == null || !SwingUtilities.isDescendingFrom(dockableFrame, this) || dockableFrame.isHidden() || !dockableFrame.isHidable() || dockableFrame.shouldVetoHiding() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.hide"));
            for (String string : arrayList) {
                dockableFrame = this.getDockingManager().getFrame(string);
                if (dockableFrame == null || dockableFrame.getCloseAction() == null || !dockableFrame.getCloseAction().isEnabled()) continue;
                ActionEvent actionEvent = new ActionEvent(this, 1001, "hiddenByParentContainer");
                dockableFrame.getCloseAction().actionPerformed(actionEvent);
            }
        }
    }

    public Component getRoutingComponent() {
        return this.pg.getMainContainer();
    }

    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    public Rectangle getInitialBounds(Rectangle rectangle) {
        return rectangle;
    }

    public void updateUndecorated() {
        boolean bl = this.isVisible();
        this.setVisible(false);
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            if (!k.ab(this)) {
                this.setUndecorated(false);
                this.getRootPane().setWindowDecorationStyle(2);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
        } else if (k.ab(this)) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
        }
        this.updateBorders();
        if (this.getDockingManager().getMainContainer().isShowing() && (bl || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
    }

    public void updateBorders() {
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            k.jb(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this.pg.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            k.jb(this.getContentPane(), border);
            this.getResizable().setResizableCorners(k.ab(this) ? 0 : 255);
            if (this.pg.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    public DockingManager getDockingManager() {
        return this.pg;
    }

    public Component asComponent() {
        return this;
    }

    public void hideItselfIfEmpty() {
        List<DockableFrame> list = k.ac(this.getContentPane());
        if (list == null || list.size() == 0) {
            this.setVisible(false);
        }
    }

    public int getDockID() {
        return this.ng;
    }

    public void setDockID(int n2) {
        this.ng = n2;
    }

    public void resetDockID() {
        this.ng = -1;
        if (this.pg != null) {
            this.ng = h.f(this.pg).h(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component component2 = this.getContentPane().getComponent(0);
        List<Component> list = null;
        if (component2 instanceof ContainerContainer) {
            list = k.p((ContainerContainer)component2);
        } else if (component2 instanceof FrameContainer) {
            list = k.pc((FrameContainer)component2);
        }
        if (list == null || list.size() <= 0 || !((component = list.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container container = dockableFrame.getParent();
        if (container != null && container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            DockableFrame dockableFrame2 = frameContainer.getSelectedFrame();
            if (dockableFrame2 == null) return frameContainer;
            Component component3 = dockableFrame2.getFocusedComponent();
            if (component3 == null || component3 == dockableFrame2) {
                component3 = dockableFrame2.getDefaultFocusComponent();
            }
            if (component3 == dockableFrame2) return super.getMostRecentFocusOwner();
            return component3;
        }
        Component component4 = dockableFrame.getFocusedComponent();
        if (component4 == dockableFrame) {
            component4 = dockableFrame.getDefaultFocusComponent();
        }
        if (component4 == dockableFrame) return super.getMostRecentFocusOwner();
        return component4;
    }

    public void updateTitle() {
    }

    public void setResizable(boolean bl) {
        super.setResizable(bl);
        this.getResizable().setResizableCorners(bl ? 255 : 0);
    }

    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }

    protected class CloseFloatingDockableFrameAction
    extends AbstractAction {
        public CloseFloatingDockableFrameAction() {
            super(DialogFloatingContainer.this.getDockingManager() != null ? DialogFloatingContainer.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : d.b(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogFloatingContainer.this.doHideFloatingFrame();
        }
    }
}

