/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui.settings;

import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.UIUtil;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Color;
import java.awt.Font;
import javax.swing.KeyStroke;

public class DefaultSettingsProvider
implements SettingsProvider {
    @Override
    public KeyStroke[] getNewSessionKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(84, 256) : KeyStroke.getKeyStroke(84, 192)};
    }

    @Override
    public KeyStroke[] getCloseSessionKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(87, 256) : KeyStroke.getKeyStroke(87, 192)};
    }

    @Override
    public KeyStroke[] getCopyKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 192)};
    }

    @Override
    public KeyStroke[] getPasteKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 192)};
    }

    @Override
    public KeyStroke[] getClearBufferKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(75, 256) : KeyStroke.getKeyStroke(75, 128)};
    }

    @Override
    public KeyStroke[] getFindKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(70, 256) : KeyStroke.getKeyStroke(70, 128)};
    }

    @Override
    public KeyStroke[] getPageUpKeyStrokes() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(33, 64)};
    }

    @Override
    public KeyStroke[] getPageDownKeyStrokes() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(34, 64)};
    }

    @Override
    public ColorPalette getTerminalColorPalette() {
        return UIUtil.isWindows ? ColorPalette.WINDOWS_PALETTE : ColorPalette.XTERM_PALETTE;
    }

    @Override
    public Font getTerminalFont() {
        String fontName = UIUtil.isWindows ? "Consolas" : (UIUtil.isMac ? "Menlo" : "Monospaced");
        return Font.decode(fontName).deriveFont(this.getTerminalFontSize());
    }

    @Override
    public float getTerminalFontSize() {
        return 14.0f;
    }

    @Override
    public float getLineSpace() {
        return 0.0f;
    }

    @Override
    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.BLACK, TerminalColor.WHITE);
    }

    @Override
    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.WHITE, TerminalColor.rgb(82, 109, 165));
    }

    @Override
    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.BLACK, TerminalColor.rgb(255, 255, 0));
    }

    @Override
    public TextStyle getHyperlinkColor() {
        return new TextStyle(TerminalColor.awt(Color.BLUE), TerminalColor.WHITE);
    }

    @Override
    public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
        return HyperlinkStyle.HighlightMode.HOVER;
    }

    @Override
    public boolean useInverseSelectionColor() {
        return true;
    }

    @Override
    public boolean copyOnSelect() {
        return this.emulateX11CopyPaste();
    }

    @Override
    public boolean pasteOnMiddleMouseClick() {
        return this.emulateX11CopyPaste();
    }

    @Override
    public boolean emulateX11CopyPaste() {
        return false;
    }

    @Override
    public boolean useAntialiasing() {
        return true;
    }

    @Override
    public int maxRefreshRate() {
        return 50;
    }

    @Override
    public boolean audibleBell() {
        return true;
    }

    @Override
    public boolean enableMouseReporting() {
        return true;
    }

    @Override
    public int caretBlinkingMs() {
        return 505;
    }

    @Override
    public boolean scrollToBottomOnTyping() {
        return true;
    }

    @Override
    public boolean DECCompatibilityMode() {
        return true;
    }

    @Override
    public boolean forceActionOnMouseReporting() {
        return false;
    }

    @Override
    public int getBufferMaxLinesCount() {
        return 1000;
    }

    @Override
    public boolean altSendsEscape() {
        return false;
    }

    @Override
    public boolean ambiguousCharsAreDoubleWidth() {
        return false;
    }
}

