/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.CDATAReader;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.PIReader;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLUtil;

public class StdXMLParser
implements IXMLParser {
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    public void setBuilder(IXMLBuilder builder) {
        this.builder = builder;
    }

    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(IXMLValidator validator) {
        this.validator = validator;
    }

    public IXMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(IXMLEntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(IXMLReader reader) {
        this.reader = reader;
    }

    public IXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLException(e);
        }
    }

    protected void scanData() throws Exception {
        block4: while (!this.reader.atEOF() && this.builder.getResult() == null) {
            String str = XMLUtil.read(this.reader, '&');
            char ch = str.charAt(0);
            if (ch == '&') {
                XMLUtil.processEntity(str, this.reader, this.entityResolver);
                continue;
            }
            switch (ch) {
                case '<': {
                    this.scanSomeTag(false, null, new Properties());
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
            }
            XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + ch + "' (0x" + Integer.toHexString(ch) + ')');
        }
    }

    protected void scanSomeTag(boolean allowCDATA, String defaultNamespace, Properties namespaces) throws Exception {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(allowCDATA);
                break;
            }
            default: {
                this.reader.unread(ch);
                this.processElement(defaultNamespace, namespaces);
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, null);
        String target = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        PIReader reader = new PIReader(this.reader);
        if (!target.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(target, reader);
        }
        ((Reader)reader).close();
    }

    protected void processSpecialTag(boolean allowCDATA) throws Exception {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '[': {
                if (allowCDATA) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        CDATAReader reader = new CDATAReader(this.reader);
        this.builder.addPCData(reader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)reader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String systemID = null;
        StringBuffer publicID = new StringBuffer();
        String rootElement = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char ch = this.reader.read();
        if (ch == 'P') {
            systemID = XMLUtil.scanPublicID(publicID, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        } else if (ch == 'S') {
            systemID = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch == '[') {
            this.validator.parseDTD(publicID.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (systemID != null) {
            Reader reader = this.reader.openStream(publicID.toString(), systemID);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(systemID);
            this.reader.setPublicID(publicID.toString());
            this.validator.parseDTD(publicID.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement(String defaultNamespace, Properties namespaces) throws Exception {
        String type;
        String value;
        String key;
        int i;
        char ch;
        String fullName;
        String name = fullName = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        String prefix = null;
        int colonIndex = name.indexOf(58);
        if (colonIndex > 0) {
            prefix = name.substring(0, colonIndex);
            name = name.substring(colonIndex + 1);
        }
        Vector<String> attrNames = new Vector<String>();
        Vector<String> attrValues = new Vector<String>();
        Vector<String> attrTypes = new Vector<String>();
        this.validator.elementStarted(fullName, this.reader.getSystemID(), this.reader.getLineNr());
        while ((ch = this.reader.read()) != '/' && ch != '>') {
            this.reader.unread(ch);
            this.processAttribute(attrNames, attrValues, attrTypes);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties extraAttributes = new Properties();
        this.validator.elementAttributesProcessed(fullName, extraAttributes, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> enumeration = extraAttributes.keys();
        while (enumeration.hasMoreElements()) {
            String key2 = (String)enumeration.nextElement();
            String value2 = extraAttributes.getProperty(key2);
            attrNames.addElement(key2);
            attrValues.addElement(value2);
            attrTypes.addElement("CDATA");
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = (String)attrNames.elementAt(i);
            value = (String)attrValues.elementAt(i);
            type = (String)attrTypes.elementAt(i);
            if (key.equals("xmlns")) {
                defaultNamespace = value;
                continue;
            }
            if (!key.startsWith("xmlns:")) continue;
            namespaces.put(key.substring(6), value);
        }
        if (prefix == null) {
            this.builder.startElement(name, prefix, defaultNamespace, this.reader.getSystemID(), this.reader.getLineNr());
        } else {
            this.builder.startElement(name, prefix, namespaces.getProperty(prefix), this.reader.getSystemID(), this.reader.getLineNr());
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = (String)attrNames.elementAt(i);
            if (key.startsWith("xmlns")) continue;
            value = (String)attrValues.elementAt(i);
            type = (String)attrTypes.elementAt(i);
            colonIndex = key.indexOf(58);
            if (colonIndex > 0) {
                String attPrefix = key.substring(0, colonIndex);
                key = key.substring(colonIndex + 1);
                this.builder.addAttribute(key, attPrefix, namespaces.getProperty(attPrefix), value, type);
                continue;
            }
            this.builder.addAttribute(key, null, null, value, type);
        }
        if (prefix == null) {
            this.builder.elementAttributesProcessed(name, prefix, defaultNamespace);
        } else {
            this.builder.elementAttributesProcessed(name, prefix, namespaces.getProperty(prefix));
        }
        if (ch == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(name, this.reader.getSystemID(), this.reader.getLineNr());
            if (prefix == null) {
                this.builder.endElement(name, prefix, defaultNamespace);
            } else {
                this.builder.endElement(name, prefix, namespaces.getProperty(prefix));
            }
            return;
        }
        StringBuffer buffer = new StringBuffer(16);
        while (true) {
            String str;
            buffer.setLength(0);
            while (true) {
                XMLUtil.skipWhitespace(this.reader, buffer);
                str = XMLUtil.read(this.reader, '&');
                if (str.charAt(0) != '&' || str.charAt(1) == '#') break;
                XMLUtil.processEntity(str, this.reader, this.entityResolver);
            }
            if (str.charAt(0) == '<') {
                str = XMLUtil.read(this.reader, '\u0000');
                if (str.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    str = XMLUtil.scanIdentifier(this.reader);
                    if (!str.equals(fullName)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), name, str);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    this.validator.elementEnded(fullName, this.reader.getSystemID(), this.reader.getLineNr());
                    if (prefix == null) {
                        this.builder.endElement(name, prefix, defaultNamespace);
                        break;
                    }
                    this.builder.endElement(name, prefix, namespaces.getProperty(prefix));
                    break;
                }
                this.reader.unread(str.charAt(0));
                this.scanSomeTag(true, defaultNamespace, (Properties)namespaces.clone());
                continue;
            }
            if (str.charAt(0) == '&') {
                ch = XMLUtil.processCharLiteral(str);
                buffer.append(ch);
            } else {
                this.reader.unread(str.charAt(0));
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            ContentReader r = new ContentReader(this.reader, this.entityResolver, buffer.toString());
            this.builder.addPCData(r, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)r).close();
        }
    }

    protected void processAttribute(Vector attrNames, Vector attrValues, Vector attrTypes) throws Exception {
        String key = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String value = XMLUtil.scanString(this.reader, '&', this.entityResolver);
        attrNames.addElement(key);
        attrValues.addElement(value);
        attrTypes.addElement("CDATA");
        this.validator.attributeAdded(key, value, this.reader.getSystemID(), this.reader.getLineNr());
    }
}

