/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.wc.SVNRevision;

abstract class AbstractAuthenticator {
    private static final Logger LOG = Logger.getInstance(AbstractAuthenticator.class);
    @NotNull
    protected final AuthenticationService myAuthenticationService;
    @NotNull
    protected final SvnVcs myVcs;
    @NotNull
    protected final SVNURL myUrl;
    protected final String myRealm;
    protected boolean myStoreInUsual;
    protected SvnAuthenticationManager myTmpDirManager;

    AbstractAuthenticator(@NotNull AuthenticationService authenticationService, @NotNull SVNURL url, String realm) {
        if (authenticationService == null) {
            AbstractAuthenticator.$$$reportNull$$$0(0);
        }
        if (url == null) {
            AbstractAuthenticator.$$$reportNull$$$0(1);
        }
        this.myAuthenticationService = authenticationService;
        this.myVcs = this.myAuthenticationService.getVcs();
        this.myUrl = url;
        this.myRealm = realm;
    }

    protected boolean tryAuthenticate() {
        SvnAuthenticationManager passive = this.myVcs.getSvnConfiguration().getPassiveAuthenticationManager(this.myVcs);
        SvnAuthenticationManager active = this.myVcs.getSvnConfiguration().getAuthenticationManager(this.myVcs);
        try {
            boolean authenticated;
            boolean bl = authenticated = this.getWithPassive(passive) || this.myAuthenticationService.isActive() && this.getWithActive(active);
            if (!authenticated) {
                return false;
            }
            SvnAuthenticationManager manager = this.myStoreInUsual ? active : this.createTmpManager();
            manager.setArtificialSaving(true);
            return this.acknowledge(manager);
        }
        catch (IOException | SVNException e) {
            LOG.info(e);
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return false;
        }
    }

    @NotNull
    protected SvnAuthenticationManager createTmpManager() throws IOException {
        if (this.myTmpDirManager == null) {
            this.myAuthenticationService.initTmpDir();
            this.myTmpDirManager = new SvnAuthenticationManager(this.myVcs, this.myAuthenticationService.getTempDirectory());
            this.myTmpDirManager.setRuntimeStorage(SvnConfiguration.RUNTIME_AUTH_CACHE);
            this.myTmpDirManager.setAuthenticationProvider(new SvnInteractiveAuthenticationProvider(this.myVcs, this.myTmpDirManager));
        }
        SvnAuthenticationManager svnAuthenticationManager = this.myTmpDirManager;
        if (svnAuthenticationManager == null) {
            AbstractAuthenticator.$$$reportNull$$$0(2);
        }
        return svnAuthenticationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getWithActive(SvnAuthenticationManager active) throws SVNException {
        MessageBusConnection connection = null;
        try {
            Project project = this.myVcs.getProject();
            connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(SvnAuthenticationManager.AUTHENTICATION_PROVIDER_LISTENER, (Object)new MyAuthenticationProviderListener());
            this.makeAuthCall(active);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return this.afterAuthCall();
    }

    protected void makeAuthCall(@NotNull SvnAuthenticationManager manager) throws SVNException {
        if (manager == null) {
            AbstractAuthenticator.$$$reportNull$$$0(3);
        }
        this.myVcs.getSvnKitManager().createWCClient((ISVNAuthenticationManager)manager).doInfo(this.myUrl, SVNRevision.UNDEFINED, SVNRevision.HEAD);
    }

    protected void acceptServerAuthentication(SVNURL url, String realm, Object certificate, int acceptResult) {
    }

    public void requestClientAuthentication(SVNURL url, String realm, SVNAuthentication authentication) {
    }

    protected abstract boolean afterAuthCall();

    protected abstract boolean getWithPassive(SvnAuthenticationManager var1) throws SVNException;

    protected abstract boolean acknowledge(SvnAuthenticationManager var1) throws SVNException;

    protected static boolean storeCredentials(@NotNull SvnAuthenticationManager manager, SVNAuthentication authentication, String realm) throws SVNException {
        if (manager == null) {
            AbstractAuthenticator.$$$reportNull$$$0(4);
        }
        try {
            if (authentication instanceof SVNSSLAuthentication && ((SVNSSLAuthentication)authentication).getCertificateFile() != null) {
                manager.acknowledgeForSSL(true, authentication);
                realm = ((SVNSSLAuthentication)authentication).getCertificateFile().getPath();
            }
            manager.acknowledgeAuthentication(true, AbstractAuthenticator.getFromType(authentication), realm, null, authentication, authentication.getURL());
        }
        catch (SvnAuthenticationManager.CredentialsSavedException e) {
            return e.isSuccess();
        }
        return true;
    }

    @NotNull
    private static String getFromType(SVNAuthentication authentication) {
        if (authentication instanceof SVNPasswordAuthentication) {
            if ("svn.simple" == null) {
                AbstractAuthenticator.$$$reportNull$$$0(5);
            }
            return "svn.simple";
        }
        if (authentication instanceof SVNSSHAuthentication) {
            if ("svn.ssh" == null) {
                AbstractAuthenticator.$$$reportNull$$$0(6);
            }
            return "svn.ssh";
        }
        if (authentication instanceof SVNSSLAuthentication) {
            if ("svn.ssl.client-passphrase" == null) {
                AbstractAuthenticator.$$$reportNull$$$0(7);
            }
            return "svn.ssl.client-passphrase";
        }
        if (authentication instanceof SVNUserNameAuthentication) {
            if ("svn.username" == null) {
                AbstractAuthenticator.$$$reportNull$$$0(8);
            }
            return "svn.username";
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/auth/AbstractAuthenticator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/auth/AbstractAuthenticator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTmpManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeAuthCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "storeCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyAuthenticationProviderListener
    implements SvnAuthenticationManager.ISVNAuthenticationProviderListener {
        private MyAuthenticationProviderListener() {
        }

        @Override
        public void requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored, SVNAuthentication authentication) {
            AbstractAuthenticator.this.requestClientAuthentication(url, realm, authentication);
        }

        @Override
        public void acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored, int acceptResult) {
            AbstractAuthenticator.this.acceptServerAuthentication(url, realm, certificate, acceptResult);
        }
    }
}

