/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ColorSpaces;

public final class YCbCrConverter {
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_R_LUT = new int[256];
    private static final int[] Cb_B_LUT = new int[256];
    private static final int[] Cr_G_LUT = new int[256];
    private static final int[] Cb_G_LUT = new int[256];

    private static void buildYCCtoRGBtable() {
        if (ColorSpaces.DEBUG) {
            System.err.println("Building YCC conversion table");
        }
        int n = 0;
        int n2 = -128;
        while (n <= 255) {
            YCbCrConverter.Cr_R_LUT[n] = (int)(91881.972 * (double)n2 + 32768.0) >> 16;
            YCbCrConverter.Cb_B_LUT[n] = (int)(116130.292 * (double)n2 + 32768.0) >> 16;
            YCbCrConverter.Cr_G_LUT[n] = -46802 * n2;
            YCbCrConverter.Cb_G_LUT[n] = -22554 * n2 + 32768;
            ++n;
            ++n2;
        }
    }

    public static void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, double[] dArray, int n) {
        double d = byArray[n] & 0xFF;
        double d2 = (byArray[n + 1] & 0xFF) - 128;
        double d3 = (byArray[n + 2] & 0xFF) - 128;
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        int n2 = (int)Math.round(d3 * (2.0 - 2.0 * d4) + d);
        int n3 = (int)Math.round(d2 * (2.0 - 2.0 * d6) + d);
        int n4 = (int)Math.round((d - d4 * (double)n2 - d6 * (double)n3) / d5);
        byArray2[n] = YCbCrConverter.clamp(n2);
        byArray2[n + 2] = YCbCrConverter.clamp(n3);
        byArray2[n + 1] = YCbCrConverter.clamp(n4);
    }

    public static void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 2] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        byArray2[n] = YCbCrConverter.clamp(n2 + Cr_R_LUT[n3]);
        byArray2[n + 1] = YCbCrConverter.clamp(n2 + (Cb_G_LUT[n4] + Cr_G_LUT[n3] >> 16));
        byArray2[n + 2] = YCbCrConverter.clamp(n2 + Cb_B_LUT[n4]);
    }

    private static byte clamp(int n) {
        return (byte)Math.max(0, Math.min(255, n));
    }

    static {
        YCbCrConverter.buildYCCtoRGBtable();
    }
}

