/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CvsResultEx
implements CvsResult {
    private final List<VcsException> myErrors = new ArrayList<VcsException>();
    private boolean myIsCanceled = false;

    @Override
    public void setIsCanceled() {
        this.myIsCanceled = true;
    }

    @Override
    public List<VcsException> getErrors() {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        for (VcsException error : this.myErrors) {
            if (error.isWarning()) continue;
            errors.add(error);
        }
        return errors;
    }

    @Override
    public List<VcsException> getWarnings() {
        ArrayList<VcsException> warnings = new ArrayList<VcsException>();
        for (VcsException error : this.myErrors) {
            if (!error.isWarning()) continue;
            warnings.add(error);
        }
        return warnings;
    }

    @Override
    public boolean isCanceled() {
        return this.myIsCanceled;
    }

    @Override
    public void addAllErrors(Collection<VcsException> errors) {
        this.myErrors.addAll(errors);
    }

    @Override
    public boolean hasErrors() {
        for (VcsException error : this.myErrors) {
            if (error.isWarning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public VcsException composeError() {
        return this.myErrors.iterator().next();
    }

    @Override
    public void addError(VcsException error) {
        this.myErrors.add(error);
    }

    @Override
    public List<VcsException> getErrorsAndWarnings() {
        return this.myErrors;
    }

    public boolean finishedUnsuccessfully(CvsHandler handler) {
        this.checkIsCanceled(handler);
        if (this.hasErrors()) {
            return true;
        }
        return this.isCanceled();
    }

    private void checkIsCanceled(CvsHandler handler) {
        if (handler.isCanceled()) {
            this.setIsCanceled();
        }
    }
}

