/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextRangeUtil {
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange range1, TextRange range2) {
            int startOffsetDiff = range1.getStartOffset() - range2.getStartOffset();
            return startOffsetDiff != 0 ? startOffsetDiff : range1.getEndOffset() - range2.getEndOffset();
        }
    };

    private TextRangeUtil() {
    }

    public static Iterable<TextRange> excludeRanges(@NotNull TextRange original, @NotNull List<TextRange> excludedRanges) {
        if (original == null) {
            TextRangeUtil.$$$reportNull$$$0(0);
        }
        if (excludedRanges == null) {
            TextRangeUtil.$$$reportNull$$$0(1);
        }
        if (!excludedRanges.isEmpty()) {
            if (excludedRanges.size() > 1) {
                Collections.sort(excludedRanges, RANGE_COMPARATOR);
            }
            int enabledRangeStart = original.getStartOffset();
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            for (TextRange excludedRange : excludedRanges) {
                if (excludedRange.getEndOffset() < enabledRangeStart) continue;
                int excludedRangeStart = excludedRange.getStartOffset();
                if (excludedRangeStart > original.getEndOffset()) break;
                if (excludedRangeStart > enabledRangeStart) {
                    enabledRanges.add(new TextRange(enabledRangeStart, excludedRangeStart));
                }
                enabledRangeStart = excludedRange.getEndOffset();
            }
            if (enabledRangeStart < original.getEndOffset()) {
                enabledRanges.add(new TextRange(enabledRangeStart, original.getEndOffset()));
            }
            return enabledRanges;
        }
        return Collections.singletonList(original);
    }

    @NotNull
    public static TextRange getEnclosingTextRange(@NotNull List<TextRange> textRanges) {
        if (textRanges == null) {
            TextRangeUtil.$$$reportNull$$$0(2);
        }
        if (textRanges.isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                TextRangeUtil.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int lowerBound = textRanges.get(0).getStartOffset();
        int upperBound = textRanges.get(0).getEndOffset();
        for (int i = 1; i < textRanges.size(); ++i) {
            TextRange textRange = textRanges.get(i);
            lowerBound = Math.min(lowerBound, textRange.getStartOffset());
            upperBound = Math.max(upperBound, textRange.getEndOffset());
        }
        TextRange textRange = new TextRange(lowerBound, upperBound);
        if (textRange == null) {
            TextRangeUtil.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRanges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/TextRangeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/TextRangeUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "excludeRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingTextRange";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

