/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    protected final String myName;

    public AddDomElementQuickFix(@NotNull T element) {
        if (element == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(0);
        }
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return DomBundle.message(this.isTag() ? "add.element.fix.name" : "add.attribute.fix.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = DomBundle.message("add.element.fix.family", new Object[0]);
        if (string == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(4);
        }
        XmlElement element = this.myElement.ensureXmlElementExists();
        XmlElement navigationElement = this.isTag() ? element : ((XmlAttribute)element).getValueElement();
        PsiNavigateUtil.navigate(navigationElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/AddDomElementQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/AddDomElementQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

