/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListToolbarDecorator;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableToolbarDecorator;
import com.intellij.ui.TreeToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarDecorator
implements CommonActionsPanel.ListenerFactory {
    protected Border myPanelBorder;
    protected Border myToolbarBorder;
    protected boolean myAddActionEnabled;
    protected boolean myEditActionEnabled;
    protected boolean myRemoveActionEnabled;
    protected boolean myUpActionEnabled;
    protected boolean myDownActionEnabled;
    protected Border myActionsPanelBorder;
    private final List<AnActionButton> myExtraActions = new SmartList();
    private ActionToolbarPosition myToolbarPosition;
    protected AnActionButtonRunnable myAddAction;
    protected AnActionButtonRunnable myEditAction;
    protected AnActionButtonRunnable myRemoveAction;
    protected AnActionButtonRunnable myUpAction;
    protected AnActionButtonRunnable myDownAction;
    private String myAddName;
    private String myEditName;
    private String myRemoveName;
    private String myMoveUpName;
    private String myMoveDownName;
    private AnActionButtonUpdater myAddActionUpdater = null;
    private AnActionButtonUpdater myRemoveActionUpdater = null;
    private AnActionButtonUpdater myEditActionUpdater = null;
    private AnActionButtonUpdater myMoveUpActionUpdater = null;
    private AnActionButtonUpdater myMoveDownActionUpdater = null;
    private Dimension myPreferredSize;
    private Dimension myMinimumSize;
    private CommonActionsPanel myActionsPanel;
    private Comparator<AnActionButton> myButtonComparator;
    private boolean myAsUsualTopToolbar = false;
    private Icon myAddIcon;
    private boolean myForcedDnD = false;

    protected abstract JComponent getComponent();

    protected abstract void updateButtons();

    protected void updateExtraElementActions(boolean someElementSelected) {
        for (AnActionButton action : this.myExtraActions) {
            if (!(action instanceof ElementActionButton)) continue;
            action.setEnabled(someElementSelected);
        }
    }

    public final CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.RIGHT);
        return this;
    }

    public ToolbarDecorator setAsUsualTopToolbar() {
        this.myAsUsualTopToolbar = true;
        this.setToolbarPosition(ActionToolbarPosition.TOP);
        return this;
    }

    public static ToolbarDecorator createDecorator(@NotNull JTable table) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(0);
        }
        return new TableToolbarDecorator(table, null).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JTree tree) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(1);
        }
        return ToolbarDecorator.createDecorator(tree, null);
    }

    private static ToolbarDecorator createDecorator(@NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(2);
        }
        return new TreeToolbarDecorator(tree, producer).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JList list) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(3);
        }
        return new ListToolbarDecorator(list, null).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JList list, EditableModel editableModel) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(4);
        }
        return new ListToolbarDecorator(list, editableModel).initPosition();
    }

    public static <T> ToolbarDecorator createDecorator(@NotNull TableView<T> table, @Nullable ElementProducer<T> producer) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(5);
        }
        return new TableToolbarDecorator(table, producer).initPosition();
    }

    public ToolbarDecorator disableAddAction() {
        this.myAddActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableRemoveAction() {
        this.myRemoveActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableUpAction() {
        this.myUpActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableUpDownActions() {
        this.myUpActionEnabled = false;
        this.myDownActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableDownAction() {
        this.myDownActionEnabled = false;
        return this;
    }

    public ToolbarDecorator setPanelBorder(Border border) {
        this.myPanelBorder = border;
        return this;
    }

    public ToolbarDecorator setToolbarBorder(Border border) {
        this.myActionsPanelBorder = border;
        return this;
    }

    public ToolbarDecorator setButtonComparator(Comparator<AnActionButton> buttonComparator) {
        this.myButtonComparator = buttonComparator;
        return this;
    }

    public ToolbarDecorator setButtonComparator(String ... actionNames) {
        List<String> names = Arrays.asList(actionNames);
        this.myButtonComparator = (o1, o2) -> {
            String t1 = o1.getTemplatePresentation().getText();
            String t2 = o2.getTemplatePresentation().getText();
            if (t1 == null || t2 == null) {
                return 0;
            }
            int ind1 = names.indexOf(t1);
            int ind2 = names.indexOf(t2);
            if (ind1 == -1 && ind2 >= 0) {
                return 1;
            }
            if (ind2 == -1 && ind1 >= 0) {
                return -1;
            }
            return ind1 - ind2;
        };
        return this;
    }

    public ToolbarDecorator setLineBorder(int top, int left, int bottom, int right) {
        return this.setToolbarBorder((Border)new CustomLineBorder(top, left, bottom, right));
    }

    public ToolbarDecorator addExtraAction(@NotNull AnActionButton action) {
        if (action == null) {
            ToolbarDecorator.$$$reportNull$$$0(6);
        }
        this.myExtraActions.add(action);
        return this;
    }

    public ToolbarDecorator addExtraActions(AnActionButton ... actions) {
        for (AnActionButton action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        return this;
    }

    public ToolbarDecorator setToolbarPosition(ActionToolbarPosition position) {
        this.myToolbarPosition = position;
        this.myActionsPanelBorder = new CustomLineBorder(this.myToolbarPosition == ActionToolbarPosition.BOTTOM ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.RIGHT ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.TOP ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.LEFT ? 1 : 0);
        return this;
    }

    public ToolbarDecorator setAddAction(AnActionButtonRunnable action) {
        this.myAddActionEnabled = action != null;
        this.myAddAction = action;
        return this;
    }

    public ToolbarDecorator setEditAction(AnActionButtonRunnable action) {
        this.myEditActionEnabled = action != null;
        this.myEditAction = action;
        return this;
    }

    public ToolbarDecorator setRemoveAction(AnActionButtonRunnable action) {
        this.myRemoveActionEnabled = action != null;
        this.myRemoveAction = action;
        return this;
    }

    public ToolbarDecorator setMoveUpAction(AnActionButtonRunnable action) {
        this.myUpActionEnabled = action != null;
        this.myUpAction = action;
        return this;
    }

    public ToolbarDecorator setMoveDownAction(AnActionButtonRunnable action) {
        this.myDownActionEnabled = action != null;
        this.myDownAction = action;
        return this;
    }

    public ToolbarDecorator setAddActionName(String name) {
        this.myAddName = name;
        return this;
    }

    public ToolbarDecorator setEditActionName(String name) {
        this.myEditName = name;
        return this;
    }

    public ToolbarDecorator setRemoveActionName(String name) {
        this.myRemoveName = name;
        return this;
    }

    public ToolbarDecorator setMoveUpActionName(String name) {
        this.myMoveUpName = name;
        return this;
    }

    public ToolbarDecorator setMoveDownActionName(String name) {
        this.myMoveDownName = name;
        return this;
    }

    public ToolbarDecorator setAddActionUpdater(AnActionButtonUpdater updater) {
        this.myAddActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setRemoveActionUpdater(AnActionButtonUpdater updater) {
        this.myRemoveActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setEditActionUpdater(AnActionButtonUpdater updater) {
        this.myEditActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setMoveUpActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveUpActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setMoveDownActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveDownActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setForcedDnD() {
        this.myForcedDnD = true;
        return this;
    }

    public ToolbarDecorator setActionGroup(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        if (actionGroup == null) {
            ToolbarDecorator.$$$reportNull$$$0(7);
        }
        for (AnAction action : actions = actionGroup.getChildren(null)) {
            if (action instanceof Separator) continue;
            this.addExtraAction(AnActionButton.fromAction(action));
        }
        return this;
    }

    public ToolbarDecorator setPreferredSize(Dimension size) {
        this.myPreferredSize = size;
        return this;
    }

    public ToolbarDecorator setMinimumSize(Dimension size) {
        this.myMinimumSize = size;
        return this;
    }

    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        return this;
    }

    public ToolbarDecorator setAddIcon(Icon addIcon) {
        this.myAddIcon = addIcon;
        return this;
    }

    public JPanel createPanel() {
        Border mainBorder;
        CommonActionsPanel.Buttons[] buttons = this.getButtons();
        JComponent contextComponent = this.getComponent();
        this.myActionsPanel = new CommonActionsPanel(this, contextComponent, this.myToolbarPosition, this.myExtraActions.toArray(new AnActionButton[this.myExtraActions.size()]), this.myButtonComparator, this.myAddName, this.myRemoveName, this.myMoveUpName, this.myMoveDownName, this.myEditName, this.myAddIcon, buttons);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)contextComponent, true);
        if (this.myPreferredSize != null) {
            scrollPane.setPreferredSize(this.myPreferredSize);
        }
        if (this.myMinimumSize != null) {
            scrollPane.setMinimumSize(this.myMinimumSize);
        }
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolbarDecorator.this.updateButtons();
            }
        };
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.myActionsPanel, ToolbarDecorator.getPlacement(this.myToolbarPosition));
        this.installUpdaters();
        this.updateButtons();
        this.installDnD();
        panel.putClientProperty("ACTION_TOOLBAR", this.myActionsPanel.getComponent(0));
        Border border = mainBorder = this.myPanelBorder != null ? this.myPanelBorder : IdeBorderFactory.createBorder(15);
        if (this.myAsUsualTopToolbar) {
            scrollPane.setBorder(mainBorder);
        } else {
            this.myActionsPanel.setBorder(this.myActionsPanelBorder);
            panel.setBorder(mainBorder);
        }
        return panel;
    }

    private void installUpdaters() {
        if (this.myAddActionEnabled && this.myAddAction != null && this.myAddActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.ADD).addCustomUpdater(this.myAddActionUpdater);
        }
        if (this.myEditActionEnabled && this.myEditAction != null && this.myEditActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.EDIT).addCustomUpdater(this.myEditActionUpdater);
        }
        if (this.myRemoveActionEnabled && this.myRemoveAction != null && this.myRemoveActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE).addCustomUpdater(this.myRemoveActionUpdater);
        }
        if (this.myUpActionEnabled && this.myUpAction != null && this.myMoveUpActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.UP).addCustomUpdater(this.myMoveUpActionUpdater);
        }
        if (this.myDownActionEnabled && this.myDownAction != null && this.myMoveDownActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.DOWN).addCustomUpdater(this.myMoveDownActionUpdater);
        }
    }

    protected void installDnD() {
        if ((this.myForcedDnD || this.myUpAction != null && this.myUpActionEnabled && this.myDownAction != null && this.myDownActionEnabled) && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.isModelEditable()) {
            this.installDnDSupport();
        }
    }

    protected abstract void installDnDSupport();

    protected abstract boolean isModelEditable();

    @NotNull
    static Object getPlacement(ActionToolbarPosition position) {
        switch (position) {
            case TOP: {
                if ("North" == null) {
                    ToolbarDecorator.$$$reportNull$$$0(8);
                }
                return "North";
            }
            case LEFT: {
                if ("West" == null) {
                    ToolbarDecorator.$$$reportNull$$$0(9);
                }
                return "West";
            }
            case BOTTOM: {
                if ("South" == null) {
                    ToolbarDecorator.$$$reportNull$$$0(10);
                }
                return "South";
            }
            case RIGHT: {
                if ("East" == null) {
                    ToolbarDecorator.$$$reportNull$$$0(11);
                }
                return "East";
            }
        }
        if ("South" == null) {
            ToolbarDecorator.$$$reportNull$$$0(12);
        }
        return "South";
    }

    private CommonActionsPanel.Buttons[] getButtons() {
        ArrayList<CommonActionsPanel.Buttons> buttons = new ArrayList<CommonActionsPanel.Buttons>();
        HashMap<CommonActionsPanel.Buttons, Pair> map = new HashMap<CommonActionsPanel.Buttons, Pair>();
        map.put(CommonActionsPanel.Buttons.ADD, Pair.create((Object)this.myAddActionEnabled, (Object)this.myAddAction));
        map.put(CommonActionsPanel.Buttons.REMOVE, Pair.create((Object)this.myRemoveActionEnabled, (Object)this.myRemoveAction));
        map.put(CommonActionsPanel.Buttons.EDIT, Pair.create((Object)this.myEditActionEnabled, (Object)this.myEditAction));
        map.put(CommonActionsPanel.Buttons.UP, Pair.create((Object)this.myUpActionEnabled, (Object)this.myUpAction));
        map.put(CommonActionsPanel.Buttons.DOWN, Pair.create((Object)this.myDownActionEnabled, (Object)this.myDownAction));
        for (CommonActionsPanel.Buttons button : CommonActionsPanel.Buttons.values()) {
            Pair action = (Pair)map.get((Object)button);
            if (action == null || action.first == null || !((Boolean)action.first).booleanValue() || action.second == null) continue;
            buttons.add(button);
        }
        return buttons.toArray(new CommonActionsPanel.Buttons[buttons.size()]);
    }

    @Override
    public CommonActionsPanel.Listener createListener(final CommonActionsPanel panel) {
        return new CommonActionsPanel.Listener(){

            @Override
            public void doAdd() {
                if (ToolbarDecorator.this.myAddAction != null) {
                    ToolbarDecorator.this.myAddAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.ADD));
                }
            }

            @Override
            public void doEdit() {
                if (ToolbarDecorator.this.myEditAction != null) {
                    ToolbarDecorator.this.myEditAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.EDIT));
                }
            }

            @Override
            public void doRemove() {
                if (ToolbarDecorator.this.myRemoveAction != null) {
                    ToolbarDecorator.this.myRemoveAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE));
                }
            }

            @Override
            public void doUp() {
                if (ToolbarDecorator.this.myUpAction != null) {
                    ToolbarDecorator.this.myUpAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.UP));
                }
            }

            @Override
            public void doDown() {
                if (ToolbarDecorator.this.myDownAction != null) {
                    ToolbarDecorator.this.myDownAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.DOWN));
                }
            }
        };
    }

    public static AnActionButton findAddButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(13);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.ADD);
    }

    public static AnActionButton findEditButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(14);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.EDIT);
    }

    public static AnActionButton findRemoveButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(15);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.REMOVE);
    }

    public static AnActionButton findUpButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(16);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.UP);
    }

    public static AnActionButton findDownButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(17);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.DOWN);
    }

    private static AnActionButton findButton(JComponent comp, CommonActionsPanel.Buttons type) {
        CommonActionsPanel panel = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)comp, CommonActionsPanel.class);
        if (panel != null) {
            return panel.getAnActionButton(type);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDecorator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExtraAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setActionGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAddButton";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findEditButton";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRemoveButton";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUpButton";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDownButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ElementActionButton
    extends AnActionButton {
        public ElementActionButton(String text, String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        public ElementActionButton(String text, Icon icon) {
            super(text, icon);
        }

        public ElementActionButton() {
        }

        public ElementActionButton(String text) {
            super(text);
        }
    }
}

