/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;

public class ScrollPaneFactory
implements ScrollPaneConstants {
    private ScrollPaneFactory() {
    }

    public static JScrollPane createScrollPane() {
        return new JBScrollPane();
    }

    public static JScrollPane createScrollPane(Component view) {
        return new JBScrollPane(view);
    }

    public static JScrollPane createScrollPane(@JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(vsbPolicy, hsbPolicy);
    }

    public static JScrollPane createScrollPane(Component view, @JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(view, vsbPolicy, hsbPolicy);
    }

    public static JScrollPane createScrollPane(Component view, boolean withoutBorder) {
        JBScrollPane scrollPane = new JBScrollPane(view);
        if (withoutBorder) {
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        }
        return scrollPane;
    }

    public static JScrollPane createScrollPane(Component view, int borders) {
        JBScrollPane scrollPane = new JBScrollPane(view);
        scrollPane.setBorder(IdeBorderFactory.createBorder(borders));
        return scrollPane;
    }
}

