/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    private boolean myUseCygwinLaunch;
    private boolean myConsoleMode = true;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        Process process;
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(0);
        }
        try {
            process = this.startProcessWithPty(commands, this.myConsoleMode);
        }
        catch (Throwable t) {
            File logFile = PtyCommandLine.getPtyLogFile();
            if (logFile != null && logFile.exists()) {
                String logContent;
                try {
                    logContent = FileUtil.loadFile((File)logFile);
                }
                catch (Exception e) {
                    logContent = "Unable to retrieve log: " + e.getMessage();
                }
                LOG.error("Couldn't run process with PTY", t, new String[]{logContent});
            } else {
                LOG.error("Couldn't run process with PTY", t);
            }
            Process process2 = super.startProcess(commands);
            if (process2 == null) {
                PtyCommandLine.$$$reportNull$$$0(2);
            }
            return process2;
        }
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(1);
        }
        return process;
    }

    public void setUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myUseCygwinLaunch = useCygwinLaunch;
    }

    public void setConsoleMode(boolean consoleMode) {
        this.myConsoleMode = consoleMode;
    }

    private static File getPtyLogFile() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands, boolean console) throws IOException {
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(3);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (this.isRedirectErrorStream()) {
            LOG.error("Launching process with PTY and redirected error stream is unsupported yet");
        }
        String[] command = ArrayUtil.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        boolean cygwin = this.myUseCygwinLaunch && SystemInfo.isWindows;
        PtyProcess ptyProcess = PtyProcess.exec((String[])command, env, (String)directory, (boolean)console, (boolean)cygwin, (File)PtyCommandLine.getPtyLogFile());
        if (ptyProcess == null) {
            PtyCommandLine.$$$reportNull$$$0(4);
        }
        return ptyProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessWithPty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startProcessWithPty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

