/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegExpLanguageHost {
    public static final EnumSet<RegExpGroup.Type> EMPTY_NAMED_GROUP_TYPES = EnumSet.noneOf(RegExpGroup.Type.class);

    public boolean characterNeedsEscaping(char var1);

    public boolean supportsPerl5EmbeddedComments();

    public boolean supportsPossessiveQuantifiers();

    public boolean supportsPythonConditionalRefs();

    public boolean supportsNamedGroupSyntax(RegExpGroup var1);

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef var1);

    @NotNull
    default public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            RegExpLanguageHost.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar var1);

    default public boolean isValidGroupName(String name, @NotNull PsiElement context) {
        if (context == null) {
            RegExpLanguageHost.$$$reportNull$$$0(1);
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (AsciiUtil.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    default public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        return true;
    }

    default public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return false;
    }

    default public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return this.supportsNamedCharacters(namedCharacter);
    }

    default public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return false;
            }
        }
        return true;
    }

    default public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return true;
    }

    default public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        return true;
    }

    public boolean isValidCategory(@NotNull String var1);

    @NotNull
    public String[][] getAllKnownProperties();

    @Nullable
    public String getPropertyDescription(@Nullable String var1);

    @NotNull
    public String[][] getKnownCharacterClasses();

    @Nullable
    default public Number getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            RegExpLanguageHost.$$$reportNull$$$0(2);
        }
        return Double.parseDouble(number.getText());
    }

    default public Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            RegExpLanguageHost.$$$reportNull$$$0(3);
        }
        return Lookbehind.FULL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Lookbehind {
        NOT_SUPPORTED,
        FIXED_LENGTH_ALTERNATION,
        VARIABLE_LENGTH_ALTERNATION,
        FINITE_REPETITION,
        FULL;

    }
}

