/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a>\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b\u001a\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b\u001a$\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b\u001a4\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b\u001a\u001c\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\u00012\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010)\u001a\u00020**\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010+\u001a\u00020\u0011\u001a\u0016\u0010,\u001a\u00020\u0011*\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\f\u0010-\u001a\u00020.*\u00020\u0002H\u0002\u001a\u0014\u0010/\u001a\u00020\u0011*\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u001a\u0014\u00100\u001a\u00020\u0011*\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u001a\u0016\u00101\u001a\u00020\u0011*\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\u001a\u00102\u001a\u0004\u0018\u00010\u0002*\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b\u001a$\u00103\u001a\u0004\u0018\u00010\u0002*\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\" \u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\"\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"associatedPathFromAdditionalData", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getAssociatedPathFromAdditionalData", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "associatedPathFromDotProject", "associatedPathFromDotProject$annotations", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "getAssociatedPathFromDotProject", "associatedProjectPath", "getAssociatedProjectPath", "guessedLanguageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "getGuessedLanguageLevel", "(Lcom/jetbrains/python/sdk/PyDetectedSdk;)Lcom/jetbrains/python/psi/LanguageLevel;", "isNotEmptyDirectory", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "isSystemWide", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "createSdkByGenerateTask", "generateSdkHomePath", "Lcom/intellij/openapi/progress/Task$WithResult;", "Lcom/intellij/execution/ExecutionException;", "existingSdks", "", "baseSdk", "detectCondaEnvs", "project", "Lcom/intellij/openapi/project/Project;", "detectSystemWideSdks", "detectVirtualEnvs", "filterSuggestedPaths", "suggestedPaths", "", "findBaseSdks", "suggestAssociatedSdkName", "sdkHome", "associatedPath", "associateWithProject", "", "isNewProject", "containsProjectName", "getOrCreateAdditionalData", "Lcom/jetbrains/python/sdk/PythonSdkAdditionalData;", "isAssociatedWithAnotherProject", "isAssociatedWithProject", "isLocatedInsideProject", "setup", "setupAssociated", "python-community"})
public final class PySdkExtKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> findBaseSdks(@NotNull List<? extends Sdk> existingSdks) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            if (!PySdkExtKt.isSystemWide(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existing = (List)destination$iv$iv;
        List<PyDetectedSdk> detected = PySdkExtKt.detectSystemWideSdks(existingSdks);
        return CollectionsKt.plus((Collection)existing, (Iterable)detected);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PyDetectedSdk> detectSystemWideSdks(@NotNull List<? extends Sdk> existingSdks) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)PythonSdkFlavor.getApplicableFlavors(false)), (Function1)detectSystemWideSdks.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(String it) {
                return !this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set2;
                super(1);
            }
        })), (Function1)detectSystemWideSdks.3.INSTANCE);
        Comparator comparator2 = ComparisonsKt.compareBy((Function1[])new Function1[]{detectSystemWideSdks.4.INSTANCE, detectSystemWideSdks.5.INSTANCE}).reversed();
        Intrinsics.checkExpressionValueIsNotNull(comparator2, (String)"compareBy<PyDetectedSdk>\u2026it.homePath }).reversed()");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator2));
    }

    @NotNull
    public static final List<PyDetectedSdk> detectVirtualEnvs(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Collection<String> collection = VirtualEnvSdkFlavor.INSTANCE.suggestHomePaths();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"VirtualEnvSdkFlavor.INSTANCE.suggestHomePaths()");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, project);
    }

    @NotNull
    public static final List<PyDetectedSdk> detectCondaEnvs(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Collection<String> collection = CondaEnvSdkFlavor.INSTANCE.suggestHomePaths();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"CondaEnvSdkFlavor.INSTANCE.suggestHomePaths()");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, project);
    }

    @Nullable
    public static final Sdk createSdkByGenerateTask(@NotNull Task.WithResult<String, ExecutionException> generateSdkHomePath, @NotNull List<? extends Sdk> existingSdks, @Nullable Sdk baseSdk, @Nullable String associatedProjectPath) {
        Collection $receiver$iv;
        String homePath;
        Intrinsics.checkParameterIsNotNull(generateSdkHomePath, (String)"generateSdkHomePath");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        try {
            homePath = (String)ProgressManager.getInstance().run(generateSdkHomePath);
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(homePath);
            if (virtualFile == null) {
                throw (Throwable)new ExecutionException("Directory " + homePath + " not found");
            }
            homePath = virtualFile;
        }
        catch (ExecutionException e) {
            PackageManagementService.ErrorDescription errorDescription = PyPackageManagementService.toErrorDescription(CollectionsKt.listOf((Object)((Object)e)), baseSdk);
            if (errorDescription == null) {
                return null;
            }
            PackageManagementService.ErrorDescription description = errorDescription;
            PackagesNotificationPanel.showError("Failed to Create Interpreter", description);
            return null;
        }
        String homeFile = homePath;
        String string = homeFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homeFile.path");
        String suggestedName = PySdkExtKt.suggestAssociatedSdkName(string, associatedProjectPath);
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[thisCollection$iv.size()]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Sdk sdk = SdkConfigurationUtil.setupSdk(sdkArray, (VirtualFile)homeFile, PythonSdkType.getInstance(), false, null, suggestedName);
        if (sdk == null) {
            return null;
        }
        return sdk;
    }

    public static final void associateWithProject(@NotNull Sdk $receiver, @Nullable Project project, boolean isNewProject) {
        PythonSdkAdditionalData pythonSdkAdditionalData;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PythonSdkAdditionalData $receiver2 = pythonSdkAdditionalData = PySdkExtKt.getOrCreateAdditionalData($receiver);
        if (isNewProject) {
            $receiver2.associateWithNewProject();
        } else if (project != null) {
            $receiver2.associateWithProject(project);
        }
    }

    public static final boolean isAssociatedWithProject(@NotNull Sdk $receiver, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Project project2 = project;
        String basePath = project2 != null ? project2.getBasePath() : null;
        String associatedPath = PySdkExtKt.getAssociatedProjectPath($receiver);
        if (basePath != null && Intrinsics.areEqual((Object)associatedPath, (Object)basePath)) {
            return true;
        }
        if (PySdkExtKt.isAssociatedWithAnotherProject($receiver, project)) {
            return false;
        }
        return PySdkExtKt.isLocatedInsideProject($receiver, project) || PySdkExtKt.containsProjectName($receiver, project);
    }

    public static final boolean isAssociatedWithAnotherProject(@NotNull Sdk $receiver, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = project;
        if (object == null || (object = object.getBasePath()) == null) {
            return false;
        }
        Object basePath = object;
        String string = PySdkExtKt.getAssociatedProjectPath($receiver);
        if (string == null) {
            return false;
        }
        String associatedPath = string;
        return Intrinsics.areEqual((Object)basePath, (Object)associatedPath) ^ true;
    }

    @Nullable
    public static final String getAssociatedProjectPath(@NotNull Sdk $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PySdkExtKt.getAssociatedPathFromAdditionalData($receiver);
    }

    @Nullable
    public static final Sdk setup(@NotNull PyDetectedSdk $receiver, @NotNull List<? extends Sdk> existingSdks) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $receiver.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile homeDir = virtualFile;
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[thisCollection$iv.size()]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk(sdkArray, homeDir, PythonSdkType.getInstance(), false, null, null);
    }

    @Nullable
    public static final Sdk setupAssociated(@NotNull PyDetectedSdk $receiver, @NotNull List<? extends Sdk> existingSdks, @Nullable String associatedProjectPath) {
        Collection $receiver$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $receiver.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile homeDir = virtualFile;
        String string2 = $receiver.getHomePath();
        if (string2 != null) {
            String string3;
            String it;
            String string4 = it = (string3 = string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            string = PySdkExtKt.suggestAssociatedSdkName(string4, associatedProjectPath);
        } else {
            string = null;
        }
        String suggestedName = string;
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[thisCollection$iv.size()]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk(sdkArray, homeDir, PythonSdkType.getInstance(), false, null, suggestedName);
    }

    private static final String suggestAssociatedSdkName(String sdkHome, String associatedPath) {
        String string;
        String baseSdkName;
        block5: {
            block7: {
                String string2;
                block6: {
                    String condaRoot;
                    block4: {
                        String string3 = PythonSdkType.suggestBaseSdkName(sdkHome);
                        if (string3 == null) {
                            return null;
                        }
                        baseSdkName = string3;
                        File file2 = PythonSdkType.getVirtualEnvRoot(sdkHome);
                        String venvRoot = file2 != null ? file2.getPath() : null;
                        File file3 = CondaEnvSdkFlavor.getCondaEnvRoot(sdkHome);
                        String string4 = condaRoot = file3 != null ? file3.getPath() : null;
                        if (venvRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)venvRoot, (boolean)true)) break block4;
                        string = PathUtil.getFileName((String)venvRoot);
                        break block5;
                    }
                    if (condaRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)condaRoot, (boolean)true)) break block6;
                    string = PathUtil.getFileName((String)condaRoot);
                    break block5;
                }
                string = associatedPath;
                if (string == null) break block7;
                String it = string2 = string;
                string = PathUtil.getFileName((String)associatedPath);
                if (string != null) break block5;
            }
            return null;
        }
        String associatedName = string;
        return "" + baseSdkName + " (" + associatedName + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmptyDirectory(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.exists()) return false;
        if (!$receiver.isDirectory()) return false;
        String[] stringArray = $receiver.list();
        if (stringArray == null) return false;
        Object[] objectArray = stringArray;
        if (objectArray.length != 0) return true;
        return false;
    }

    private static final boolean isSystemWide(@NotNull Sdk $receiver) {
        return !PythonSdkType.isRemote($receiver) && !PythonSdkType.isVirtualEnv($receiver) && !PythonSdkType.isCondaVirtualEnv($receiver);
    }

    private static /* synthetic */ void associatedPathFromDotProject$annotations(Sdk sdk) {
    }

    private static final String getAssociatedPathFromDotProject(@NotNull Sdk $receiver) {
        String string;
        String string2 = $receiver.getHomePath();
        if (string2 == null) {
            return null;
        }
        String binaryPath = string2;
        File file2 = PythonSdkType.getVirtualEnvRoot(binaryPath);
        if (file2 == null) {
            return null;
        }
        File virtualEnvRoot = file2;
        File projectFile = new File(virtualEnvRoot, ".project");
        try {
            String string3 = string = FilesKt.readText$default((File)projectFile, null, (int)1, null);
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    private static final String getAssociatedPathFromAdditionalData(@NotNull Sdk $receiver) {
        SdkAdditionalData sdkAdditionalData = $receiver.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkAdditionalData;
        return pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getAssociatedProjectPath() : null;
    }

    private static final boolean isLocatedInsideProject(@NotNull Sdk $receiver, Project project) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return false;
        }
        String homePath = string;
        Object object = project;
        if (object == null || (object = object.getBasePath()) == null) {
            return false;
        }
        Object basePath = object;
        return FileUtil.isAncestor((String)basePath, (String)homePath, (boolean)true);
    }

    private static final LanguageLevel getGuessedLanguageLevel(@NotNull PyDetectedSdk $receiver) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return null;
        }
        String path = string;
        Regex regex = new Regex(".*python(\\d\\.\\d)");
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        String string3 = (String)CollectionsKt.getOrNull((List)result2.getGroupValues(), (int)1);
        if (string3 == null) {
            return null;
        }
        String versionString = string3;
        return LanguageLevel.fromPythonVersion(versionString);
    }

    private static final boolean containsProjectName(@NotNull Sdk $receiver, Project project) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return false;
        }
        String path = string;
        Object object = project;
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object name = object;
        CharSequence charSequence = path;
        Object object2 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"name");
        return StringsKt.contains((CharSequence)charSequence, (CharSequence)((CharSequence)object2), (boolean)true);
    }

    private static final PythonSdkAdditionalData getOrCreateAdditionalData(@NotNull Sdk $receiver) {
        PythonSdkAdditionalData existingData;
        SdkAdditionalData sdkAdditionalData = $receiver.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        if ((existingData = (PythonSdkAdditionalData)sdkAdditionalData) != null) {
            return existingData;
        }
        PythonSdkAdditionalData newData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor($receiver.getHomePath()));
        SdkModificator modificator = $receiver.getSdkModificator();
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(new Runnable(modificator){
            final /* synthetic */ SdkModificator $modificator;

            public final void run() {
                this.$modificator.commitChanges();
            }
            {
                this.$modificator = sdkModificator;
            }
        });
        return newData;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PyDetectedSdk> filterSuggestedPaths(Collection<String> suggestedPaths, List<? extends Sdk> existingSdks, Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)suggestedPaths), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set2;
                super(1);
            }
        }))), (Function1)filterSuggestedPaths.2.INSTANCE);
        Comparator comparator2 = ComparisonsKt.compareBy((Function1[])new Function1[]{(Function1)new Function1<PyDetectedSdk, Boolean>(project){
            final /* synthetic */ Project $project;

            public final boolean invoke(@NotNull PyDetectedSdk it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return PySdkExtKt.isAssociatedWithProject(it, this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        }, filterSuggestedPaths.4.INSTANCE}).reversed();
        Intrinsics.checkExpressionValueIsNotNull(comparator2, (String)"compareBy<PyDetectedSdk>\u2026it.homePath }).reversed()");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator2));
    }

    @Nullable
    public static final /* synthetic */ LanguageLevel access$getGuessedLanguageLevel$p(@NotNull PyDetectedSdk $receiver) {
        return PySdkExtKt.getGuessedLanguageLevel($receiver);
    }
}

