/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.RowIcon;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMemberSelectionTable
extends AbstractMemberSelectionTable<PyElement, PyMemberInfo<PyElement>> {
    private static final String ABSTRACT_TITLE = RefactoringBundle.message((String)"make.abstract");
    private final boolean mySupportAbstract;

    public PyMemberSelectionTable(@NotNull List<PyMemberInfo<PyElement>> memberInfos, @Nullable MemberInfoModel<PyElement, PyMemberInfo<PyElement>> model, boolean supportAbstract) {
        if (memberInfos == null) {
            PyMemberSelectionTable.$$$reportNull$$$0(0);
        }
        super(memberInfos, model, supportAbstract ? ABSTRACT_TITLE : null);
        this.mySupportAbstract = supportAbstract;
    }

    @Override
    @Nullable
    protected Object getAbstractColumnValue(PyMemberInfo<PyElement> memberInfo) {
        return this.mySupportAbstract && memberInfo.isChecked() && this.myMemberInfoModel.isAbstractEnabled(memberInfo) ? Boolean.valueOf(memberInfo.isToAbstract()) : null;
    }

    @Override
    protected boolean isAbstractColumnEditable(int rowIndex) {
        return this.mySupportAbstract && this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)this.myMemberInfos.get(rowIndex));
    }

    @Override
    protected void setVisibilityIcon(PyMemberInfo<PyElement> memberInfo, RowIcon icon) {
    }

    @Override
    protected Icon getOverrideIcon(PyMemberInfo<PyElement> memberInfo) {
        PsiElement member = memberInfo.getMember();
        Icon overrideIcon = EMPTY_OVERRIDE_ICON;
        if (member instanceof PyFunction && memberInfo.getOverrides() != null && memberInfo.getOverrides().booleanValue()) {
            overrideIcon = AllIcons.General.OverridingMethod;
        }
        return overrideIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfos", "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionTable", "<init>"));
    }
}

