/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.TypeEvalStack;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.impl.references.PyTargetReference;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTargetExpressionImpl
extends PyBaseElementImpl<PyTargetExpressionStub>
implements PyTargetExpression {
    @Nullable
    private volatile QualifiedName myQualifiedName;

    public PyTargetExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub) {
        super(stub, PyElementTypes.TARGET_EXPRESSION);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyTargetExpression(this);
    }

    @Override
    @Nullable
    public String getName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameElement();
        return node != null ? node.getText() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public PsiElement getNameIdentifier() {
        ASTNode nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getPsi();
    }

    @Override
    public String getReferencedName() {
        return this.getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode oldNameElement;
        if (name == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((oldNameElement = this.getNameElement()) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameElement, nameElement);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(1);
        }
        if (key == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(2);
        }
        if (!TypeEvalStack.mayEvaluate(this)) {
            return null;
        }
        try {
            PyType pyType;
            Object assignment;
            Object nextParent;
            if ("__all__".equals(this.getName())) {
                PyType pyType2 = null;
                return pyType2;
            }
            PyType pyType3 = PyReferenceExpressionImpl.getReferenceTypeFromProviders(this, context, null);
            if (pyType3 != null) {
                PyType pyType4 = pyType3;
                return pyType4;
            }
            PyType type = this.getTypeFromDocString();
            if (type != null) {
                PyType pyType5 = type;
                return pyType5;
            }
            if (!context.maySwitchToAST(this)) {
                PsiElement value = this.resolveAssignedValue(PyResolveContext.noImplicits().withTypeEvalContext(context));
                if (value instanceof PyTypedElement) {
                    type = context.getType((PyTypedElement)value);
                    if (type instanceof PyNoneType) {
                        PyType pyType6 = null;
                        return pyType6;
                    }
                    PyType pyType7 = type;
                    return pyType7;
                }
                PyType pyType8 = null;
                return pyType8;
            }
            type = PyTargetExpressionImpl.getTypeFromComment(this);
            if (type != null) {
                PyType value = type;
                return value;
            }
            PsiElement parent = this.getParent();
            if (parent instanceof PyAssignmentStatement) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)parent;
                PyExpression assignedValue = assignmentStatement.getAssignedValue();
                if (assignedValue instanceof PyParenthesizedExpression) {
                    assignedValue = ((PyParenthesizedExpression)assignedValue).getContainedExpression();
                }
                if (assignedValue != null) {
                    if (assignedValue instanceof PyYieldExpression) {
                        PyYieldExpression assignedYield = (PyYieldExpression)assignedValue;
                        PyType pyType9 = assignedYield.isDelegating() ? context.getType(assignedValue) : null;
                        return pyType9;
                    }
                    PyType assignedYield = context.getType(assignedValue);
                    return assignedYield;
                }
            }
            if (parent instanceof PyTupleExpression) {
                nextParent = parent.getParent();
                while (nextParent instanceof PyParenthesizedExpression || nextParent instanceof PyTupleExpression) {
                    nextParent = nextParent.getParent();
                }
                if (nextParent instanceof PyAssignmentStatement) {
                    PyType t;
                    PyType assignedType;
                    assignment = (PyAssignmentStatement)nextParent;
                    PyExpression value = assignment.getAssignedValue();
                    PyExpression lhs = assignment.getLeftHandSideExpression();
                    PyTupleExpression targetTuple = (PyTupleExpression)PsiTreeUtil.findChildOfType((PsiElement)lhs, PyTupleExpression.class, (boolean)false);
                    if (value != null && targetTuple != null && (assignedType = PyTypeChecker.toNonWeakType(context.getType(value), context)) != null && (t = PyTypeChecker.getTargetTypeFromTupleAssignment(this, targetTuple, assignedType, context)) != null) {
                        PyType pyType10 = t;
                        return pyType10;
                    }
                }
            }
            if (parent instanceof PyWithItem) {
                nextParent = PyTargetExpressionImpl.getWithItemVariableType((PyWithItem)parent, context);
                return nextParent;
            }
            PyType iterType = this.getTypeFromIteration(context);
            if (iterType != null) {
                assignment = iterType;
                return assignment;
            }
            PyType excType = this.getTypeFromExcept();
            if (excType != null) {
                pyType = excType;
                return pyType;
            }
            pyType = null;
            return pyType;
        }
        finally {
            TypeEvalStack.evaluated(this);
        }
    }

    @Override
    @Nullable
    public PyAnnotation getAnnotation() {
        PyTargetExpressionImpl topTarget = this;
        while (topTarget.getParent() instanceof PyParenthesizedExpression) {
            topTarget = topTarget.getParent();
        }
        PsiElement parent = topTarget.getParent();
        if (parent != null) {
            PyAssignmentStatement assignment = PyUtil.as(parent, PyAssignmentStatement.class);
            if (assignment != null) {
                PyExpression[] targets = assignment.getRawTargets();
                if (targets.length == 1 && targets[0] == topTarget) {
                    return assignment.getAnnotation();
                }
            } else if (parent instanceof PyTypeDeclarationStatement) {
                return ((PyTypeDeclarationStatement)parent).getAnnotation();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyTargetExpressionImpl.getAnnotationContentFromStubOrPsi(this);
    }

    @Nullable
    private static PyType getWithItemVariableType(@NotNull PyWithItem item, @NotNull TypeEvalContext context) {
        PyExpression withExpression;
        if (item == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((withExpression = item.getExpression()) != null) {
            boolean isAsync;
            PyType withType = context.getType(withExpression);
            PyWithStatement withStatement = (PyWithStatement)PsiTreeUtil.getParentOfType((PsiElement)item, PyWithStatement.class);
            boolean bl = isAsync = withStatement != null && withStatement.isAsync();
            if (withType instanceof PyClassType) {
                return PyTargetExpressionImpl.getEnterTypeFromPyClass(withExpression, (PyClassType)withType, isAsync, context);
            }
            if (withType instanceof PyUnionType) {
                List enterTypes = StreamEx.of(((PyUnionType)withType).getMembers()).select(PyClassType.class).map(t -> {
                    if (context == null) {
                        PyTargetExpressionImpl.$$$reportNull$$$0(31);
                    }
                    return PyTargetExpressionImpl.getEnterTypeFromPyClass(withExpression, t, isAsync, context);
                }).toList();
                return PyUnionType.union(enterTypes);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getEnterTypeFromPyClass(@NotNull PyExpression withExpression, @NotNull PyClassType withType, boolean isAsync, @NotNull TypeEvalContext context) {
        PyClass cls;
        PyFunction enter;
        if (withExpression == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(5);
        }
        if (withType == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((enter = (cls = withType.getPyClass()).findMethodByName(isAsync ? "__aenter__" : "__enter__", true, context)) != null) {
            PyType enterType = enter.getCallType(withExpression, Collections.emptyMap(), context);
            if (enterType != null) {
                return isAsync ? (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(enterType)) : enterType;
            }
            for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
                PyType typeFromProvider = provider.getContextManagerVariableType(cls, withExpression, context);
                if (typeFromProvider == null) continue;
                return typeFromProvider;
            }
            return PyUnionType.createWeakType(withType);
        }
        return null;
    }

    @Nullable
    public PyType getTypeFromDocString() {
        StructuredDocString classDocString;
        PyClass cls;
        String typeName = null;
        String name = this.getName();
        StructuredDocString targetDocString = this.getStructuredDocString();
        if (targetDocString != null && (typeName = targetDocString.getParamType(null)) == null) {
            typeName = targetDocString.getParamType(name);
        }
        if (typeName == null && PyUtil.isAttribute(this) && (cls = this.getContainingClass()) != null && (classDocString = cls.getStructuredDocString()) != null) {
            typeName = classDocString.getParamType(name);
        }
        if (typeName != null) {
            return PyTypeParser.getTypeByName(this, typeName);
        }
        return null;
    }

    @Nullable
    public static PyType getTypeFromComment(PyTargetExpressionImpl targetExpression) {
        String docComment = DocStringUtil.getAttributeDocComment(targetExpression);
        if (docComment != null) {
            StructuredDocString structuredDocString = DocStringUtil.parse(docComment, targetExpression);
            String typeName = structuredDocString.getParamType(null);
            if (typeName == null) {
                typeName = structuredDocString.getParamType(targetExpression.getName());
            }
            if (typeName != null) {
                return PyTypeParser.getTypeByName(targetExpression, typeName);
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromIteration(@NotNull TypeEvalContext context) {
        PyComprehensionElement comprh;
        PyExpression expr;
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(8);
        }
        PyExpression target2 = null;
        PyExpression source = null;
        PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyForPart.class);
        if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)(expr = forPart.getTarget()), (PsiElement)this, (boolean)false)) {
            target2 = expr;
            source = forPart.getSource();
        }
        if ((comprh = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyComprehensionElement.class)) != null) {
            for (PyComprehensionForComponent c : comprh.getForComponents()) {
                PyExpression expr2 = c.getIteratorVariable();
                if (!PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)this, (boolean)false)) continue;
                target2 = expr2;
                source = c.getIteratedList();
            }
        }
        if (source != null) {
            PyType sourceType = context.getType(source);
            PyType type = PyTargetExpressionImpl.getIterationType(sourceType, source, this, context);
            if (type instanceof PyTupleType && target2 instanceof PyTupleExpression) {
                return PyTypeChecker.getTargetTypeFromTupleAssignment(this, (PyTupleExpression)target2, (PyTupleType)type);
            }
            if (target2 == this && type != null) {
                return type;
            }
        }
        return null;
    }

    @Nullable
    public static PyType getIterationType(@Nullable PyType iterableType, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyFunction iterateMethod;
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(10);
        }
        if (iterableType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)iterableType;
            return tupleType.getIteratedItemType();
        }
        if (iterableType instanceof PyUnionType) {
            Collection<PyType> members = ((PyUnionType)iterableType).getMembers();
            ArrayList<PyType> iterationTypes = new ArrayList<PyType>();
            for (PyType member : members) {
                iterationTypes.add(PyTargetExpressionImpl.getIterationType(member, source, anchor, context));
            }
            return PyUnionType.union(iterationTypes);
        }
        if (iterableType != null && PyABCUtil.isSubtype(iterableType, "Iterable", context)) {
            PyFunction iterateMethod2 = PyTargetExpressionImpl.findMethodByName(iterableType, "__iter__", context);
            if (iterateMethod2 != null) {
                PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod2, context, source);
                return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, false);
            }
            Ref<PyType> nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(iterableType, source, anchor, context, false);
            if (nextMethodCallType != null) {
                return (PyType)nextMethodCallType.get();
            }
            PyFunction getItem = PyTargetExpressionImpl.findMethodByName(iterableType, "__getitem__", context);
            if (getItem != null) {
                return PyTargetExpressionImpl.getContextSensitiveType(getItem, context, source);
            }
        } else if (iterableType != null && PyABCUtil.isSubtype(iterableType, "AsyncIterable", context) && (iterateMethod = PyTargetExpressionImpl.findMethodByName(iterableType, "__aiter__", context)) != null) {
            PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod, context, source);
            return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, true);
        }
        return null;
    }

    @Nullable
    private static PyType getIteratedItemType(@Nullable PyType type, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(12);
        }
        if (type instanceof PyCollectionType) {
            return ((PyCollectionType)type).getIteratedItemType();
        }
        Ref<PyType> nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(type, source, anchor, context, async);
        if (nextMethodCallType != null) {
            return (PyType)nextMethodCallType.get();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getNextMethodCallType(@Nullable PyType type, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(14);
        }
        if (type == null) {
            return null;
        }
        String nextMethodName = async ? "__anext__" : (LanguageLevel.forElement(anchor).isAtLeast(LanguageLevel.PYTHON30) ? "__next__" : "next");
        PyFunction next = PyTargetExpressionImpl.findMethodByName(type, nextMethodName, context);
        if (next != null) {
            return Ref.create((Object)PyTargetExpressionImpl.getContextSensitiveType(next, context, source));
        }
        return null;
    }

    @Nullable
    private static PyFunction findMethodByName(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        RatedResolveResult result2;
        PsiElement element;
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(17);
        }
        if ((results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context))) != null && !results.isEmpty() && (element = (result2 = results.get(0)).getElement()) instanceof PyFunction) {
            return (PyFunction)element;
        }
        return null;
    }

    @Nullable
    public static PyType getContextSensitiveType(@NotNull PyFunction function, @NotNull TypeEvalContext context, @Nullable PyExpression source) {
        if (function == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(19);
        }
        return function.getCallType(source, Collections.emptyMap(), context);
    }

    @Nullable
    private PyType getTypeFromExcept() {
        PsiElement element;
        PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyExceptPart.class);
        if (exceptPart == null || exceptPart.getTarget() != this) {
            return null;
        }
        PyExpression exceptClass = exceptPart.getExceptClass();
        if (exceptClass instanceof PyReferenceExpression && (element = ((PyReferenceExpression)exceptClass).getReference().resolve()) instanceof PyClass) {
            return new PyClassTypeImpl((PyClass)element, false);
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        ASTNode qualifier = this.getNode().findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        return qualifier != null ? (PyExpression)qualifier.getPsi() : null;
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = PyPsiUtils.asQualifiedName(this);
        }
        return this.myQualifiedName;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getName();
    }

    public Icon getIcon(int flags) {
        if (this.isQualified() || PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyDocStringOwner.class) instanceof PyClass) {
            return PlatformIcons.FIELD_ICON;
        }
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public boolean isQualified() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.isQualified();
        }
        return this.getQualifier() != null;
    }

    @Override
    @Nullable
    public PsiElement resolveAssignedValue(@NotNull PyResolveContext resolveContext) {
        List components;
        ScopeOwner owner;
        TypeEvalContext context;
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(20);
        }
        if ((context = resolveContext.getTypeEvalContext()).maySwitchToAST(this)) {
            PyExpression value = this.findAssignedValue();
            if (value != null) {
                List<PsiElement> results = PyUtil.multiResolveTopPriority((PsiElement)value, resolveContext);
                return !results.isEmpty() ? results.get(0) : null;
            }
            return null;
        }
        QualifiedName qName = this.getAssignedQName();
        if (qName != null && (owner = ScopeUtil.getScopeOwner(this)) instanceof PyTypedElement && !(components = qName.getComponents()).isEmpty()) {
            ScopeOwner resolved = owner;
            for (String component : components) {
                if (!(resolved instanceof PyTypedElement)) {
                    return null;
                }
                PyType qualifierType = context.getType((PyTypedElement)((Object)resolved));
                if (qualifierType == null) {
                    return null;
                }
                List<? extends RatedResolveResult> results = qualifierType.resolveMember(component, null, AccessDirection.READ, resolveContext);
                if (results == null || results.isEmpty()) {
                    return null;
                }
                resolved = results.get(0).getElement();
            }
            return resolved;
        }
        return null;
    }

    @Override
    @Nullable
    public PyExpression findAssignedValue() {
        PyPsiUtils.assertValid(this);
        return (PyExpression)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findAssignedValueInternal(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PyExpression findAssignedValueInternal() {
        PyImportElement importElement;
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAssignmentStatement.class);
        if (assignment != null) {
            List<Pair<PyExpression, PyExpression>> mapping = assignment.getTargetsToValuesMapping();
            for (Pair<PyExpression, PyExpression> pair : mapping) {
                PyExpression assigned_to = (PyExpression)pair.getFirst();
                if (assigned_to != this) continue;
                return (PyExpression)pair.getSecond();
            }
        }
        if ((importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyImportElement.class)) != null) {
            return importElement.getImportReferenceExpression();
        }
        return null;
    }

    @Override
    @Nullable
    public QualifiedName getAssignedQName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                return stub.getInitializer();
            }
            return null;
        }
        return PyPsiUtils.asQualifiedName(this.findAssignedValue());
    }

    @Override
    public QualifiedName getCalleeName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            CustomTargetExpressionStub customStub;
            PyTargetExpressionStub.InitializerType initializerType = stub.getInitializerType();
            if (initializerType == PyTargetExpressionStub.InitializerType.CallExpression) {
                return stub.getInitializer();
            }
            if (initializerType == PyTargetExpressionStub.InitializerType.Custom && (customStub = stub.getCustomStub(CustomTargetExpressionStub.class)) != null) {
                return customStub.getCalleeName();
            }
            return null;
        }
        PyExpression value = this.findAssignedValue();
        if (value instanceof PyCallExpression) {
            PyExpression callee = ((PyCallExpression)value).getCallee();
            return PyPsiUtils.asQualifiedName(callee);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext());
        if (psiPolyVariantReference == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(21);
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(22);
        }
        if (this.isQualified()) {
            PyQualifiedReference pyQualifiedReference = new PyQualifiedReference(this, resolveContext);
            if (pyQualifiedReference == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(23);
            }
            return pyQualifiedReference;
        }
        PyTargetReference pyTargetReference = new PyTargetReference(this, resolveContext);
        if (pyTargetReference == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(24);
        }
        return pyTargetReference;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isQualified()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(25);
            }
            return searchScope;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(this);
        if (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            if (scope.isGlobal(this.getName())) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.getProject());
                if (globalSearchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(26);
                }
                return globalSearchScope;
            }
            if (scope.isNonlocal(this.getName())) {
                LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.getContainingFile());
                if (localSearchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(27);
                }
                return localSearchScope;
            }
        }
        PyElement container = this;
        while (true) {
            PyElement parentContainer;
            if ((parentContainer = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)container, (Class[])new Class[]{PyFunction.class, PyClass.class})) instanceof PyClass) {
                if (!this.isQualified()) break;
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(28);
                }
                return searchScope;
            }
            if (parentContainer == null) break;
            container = parentContainer;
        }
        if (container instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)container);
            if (localSearchScope == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(29);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(30);
        }
        return searchScope;
    }

    @Override
    public PyClass getContainingClass() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            StubElement functionParent;
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            if (parentStub instanceof PyFunctionStub && (functionParent = parentStub.getParentStub()) instanceof PyClassStub) {
                return (PyClass)((PyClassStub)functionParent).getPsi();
            }
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PyFunction.class, PyClass.class});
        if (parent instanceof PyClass) {
            return (PyClass)parent;
        }
        if (parent instanceof PyFunction) {
            return ((PyFunction)parent).getContainingClass();
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @Nullable
            public String getLocationString() {
                PyClass containingClass = PyTargetExpressionImpl.this.getContainingClass();
                if (containingClass != null) {
                    return "(" + containingClass.getName() + " in " + 1.getPackageForFile(PyTargetExpressionImpl.this.getContainingFile()) + ")";
                }
                return super.getLocationString();
            }
        };
    }

    @Override
    @Nullable
    public String getDocStringValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        PyExpression expression;
        PsiElement nextSibling;
        PsiElement parent = this.getParent();
        if (parent instanceof PyAssignmentStatement && (nextSibling = PyPsiUtils.getNextNonCommentSibling(parent, true)) instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)nextSibling).getExpression()) instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)expression;
        }
        return null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myQualifiedName = null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @Nullable
    public PsiComment getTypeComment() {
        PsiComment comment = null;
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAssignmentStatement.class);
        if (assignment != null) {
            PyExpression assignedValue = assignment.getAssignedValue();
            if (assignedValue != null && !PsiTreeUtil.isAncestor((PsiElement)assignedValue, (PsiElement)this, (boolean)false)) {
                comment = PyUtil.as(PyPsiUtils.getNextNonWhitespaceSiblingOnSameLine((PsiElement)assignedValue), PsiComment.class);
            }
        } else {
            PyWithItem withPart;
            PyStatementListContainer forOrWith = null;
            PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyForPart.class);
            if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)forPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = forPart;
            }
            if ((withPart = (PyWithItem)PsiTreeUtil.getParentOfType((PsiElement)this, PyWithItem.class)) != null && PsiTreeUtil.isAncestor((PsiElement)withPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = PyUtil.as(withPart.getParent(), PyWithStatement.class);
            }
            if (forOrWith != null) {
                comment = PyUtil.getCommentOnHeaderLine(forOrWith);
            }
        }
        return comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null ? comment : null;
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyTargetExpressionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withType";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWithItemVariableType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEnterTypeFromPyClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromIteration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIterationType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIteratedItemType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNextMethodCallType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findMethodByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContextSensitiveType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveAssignedValue";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWithItemVariableType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

