/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySuperArgumentsInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.wrong.super.arguments", new Object[0]);
        if (string == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PySuperArgumentsInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PySuperArgumentsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PySuperArgumentsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session2) {
            super(holder, session2);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyExpression[] arguments;
            PyExpression callee = node.getCallee();
            if (callee != null && "super".equals(callee.getName()) && (arguments = node.getArguments()).length == 2 && arguments[0] instanceof PyReferenceExpression && arguments[1] instanceof PyReferenceExpression) {
                PyClass firstClass = this.findClassOf(arguments[0]);
                PyClass secondClass = this.findClassOf(arguments[1]);
                if (firstClass != null && secondClass != null && !secondClass.isSubclass(firstClass, this.myTypeEvalContext)) {
                    this.registerProblem((PsiElement)node.getArgumentList(), PyBundle.message("INSP.$0.is.not.superclass.of.$1", secondClass.getName(), firstClass.getName()));
                }
            }
        }

        @Nullable
        private PyClass findClassOf(PyExpression argument) {
            PyType first_type;
            PsiElement firstElement = ((PyReferenceExpression)argument).followAssignmentsChain(this.getResolveContext()).getElement();
            PyClass firstClass = null;
            if (firstElement instanceof PyClass) {
                firstClass = (PyClass)firstElement;
            } else if (firstElement instanceof PyExpression && (first_type = this.myTypeEvalContext.getType((PyExpression)firstElement)) instanceof PyClassType) {
                firstClass = ((PyClassType)first_type).getPyClass();
            }
            return firstClass;
        }
    }
}

