/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import org.jetbrains.annotations.NotNull;

public class PyConsoleStartFolding
implements ConsoleCommunicationListener,
FoldingListener,
DocumentListener {
    private PythonConsoleView myConsoleView;
    private int myNumberOfCommandExecuted = 0;
    private int myNumberOfCommandToStop = 2;
    private boolean doNotAddFoldingAgain = false;
    private FoldRegion myStartFoldRegion;
    private static final String DEFAULT_FOLDING_MESSAGE = "Python Console";
    private int myStartLineOffset = 0;

    public PyConsoleStartFolding(PythonConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public void setStartLineOffset(int startLineOffset) {
        this.myStartLineOffset = startLineOffset;
    }

    public void setNumberOfCommandToStop(int numberOfCommandToStop) {
        this.myNumberOfCommandToStop = numberOfCommandToStop;
    }

    public void documentChanged(DocumentEvent event) {
        this.addFolding(event);
    }

    private void addFolding(DocumentEvent event) {
        Document document = this.myConsoleView.getEditor().getDocument();
        if (this.doNotAddFoldingAgain || document.getTextLength() == 0) {
            return;
        }
        if (this.myNumberOfCommandExecuted >= this.myNumberOfCommandToStop) {
            document.removeDocumentListener((DocumentListener)this);
            return;
        }
        FoldingModel foldingModel = this.myConsoleView.getEditor().getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            String newFragment;
            int firstLine;
            int start = this.myStartLineOffset;
            int finish = document.getTextLength() - 1;
            String placeholderText = DEFAULT_FOLDING_MESSAGE;
            for (int line = firstLine = document.getLineNumber(this.myStartLineOffset); line < document.getLineCount(); ++line) {
                String lineText = document.getText(DocumentUtil.getLineTextRange(document, line));
                if (lineText.startsWith("Python")) {
                    if (start == this.myStartLineOffset) {
                        start = document.getLineStartOffset(line);
                    }
                    placeholderText = lineText;
                    break;
                }
                if (!lineText.startsWith("PyDev console")) continue;
                start = document.getLineStartOffset(line);
            }
            if ((newFragment = event.getNewFragment().toString()).startsWith("In[") || newFragment.startsWith(">>>")) {
                finish = event.getOffset() - 1;
                this.doNotAddFoldingAgain = true;
            }
            if (this.myStartFoldRegion != null) {
                foldingModel.removeFoldRegion(this.myStartFoldRegion);
            }
            if (start > finish) {
                return;
            }
            FoldRegion foldRegion = foldingModel.addFoldRegion(start, finish, placeholderText);
            if (foldRegion != null) {
                foldRegion.setExpanded(false);
                this.myStartFoldRegion = foldRegion;
            }
        });
    }

    public void commandExecuted(boolean more) {
        ++this.myNumberOfCommandExecuted;
    }

    public void inputRequested() {
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            PyConsoleStartFolding.$$$reportNull$$$0(0);
        }
        if (region.equals(this.myStartFoldRegion) && region.isExpanded()) {
            this.myConsoleView.getEditor().getComponent().updateUI();
            this.doNotAddFoldingAgain = true;
        }
    }

    @Override
    public void onFoldProcessingEnd() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/jetbrains/python/console/PyConsoleStartFolding", "onFoldRegionStateChange"));
    }
}

