/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public class PyConsoleIndentUtil {
    private static final int TAB_INDENT = 4;
    private static final Map<String, String> pythonBrackets = ImmutableMap.of((Object)"(", (Object)")", (Object)"[", (Object)"]", (Object)"{", (Object)"}");

    private PyConsoleIndentUtil() {
    }

    public static String normalize(@NotNull String codeFragment) {
        if (codeFragment == null) {
            PyConsoleIndentUtil.$$$reportNull$$$0(0);
        }
        return PyConsoleIndentUtil.normalize(codeFragment, 0);
    }

    public static String normalize(@NotNull String codeFragment, int addIndent) {
        if (codeFragment == null) {
            PyConsoleIndentUtil.$$$reportNull$$$0(1);
        }
        Scanner s = new Scanner(codeFragment);
        ArrayList lines2 = Lists.newArrayList();
        ArrayList indents = Lists.newArrayList();
        while (s.hasNextLine()) {
            String line = s.nextLine();
            int indent = 0;
            for (char c : line.toCharArray()) {
                if (c == ' ') {
                    ++indent;
                    continue;
                }
                if (c != '\t') break;
                indent += 4;
            }
            if (StringUtil.isEmpty((String)line)) continue;
            lines2.add(line.trim());
            indents.add(indent);
        }
        int[] indentArray = ArrayUtil.toIntArray((Collection)indents);
        PyConsoleIndentUtil.shiftLeftAll(indentArray, lines2);
        int i = 0;
        while (i < indentArray.length) {
            int n = i++;
            indentArray[n] = indentArray[n] + addIndent;
        }
        return PyConsoleIndentUtil.padOutput(lines2, indentArray);
    }

    private static void shiftLeftAll(int[] indentArray, List<String> lines2) {
        if (indentArray.length == 0) {
            return;
        }
        int minpos = PyConsoleIndentUtil.arrayMinPosition(indentArray, indentArray.length);
        if (minpos == 0) {
            int minIndent = indentArray[minpos];
            PyConsoleIndentUtil.shiftTailLeftOnLevel(indentArray, minIndent);
            return;
        }
        int prevMinPosition = indentArray.length;
        while (minpos != 0) {
            PyConsoleIndentUtil.shiftTailLeftOnLevel(indentArray, minpos, prevMinPosition, indentArray[minpos]);
            prevMinPosition = minpos;
            minpos = PyConsoleIndentUtil.arrayMinPosition(indentArray, minpos);
        }
        int minIndent = indentArray[minpos];
        int i = 0;
        while (indentArray[i] != 0) {
            int n = i++;
            indentArray[n] = indentArray[n] - minIndent;
        }
    }

    private static void shiftTailLeftOnLevel(int[] indentArray, int level) {
        PyConsoleIndentUtil.shiftTailLeftOnLevel(indentArray, 0, indentArray.length, level);
    }

    private static void shiftTailLeftOnLevel(int[] indentArray, int upper, int bottom, int level) {
        int i = upper;
        while (i < bottom) {
            if (indentArray[i] < level) {
                throw new IllegalStateException("Current indentation is less then subtracted level.");
            }
            int n = i++;
            indentArray[n] = indentArray[n] - level;
        }
    }

    private static int arrayMinPosition(int[] indentArray, int border) {
        if (border < 1) {
            return -1;
        }
        int minPosition = 0;
        for (int i = 0; i < border; ++i) {
            if (indentArray[minPosition] <= indentArray[i]) continue;
            minPosition = i;
        }
        return minPosition;
    }

    private static String padOutput(List<String> lines2, int[] indentArray) {
        int i = 0;
        StringBuilder result2 = new StringBuilder();
        for (String line : lines2) {
            if (!StringUtil.isEmpty((String)line)) {
                line = Strings.padStart((String)line, (int)(indentArray[i] + line.length()), (char)' ');
            }
            result2.append(line);
            if (++i >= lines2.size()) continue;
            result2.append("\n");
        }
        return result2.toString();
    }

    public static boolean shouldIndent(@NotNull String line) {
        if (line == null) {
            PyConsoleIndentUtil.$$$reportNull$$$0(2);
        }
        line = PyConsoleIndentUtil.stripComments(line);
        return line.endsWith(":");
    }

    private static String stripComments(String line) {
        if (line.contains("#")) {
            line = line.substring(0, line.indexOf("#"));
            line = line.trim();
        }
        return line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/PyConsoleIndentUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "normalize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldIndent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

