/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.base.Function;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeIntention
extends PyBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TypeIntention.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof PyFile) || file2 instanceof PyDocstringFile) {
            return false;
        }
        this.updateText(false);
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        if (this.isAvailableForParameter(project, elementAt)) {
            return true;
        }
        if (this.isAvailableForReturn(elementAt)) {
            this.updateText(true);
            return true;
        }
        return false;
    }

    private boolean isAvailableForParameter(Project project, PsiElement elementAt) {
        ResolveResult[] results;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyLambdaExpression.class) != null) {
            return false;
        }
        PsiReference reference = problemElement.getReference();
        if (reference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)reference).multiResolve(false)).length != 1) {
            return false;
        }
        VirtualFile virtualFile = problemElement.getContainingFile().getVirtualFile();
        if (virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        PsiElement resolved = reference != null ? reference.resolve() : null;
        PyNamedParameter parameter = TypeIntention.getParameter(problemElement, resolved);
        return parameter != null && !this.isParamTypeDefined(parameter);
    }

    @Nullable
    public static PyExpression getProblemElement(@Nullable PsiElement elementAt) {
        PyExpression qualifier;
        PyExpression problemElement = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, (Class[])new Class[]{PyNamedParameter.class, PyReferenceExpression.class});
        if (problemElement == null) {
            return null;
        }
        if (problemElement instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)problemElement).getQualifier()) != null && !qualifier.getText().equals("self")) {
            problemElement = qualifier;
        }
        return problemElement;
    }

    protected abstract void updateText(boolean var1);

    protected boolean isParamTypeDefined(PyParameter parameter) {
        return false;
    }

    @Nullable
    protected static PyNamedParameter getParameter(PyExpression problemElement, PsiElement resolved) {
        PyNamedParameter parameter = PyUtil.as(problemElement, PyNamedParameter.class);
        if (resolved instanceof PyNamedParameter) {
            parameter = (PyNamedParameter)resolved;
        }
        return parameter == null || parameter.isSelf() ? null : parameter;
    }

    private boolean isAvailableForReturn(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(1);
        }
        return TypeIntention.resolvesToFunction(elementAt, (Function<PyFunction, Boolean>)((Function)input -> !this.isReturnTypeDefined((PyFunction)input)));
    }

    static boolean resolvesToFunction(@NotNull PsiElement elementAt, Function<PyFunction, Boolean> isAvailableForFunction) {
        PyCallExpression callExpression;
        ASTNode nameNode;
        PyFunction parentFunction;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(2);
        }
        if ((parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class)) != null && (nameNode = parentFunction.getNameNode()) != null) {
            PsiElement prev = elementAt.getContainingFile().findElementAt(elementAt.getTextOffset() - 1);
            if (nameNode.getPsi() == elementAt || nameNode.getPsi() == prev) {
                return (Boolean)isAvailableForFunction.apply((Object)parentFunction);
            }
        }
        if ((callExpression = TypeIntention.getCallExpression(elementAt)) == null) {
            return false;
        }
        PyExpression callee = callExpression.getCallee();
        if (callee == null) {
            return false;
        }
        PsiReference reference = callee.getReference();
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            for (int i = 0; i < results.length; ++i) {
                if (!(results[i].getElement() instanceof PyFunction)) continue;
                PsiElement result2 = results[i].getElement();
                PsiFile psiFile = result2.getContainingFile();
                if (psiFile == null) {
                    return false;
                }
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null && ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
                    return false;
                }
                return (Boolean)isAvailableForFunction.apply((Object)((PyFunction)result2));
            }
        }
        return false;
    }

    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            TypeIntention.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Nullable
    static PyCallExpression getCallExpression(PsiElement elementAt) {
        PyExpression assignedValue;
        PyAssignmentStatement assignmentStatement;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement != null) {
            PyExpression assignedValue2;
            PyResolveContext context;
            PsiElement resolved;
            PsiReference reference = problemElement.getReference();
            PsiElement psiElement = resolved = reference != null ? reference.resolve() : null;
            if (resolved instanceof PyTargetExpression && (context = TypeIntention.getResolveContext(elementAt)).getTypeEvalContext().maySwitchToAST(resolved) && (assignedValue2 = ((PyTargetExpression)resolved).findAssignedValue()) instanceof PyCallExpression) {
                return (PyCallExpression)assignedValue2;
            }
        }
        if ((assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyAssignmentStatement.class)) != null && (assignedValue = assignmentStatement.getAssignedValue()) instanceof PyCallExpression) {
            return (PyCallExpression)assignedValue;
        }
        return (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyCallExpression.class, (boolean)false);
    }

    @NotNull
    static List<PyCallable> getMultiCallable(@Nullable PsiElement elementAt) {
        List<PyCallable> callables;
        PyCallExpression call = TypeIntention.getCallExpression(elementAt);
        if (call != null && elementAt != null && !(callables = call.multiResolveCalleeFunction(TypeIntention.getResolveContext(elementAt))).isEmpty()) {
            List<PyCallable> list2 = callables;
            if (list2 == null) {
                TypeIntention.$$$reportNull$$$0(4);
            }
            return list2;
        }
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        if (parentFunction != null) {
            List<PyCallable> list3 = Collections.singletonList(parentFunction);
            if (list3 == null) {
                TypeIntention.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<PyCallable> list4 = Collections.emptyList();
        if (list4 == null) {
            TypeIntention.$$$reportNull$$$0(6);
        }
        return list4;
    }

    protected static PyResolveContext getResolveContext(@NotNull PsiElement origin) {
        if (origin == null) {
            TypeIntention.$$$reportNull$$$0(7);
        }
        return PyResolveContext.defaultContext().withTypeEvalContext(TypeEvalContext.codeAnalysis(origin.getProject(), origin.getContainingFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCallable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForReturn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolveContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

