/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInjectionUtil {
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = Arrays.asList(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class, PsiComment.class);

    private PyInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@NotNull PsiElement context) {
        if (context == null) {
            PyInjectionUtil.$$$reportNull$$$0(0);
        }
        PsiElement element = null;
        for (PsiElement current = context; current != null && PyInjectionUtil.isStringLiteralPart(current, element); current = current.getParent()) {
            element = current;
        }
        return element;
    }

    @NotNull
    public static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar) {
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(1);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(2);
        }
        InjectionResult injectionResult = PyInjectionUtil.processStringLiteral(element, registrar, "", "", Formatting.NONE);
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(3);
        }
        return injectionResult;
    }

    private static boolean isStringLiteralPart(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(4);
        }
        if (element == context || element instanceof PyStringLiteralExpression || element instanceof PsiComment) {
            return true;
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            return contained != null && PyInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            if (expr.isOperator("+")) {
                return PyInjectionUtil.isStringLiteralPart((PsiElement)left, context) || right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, context);
            }
            if (expr.isOperator("%")) {
                return right != context && PyInjectionUtil.isStringLiteralPart((PsiElement)left, context);
            }
            return false;
        }
        if (element instanceof PyCallExpression) {
            PyExpression qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element);
            return qualifier != null && PyInjectionUtil.isStringLiteralPart((PsiElement)qualifier, context);
        }
        if (element instanceof PyReferenceExpression) {
            PyCallExpression callExpr = PyCallExpressionNavigator.getPyCallExpressionByCallee(element);
            return callExpr != null && PyInjectionUtil.isStringLiteralPart((PsiElement)callExpr, context);
        }
        return false;
    }

    @Nullable
    private static PyExpression getFormatCallQualifier(@NotNull PyCallExpression element) {
        PyQualifiedExpression qualifiedExpr;
        PyExpression qualifier;
        PyExpression callee;
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(5);
        }
        if ((callee = element.getCallee()) instanceof PyQualifiedExpression && (qualifier = (qualifiedExpr = (PyQualifiedExpression)callee).getQualifier()) != null && "format".equals(qualifiedExpr.getReferencedName())) {
            return qualifier;
        }
        return null;
    }

    @NotNull
    private static InjectionResult processStringLiteral(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, @NotNull String prefix, @NotNull String suffix, @NotNull Formatting formatting) {
        PyExpression qualifier;
        if (element == null) {
            PyInjectionUtil.$$$reportNull$$$0(6);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            PyInjectionUtil.$$$reportNull$$$0(8);
        }
        if (suffix == null) {
            PyInjectionUtil.$$$reportNull$$$0(9);
        }
        if (formatting == null) {
            PyInjectionUtil.$$$reportNull$$$0(10);
        }
        String missingValue = "missing_value";
        if (element instanceof PyStringLiteralExpression) {
            boolean injected = false;
            boolean strict = true;
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
            List<TextRange> ranges = expr.getStringValueTextRanges();
            String text = expr.getText();
            for (TextRange range : ranges) {
                if (formatting != Formatting.NONE) {
                    List<PyStringFormatParser.FormatStringChunk> chunks;
                    String part = range.substring(text);
                    List<PyStringFormatParser.FormatStringChunk> list2 = chunks = formatting == Formatting.NEW_STYLE ? PyStringFormatParser.parseNewStyleFormat(part) : PyStringFormatParser.parsePercentFormat(part);
                    if (!PyStringFormatParser.filterSubstitutions(chunks).isEmpty()) {
                        strict = false;
                    }
                    for (int i = 0; i < chunks.size(); ++i) {
                        PyStringFormatParser.FormatStringChunk chunk = chunks.get(i);
                        if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                        int nextIndex = i + 1;
                        String chunkPrefix = i == 1 && chunks.get(0) instanceof PyStringFormatParser.SubstitutionChunk ? "missing_value" : (i == 0 ? prefix : "");
                        String chunkSuffix = nextIndex < chunks.size() && chunks.get(nextIndex) instanceof PyStringFormatParser.SubstitutionChunk ? "missing_value" : (nextIndex == chunks.size() ? suffix : "");
                        TextRange chunkRange = chunk.getTextRange().shiftRight(range.getStartOffset());
                        registrar.addPlace(chunkPrefix, chunkSuffix, (PsiLanguageInjectionHost)expr, chunkRange);
                        injected = true;
                    }
                    continue;
                }
                registrar.addPlace(prefix, suffix, (PsiLanguageInjectionHost)expr, range);
                injected = true;
            }
            InjectionResult injectionResult = new InjectionResult(injected, strict);
            if (injectionResult == null) {
                PyInjectionUtil.$$$reportNull$$$0(11);
            }
            return injectionResult;
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            if (contained != null) {
                InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)contained, registrar, prefix, suffix, formatting);
                if (injectionResult == null) {
                    PyInjectionUtil.$$$reportNull$$$0(12);
                }
                return injectionResult;
            }
        } else if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            boolean isLeftString = PyInjectionUtil.isStringLiteralPart((PsiElement)left, null);
            if (expr.isOperator("+")) {
                boolean isRightString = right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, null);
                InjectionResult result2 = InjectionResult.EMPTY;
                if (isLeftString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, isRightString ? "" : "missing_value", formatting));
                }
                if (isRightString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)right, registrar, isLeftString ? "" : "missing_value", suffix, formatting));
                }
                InjectionResult injectionResult = result2;
                if (injectionResult == null) {
                    PyInjectionUtil.$$$reportNull$$$0(13);
                }
                return injectionResult;
            }
            if (expr.isOperator("%")) {
                InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, suffix, Formatting.PERCENT);
                if (injectionResult == null) {
                    PyInjectionUtil.$$$reportNull$$$0(14);
                }
                return injectionResult;
            }
        } else if (element instanceof PyCallExpression && (qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element)) != null) {
            InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)qualifier, registrar, prefix, suffix, Formatting.NEW_STYLE);
            if (injectionResult == null) {
                PyInjectionUtil.$$$reportNull$$$0(15);
            }
            return injectionResult;
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(16);
        }
        return injectionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStringLiteralInjection";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLargestStringLiteral";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjection";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralPart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatCallQualifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processStringLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Formatting {
        NONE,
        PERCENT,
        NEW_STYLE;

    }

    public static class InjectionResult {
        public static InjectionResult EMPTY = new InjectionResult(false, true);
        private final boolean myInjected;
        private final boolean myStrict;

        public InjectionResult(boolean injected, boolean strict) {
            this.myInjected = injected;
            this.myStrict = strict;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public InjectionResult append(@NotNull InjectionResult result2) {
            if (result2 == null) {
                InjectionResult.$$$reportNull$$$0(0);
            }
            return new InjectionResult(this.myInjected || result2.isInjected(), this.myStrict && result2.isStrict());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult", "append"));
        }
    }
}

