/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final JsonSchemaObject mySchema;
    private final boolean myIsName;
    @NotNull
    private final List<JsonSchemaVariantsTreeBuilder.Step> myPosition;

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema, boolean isName, @NotNull List<JsonSchemaVariantsTreeBuilder.Step> position) {
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(0);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(1);
        }
        this.mySchema = schema;
        this.myIsName = isName;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(2);
        }
        this.mySchema = schema;
        this.myIsName = true;
        this.myPosition = Collections.emptyList();
    }

    public MatchResult detailedResolve() {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.mySchema, this.myPosition, false, false, !this.myIsName);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        MatchResult result2 = this.detailedResolve();
        ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>(result2.mySchemas);
        list2.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        ArrayList<JsonSchemaObject> arrayList = list2;
        if (arrayList == null) {
            JsonSchemaResolver.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement findNavigationTarget(boolean literalResolve, @Nullable JsonValue element, boolean acceptAdditionalPropertiesSchema) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.mySchema, this.myPosition, true, literalResolve, acceptAdditionalPropertiesSchema || !this.myIsName);
        return JsonSchemaResolver.getSchemaNavigationItem(JsonSchemaResolver.selectSchema(node, element, this.myPosition.isEmpty()));
    }

    @Nullable
    private static JsonSchemaObject selectSchema(@NotNull JsonSchemaTreeNode resolveRoot, @Nullable JsonValue element, boolean topLevelSchema) {
        JsonValueAdapter parentAdapter;
        JsonValueAdapter adapter;
        if (resolveRoot == null) {
            JsonSchemaResolver.$$$reportNull$$$0(4);
        }
        MatchResult matchResult = MatchResult.create(resolveRoot);
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(matchResult.mySchemas);
        schemas.addAll(matchResult.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        JsonSchemaObject firstSchema = JsonSchemaResolver.getFirstValidSchema(schemas);
        if (element == null || schemas.size() == 1 || firstSchema == null) {
            return firstSchema;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, firstSchema);
        if (walker == null || (adapter = walker.createValueAdapter(element)) == null) {
            return null;
        }
        if (topLevelSchema) {
            parentAdapter = null;
        } else {
            JsonValue parentValue = (JsonValue)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class), (Class[])new Class[]{JsonObject.class, JsonArray.class});
            if (parentValue == null || (parentAdapter = walker.createValueAdapter(parentValue)) == null) {
                return null;
            }
        }
        Ref schemaRef = new Ref();
        MatchResult.iterateTree(resolveRoot, (Processor<JsonSchemaTreeNode>)((Processor)node -> {
            JsonSchemaTreeNode parent = node.getParent();
            if (node.getSchema() == null || parentAdapter != null && parent != null && parent.isNothing()) {
                return true;
            }
            if (!JsonSchemaResolver.isCorrect(adapter, node.getSchema())) {
                return true;
            }
            if (parentAdapter == null || parent == null || parent.getSchema() == null || parent.isAny() || JsonSchemaResolver.isCorrect(parentAdapter, parent.getSchema())) {
                schemaRef.set((Object)node.getSchema());
                return false;
            }
            return true;
        }));
        return (JsonSchemaObject)schemaRef.get();
    }

    @Nullable
    private static JsonSchemaObject getFirstValidSchema(List<JsonSchemaObject> schemas) {
        return schemas.stream().filter(schema -> schema.getJsonObject().isValid()).findFirst().orElse(null);
    }

    private static boolean isCorrect(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        if (value == null) {
            JsonSchemaResolver.$$$reportNull$$$0(5);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(6);
        }
        if (!schema.getJsonObject().isValid()) {
            return false;
        }
        JsonSchemaType type = JsonSchemaType.getType(value);
        if (type == null) {
            return true;
        }
        if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema, type)) {
            return false;
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
        checker.checkByScheme(value, schema);
        return checker.isCorrect();
    }

    @Nullable
    private static JsonValue getSchemaNavigationItem(@Nullable JsonSchemaObject schema) {
        if (schema == null) {
            return null;
        }
        JsonObject jsonObject = schema.getJsonObject();
        if (jsonObject.getParent() instanceof JsonProperty) {
            return ((JsonProperty)jsonObject.getParent()).getNameElement();
        }
        return jsonObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectSchema";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

