/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogUiPropertiesImpl
implements PersistentStateComponent<State>,
MainVcsLogUiProperties {
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    private static final Set<VcsLogUiProperties.VcsLogUiProperty> SUPPORTED_PROPERTIES = ContainerUtil.newHashSet((Object[])new VcsLogUiProperties.VcsLogUiProperty[]{CommonUiProperties.SHOW_DETAILS, MainVcsLogUiProperties.SHOW_LONG_EDGES, MainVcsLogUiProperties.BEK_SORT_TYPE, MainVcsLogUiProperties.SHOW_ROOT_NAMES, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, MainVcsLogUiProperties.TEXT_FILTER_REGEX, CommonUiProperties.COLUMN_ORDER});
    private final Set<VcsLogUiProperties.PropertiesChangeListener> myListeners;
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;

    public VcsLogUiPropertiesImpl(@NotNull VcsLogApplicationSettings appSettings) {
        if (appSettings == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.newLinkedHashSet();
        this.myAppSettings = appSettings;
    }

    @NotNull
    public abstract State getState();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(1);
        }
        if (this.myAppSettings.exists(property)) {
            T t = this.myAppSettings.get(property);
            if (t == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(2);
            }
            return t;
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            Boolean bl = this.getState().SHOW_DETAILS_IN_CHANGES;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(3);
            }
            return (T)bl;
        }
        if (SHOW_LONG_EDGES.equals(property)) {
            Boolean bl = this.getState().LONG_EDGES_VISIBLE;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(4);
            }
            return (T)bl;
        }
        if (SHOW_ROOT_NAMES.equals(property)) {
            Boolean bl = this.getState().SHOW_ROOT_NAMES;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(5);
            }
            return (T)bl;
        }
        if (BEK_SORT_TYPE.equals(property)) {
            PermanentGraph.SortType sortType = PermanentGraph.SortType.values()[this.getState().BEK_SORT_TYPE];
            if (sortType == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(6);
            }
            return (T)sortType;
        }
        if (TEXT_FILTER_MATCH_CASE.equals(property)) {
            Boolean bl = this.getTextFilterSettings().MATCH_CASE;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(7);
            }
            return (T)bl;
        }
        if (TEXT_FILTER_REGEX.equals(property)) {
            Boolean bl = this.getTextFilterSettings().REGEX;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(8);
            }
            return (T)bl;
        }
        if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            ArrayList order = this.getState().COLUMN_ORDER;
            if (order == null) {
                order = ContainerUtil.newArrayList();
            }
            ArrayList arrayList = order;
            if (arrayList == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(9);
            }
            return (T)arrayList;
        }
        if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Boolean result2 = this.getState().HIGHLIGHTERS.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId());
            if (result2 == null) {
                Boolean bl = Boolean.TRUE;
                if (bl == null) {
                    VcsLogUiPropertiesImpl.$$$reportNull$$$0(10);
                }
                return (T)bl;
            }
            Boolean bl = result2;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(11);
            }
            return (T)bl;
        }
        if (property instanceof CommonUiProperties.TableColumnProperty) {
            Integer savedWidth = this.getState().COLUMN_WIDTH.get(((CommonUiProperties.TableColumnProperty)property).getColumn());
            if (savedWidth == null) {
                Integer n = -1;
                if (n == null) {
                    VcsLogUiPropertiesImpl.$$$reportNull$$$0(12);
                }
                return (T)n;
            }
            Integer n = savedWidth;
            if (n == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(13);
            }
            return (T)n;
        }
        throw new UnsupportedOperationException("Property " + property + " does not exist");
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value) {
        if (property == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(14);
        }
        if (value == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(15);
        }
        if (this.myAppSettings.exists(property)) {
            this.myAppSettings.set(property, value);
            return;
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            this.getState().SHOW_DETAILS_IN_CHANGES = (Boolean)value;
        } else if (SHOW_LONG_EDGES.equals(property)) {
            this.getState().LONG_EDGES_VISIBLE = (Boolean)value;
        } else if (SHOW_ROOT_NAMES.equals(property)) {
            this.getState().SHOW_ROOT_NAMES = (Boolean)value;
        } else if (BEK_SORT_TYPE.equals(property)) {
            this.getState().BEK_SORT_TYPE = ((PermanentGraph.SortType)value).ordinal();
        } else if (TEXT_FILTER_REGEX.equals(property)) {
            this.getTextFilterSettings().REGEX = (Boolean)value;
        } else if (TEXT_FILTER_MATCH_CASE.equals(property)) {
            this.getTextFilterSettings().MATCH_CASE = (Boolean)value;
        } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            this.getState().COLUMN_ORDER = (List)value;
        } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            this.getState().HIGHLIGHTERS.put(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId(), (Boolean)value);
        } else if (property instanceof CommonUiProperties.TableColumnProperty) {
            this.getState().COLUMN_WIDTH.put(((CommonUiProperties.TableColumnProperty)property).getColumn(), (Integer)value);
        } else {
            throw new UnsupportedOperationException("Property " + property + " does not exist");
        }
        this.myListeners.forEach(l -> {
            if (property == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(29);
            }
            l.onPropertyChanged(property);
        });
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(16);
        }
        return this.myAppSettings.exists(property) || SUPPORTED_PROPERTIES.contains(property) || property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty || property instanceof CommonUiProperties.TableColumnProperty;
    }

    @NotNull
    private TextFilterSettings getTextFilterSettings() {
        TextFilterSettings settings = this.getState().TEXT_FILTER_SETTINGS;
        if (settings == null) {
            this.getState().TEXT_FILTER_SETTINGS = settings = new TextFilterSettings();
        }
        TextFilterSettings textFilterSettings = settings;
        if (textFilterSettings == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(17);
        }
        return textFilterSettings;
    }

    @Override
    public void addRecentlyFilteredUserGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(18);
        }
        VcsLogUiPropertiesImpl.addRecentGroup(usersInGroup, this.getState().RECENTLY_FILTERED_USER_GROUPS);
    }

    @Override
    public void addRecentlyFilteredBranchGroup(@NotNull List<String> valuesInGroup) {
        if (valuesInGroup == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(19);
        }
        VcsLogUiPropertiesImpl.addRecentGroup(valuesInGroup, this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
    }

    private static void addRecentGroup(@NotNull List<String> valuesInGroup, @NotNull Deque<UserGroup> stateField) {
        if (valuesInGroup == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(20);
        }
        if (stateField == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(21);
        }
        UserGroup group = new UserGroup();
        group.users = valuesInGroup;
        if (stateField.contains(group)) {
            return;
        }
        stateField.addFirst(group);
        if (stateField.size() > 10) {
            stateField.removeLast();
        }
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredUserGroups() {
        List<List<String>> list2 = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_USER_GROUPS);
        if (list2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredBranchGroups() {
        List<List<String>> list2 = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
        if (list2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    private static List<List<String>> getRecentGroup(Deque<UserGroup> stateField) {
        List list2 = ContainerUtil.map2List(stateField, group -> group.users);
        if (list2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @Override
    public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
        if (filterName == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(25);
        }
        if (values != null) {
            this.getState().FILTERS.put(filterName, values);
        } else {
            this.getState().FILTERS.remove(filterName);
        }
    }

    @Override
    @Nullable
    public List<String> getFilterValues(@NotNull String filterName) {
        if (filterName == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(26);
        }
        return this.getState().FILTERS.get(filterName);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(27);
        }
        this.myListeners.add(listener2);
        this.myAppSettings.addChangeListener(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(28);
        }
        this.myListeners.remove(listener2);
        this.myAppSettings.removeChangeListener(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appSettings";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usersInGroup";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesInGroup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateField";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterName";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterSettings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentlyFilteredUserGroups";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentlyFilteredBranchGroups";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addRecentlyFilteredUserGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRecentlyFilteredBranchGroup";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addRecentGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "saveFilterValues";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilterValues";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$set$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class MainVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        public abstract void onShowDetailsChanged();

        public abstract void onShowLongEdgesChanged();

        public abstract void onBekChanged();

        public abstract void onShowRootNamesChanged();

        public abstract void onCompactReferencesViewChanged();

        public abstract void onShowTagNamesChanged();

        public abstract void onTextFilterSettingsChanged();

        public abstract void onHighlighterChanged();

        public abstract void onColumnWidthChanged(int var1);

        public abstract void onColumnOrderChanged();

        public abstract void onShowChangesFromParentsChanged();

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MainVcsLogUiPropertiesListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                this.onShowDetailsChanged();
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (MainVcsLogUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                this.onShowRootNamesChanged();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                this.onCompactReferencesViewChanged();
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                this.onShowTagNamesChanged();
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                this.onBekChanged();
            } else if (MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property)) {
                this.onTextFilterSettingsChanged();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                this.onColumnOrderChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                this.onHighlighterChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                this.onColumnWidthChanged(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property)) {
                this.onShowChangesFromParentsChanged();
            } else {
                throw new UnsupportedOperationException("Property " + property + " does not exist");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$MainVcsLogUiPropertiesListener", "onPropertyChanged"));
        }
    }

    private static class TextFilterSettings {
        public boolean REGEX = false;
        public boolean MATCH_CASE = false;

        private TextFilterSettings() {
        }
    }

    public static class UserGroup {
        public List<String> users = new ArrayList<String>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserGroup group = (UserGroup)o;
            return this.users.equals(group.users);
        }

        public int hashCode() {
            return this.users.hashCode();
        }
    }

    public static class State {
        public boolean SHOW_DETAILS_IN_CHANGES = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public Deque<UserGroup> RECENTLY_FILTERED_USER_GROUPS = new ArrayDeque<UserGroup>();
        public Deque<UserGroup> RECENTLY_FILTERED_BRANCH_GROUPS = new ArrayDeque<UserGroup>();
        public Map<String, Boolean> HIGHLIGHTERS = ContainerUtil.newTreeMap();
        public Map<String, List<String>> FILTERS = ContainerUtil.newTreeMap();
        @Deprecated
        public boolean COMPACT_REFERENCES_VIEW = true;
        @Deprecated
        public boolean SHOW_TAG_NAMES = false;
        public TextFilterSettings TEXT_FILTER_SETTINGS = new TextFilterSettings();
        public Map<Integer, Integer> COLUMN_WIDTH = ContainerUtil.newHashMap();
        public List<Integer> COLUMN_ORDER = ContainerUtil.newArrayList();
    }
}

