/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomFileElementNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import com.intellij.util.xml.tree.actions.BaseDomTreeAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DeleteDomElement
extends BaseDomTreeAction {
    public DeleteDomElement() {
    }

    public DeleteDomElement(DomModelTreeView treeView) {
        super(treeView);
    }

    @Override
    public void actionPerformed(AnActionEvent e, DomModelTreeView treeView) {
        SimpleNode selectedNode = treeView.getTree().getSelectedNode();
        if (selectedNode instanceof BaseDomElementNode) {
            if (selectedNode instanceof DomFileElementNode) {
                e.getPresentation().setVisible(false);
                return;
            }
            final DomElement domElement = ((BaseDomElementNode)selectedNode).getDomElement();
            int ret = Messages.showOkCancelDialog((String)(DeleteDomElement.getPresentationText(selectedNode, "Remove") + "?"), (String)"Remove", (Icon)Messages.getQuestionIcon());
            if (ret == 0) {
                new WriteCommandAction(domElement.getManager().getProject(), new PsiFile[]{DomUtil.getFile((DomElement)domElement)}){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        domElement.undefine();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/xml/tree/actions/DeleteDomElement$1", "run"));
                    }
                }.execute();
            }
        }
    }

    @Override
    public void update(AnActionEvent e, DomModelTreeView treeView) {
        DomElement domElement;
        SimpleNode selectedNode = treeView.getTree().getSelectedNode();
        if (selectedNode instanceof DomFileElementNode) {
            e.getPresentation().setVisible(false);
            return;
        }
        boolean enabled = false;
        if (selectedNode instanceof BaseDomElementNode && (domElement = ((BaseDomElementNode)selectedNode).getDomElement()).isValid() && DomUtil.hasXml((DomElement)domElement) && !(domElement.getParent() instanceof DomFileElement)) {
            enabled = true;
        }
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DeleteDomElement.getPresentationText(selectedNode, ApplicationBundle.message((String)"action.remove", (Object[])new Object[0])));
        } else {
            e.getPresentation().setText(ApplicationBundle.message((String)"action.remove", (Object[])new Object[0]));
        }
        e.getPresentation().setIcon(AllIcons.General.Remove);
    }

    private static String getPresentationText(SimpleNode selectedNode, String removeString) {
        ElementPresentation presentation = ((BaseDomElementNode)selectedNode).getDomElement().getPresentation();
        removeString = removeString + " " + presentation.getTypeName() + (presentation.getElementName() == null || presentation.getElementName().trim().length() == 0 ? "" : ": " + presentation.getElementName());
        return removeString;
    }
}

