/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import org.jetbrains.annotations.NotNull;

public class FrameState {
    private Rectangle myBounds;
    private boolean myMaximized;
    private boolean myFullScreen;

    public Point getLocation() {
        return this.myBounds == null ? null : this.myBounds.getLocation();
    }

    public Dimension getSize() {
        return this.myBounds == null ? null : this.myBounds.getSize();
    }

    public Rectangle getBounds() {
        return this.myBounds == null ? null : new Rectangle(this.myBounds);
    }

    public boolean isMaximized() {
        return this.myMaximized;
    }

    public boolean isFullScreen() {
        return this.myFullScreen;
    }

    public static int getExtendedState(Component component) {
        int state2 = 0;
        if (component instanceof Frame) {
            ComponentPeer peer;
            state2 = ((Frame)component).getExtendedState();
            if (SystemInfo.isMacOSLion && (peer = component.getPeer()) instanceof FramePeer) {
                state2 = ((FramePeer)peer).getState();
            }
        }
        return state2;
    }

    public static boolean isFullScreen(Component component) {
        return component instanceof IdeFrameEx && WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && ((IdeFrameEx)((Object)component)).isInFullScreen();
    }

    public static boolean isMaximized(int state2) {
        return (state2 & 6) == 6;
    }

    private static FrameState findFrameState(@NotNull Component component) {
        if (component == null) {
            FrameState.$$$reportNull$$$0(0);
        }
        for (ComponentListener listener2 : component.getComponentListeners()) {
            if (!(listener2 instanceof FrameState)) continue;
            return (FrameState)((Object)listener2);
        }
        return null;
    }

    public static FrameState getFrameState(@NotNull Component component) {
        FrameState state2;
        if (component == null) {
            FrameState.$$$reportNull$$$0(1);
        }
        if ((state2 = FrameState.findFrameState(component)) == null) {
            state2 = new FrameState();
        }
        if (state2.myBounds == null) {
            state2.update(component);
        }
        return state2;
    }

    public static void setFrameStateListener(@NotNull Component component) {
        FrameState state2;
        if (component == null) {
            FrameState.$$$reportNull$$$0(2);
        }
        if (component instanceof Frame && (state2 = FrameState.findFrameState(component)) == null) {
            component.addComponentListener(new Listener());
        }
    }

    final void update(Component component) {
        Rectangle bounds = component.getBounds();
        this.myFullScreen = FrameState.isFullScreen(component);
        this.myMaximized = FrameState.isMaximized(FrameState.getExtendedState(component));
        if (this.myBounds != null && (this.myFullScreen || this.myMaximized) && bounds.contains(this.myBounds.x + this.myBounds.width / 2, this.myBounds.y + this.myBounds.height / 2)) {
            return;
        }
        this.myBounds = bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/ui/FrameState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFrameState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFrameStateListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Listener
    extends FrameState
    implements ComponentListener {
        private Listener() {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }
    }
}

