/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.ServerRuntimeException;

public class AgentTaskExecutor
implements CloudAgentErrorHandler {
    private String myErrorMessage;

    public void onError(String message) {
        this.myErrorMessage = message;
    }

    private void clear() {
        this.myErrorMessage = null;
    }

    public <T> T execute(Computable<T> task2) throws ServerRuntimeException {
        this.clear();
        Object result2 = task2.compute();
        if (this.myErrorMessage == null) {
            return (T)result2;
        }
        throw new ServerRuntimeException(this.myErrorMessage);
    }

    public <T> void execute(Computable<T> task2, CallbackWrapper<T> callback) {
        this.clear();
        Object result2 = task2.compute();
        if (this.myErrorMessage == null) {
            callback.onSuccess(result2);
        } else {
            callback.onError(this.myErrorMessage);
        }
    }
}

