/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.clientLibrary;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteServerClientLibraries", storages={@Storage(value="remote-server-client-libraries.xml")})
public class ClientLibraryManagerImpl
extends ClientLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ClientLibraryManagerImpl.class);
    private Map<String, List<File>> myFiles = new LinkedHashMap<String, List<File>>();
    private EventDispatcher<ClientLibraryManager.CloudClientLibraryManagerListener> myEventDispatcher = EventDispatcher.create(ClientLibraryManager.CloudClientLibraryManagerListener.class);

    public void addListener(@NotNull ClientLibraryManager.CloudClientLibraryManagerListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, disposable);
    }

    public State getState() {
        State result2 = new State();
        for (Map.Entry<String, List<File>> entry : this.myFiles.entrySet()) {
            DownloadedLibraryState libraryState = new DownloadedLibraryState();
            libraryState.myId = entry.getKey();
            for (File file2 : entry.getValue()) {
                libraryState.myPaths.add(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
            }
            result2.myLibraries.add(libraryState);
        }
        return result2;
    }

    public void loadState(State state2) {
        this.myFiles = new HashMap<String, List<File>>();
        for (DownloadedLibraryState libraryState : state2.myLibraries) {
            ArrayList<File> files = new ArrayList<File>();
            for (String path : libraryState.myPaths) {
                files.add(new File(path));
            }
            this.myFiles.put(libraryState.myId, files);
        }
    }

    public boolean isDownloaded(@NotNull ClientLibraryDescription description) {
        if (description == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(2);
        }
        return !this.getExistentFiles(description).isEmpty();
    }

    @NotNull
    private List<File> getExistentFiles(ClientLibraryDescription description) {
        List<File> files = this.myFiles.get(description.getId());
        if (files == null) {
            List<File> list2 = Collections.emptyList();
            if (list2 == null) {
                ClientLibraryManagerImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<File> existentFiles = new ArrayList<File>();
        for (File file2 : files) {
            if (!file2.exists()) continue;
            existentFiles.add(file2);
        }
        ArrayList<File> arrayList = existentFiles;
        if (arrayList == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void checkConfiguration(@NotNull ClientLibraryDescription description, @Nullable Project project, @Nullable JComponent component) throws RuntimeConfigurationError {
        if (description == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(5);
        }
        if (!this.isDownloaded(description)) {
            throw new RuntimeConfigurationError("Client libraries were not downloaded", () -> {
                if (description == null) {
                    ClientLibraryManagerImpl.$$$reportNull$$$0(13);
                }
                this.download(description, project, component);
            });
        }
    }

    private static File getStoreDirectory(ClientLibraryDescription description) {
        return new File(PathManager.getSystemPath(), "remote-server-libraries/" + description.getId());
    }

    @NotNull
    public List<File> getLibraries(@NotNull ClientLibraryDescription description) {
        File[] files;
        if (description == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(6);
        }
        List<Object> list2 = (files = ClientLibraryManagerImpl.getStoreDirectory(description).listFiles()) == null ? Collections.emptyList() : Arrays.asList(files);
        if (list2 == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void download(@NotNull ClientLibraryDescription libraryDescription, @Nullable Project project, @Nullable JComponent component) {
        if (libraryDescription == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(8);
        }
        Ref exc = Ref.create(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (libraryDescription == null) {
                ClientLibraryManagerImpl.$$$reportNull$$$0(12);
            }
            try {
                this.download(libraryDescription);
            }
            catch (IOException e) {
                exc.set((Object)e);
            }
        }, "Downloading Client Libraries", false, project, component);
        if (exc.isNull()) {
            ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        } else {
            LOG.info((Throwable)exc.get());
        }
    }

    @NotNull
    public List<File> download(@NotNull ClientLibraryDescription libraryDescription) throws IOException {
        List<File> existentFiles;
        if (libraryDescription == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(9);
        }
        if (!(existentFiles = this.getExistentFiles(libraryDescription)).isEmpty()) {
            List<File> list2 = existentFiles;
            if (list2 == null) {
                ClientLibraryManagerImpl.$$$reportNull$$$0(10);
            }
            return list2;
        }
        DownloadableFileService downloadService = DownloadableFileService.getInstance();
        URL versionsUrl = libraryDescription.getDescriptionUrl();
        DownloadableFileSetVersions versions = downloadService.createFileSetVersions(null, new URL[]{versionsUrl});
        List descriptions = versions.fetchVersions();
        if (descriptions.isEmpty()) {
            throw new IOException("No client library versions loaded");
        }
        FileDownloader downloader = downloadService.createDownloader((DownloadableFileSetDescription)descriptions.get(0));
        List downloaded = downloader.download(ClientLibraryManagerImpl.getStoreDirectory(libraryDescription));
        List<File> files = this.myFiles.get(libraryDescription.getId());
        if (files == null) {
            files = new ArrayList<File>();
            this.myFiles.put(libraryDescription.getId(), files);
        }
        for (Pair pair : downloaded) {
            files.add((File)pair.getFirst());
        }
        ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        List<File> list3 = files;
        if (list3 == null) {
            ClientLibraryManagerImpl.$$$reportNull$$$0(11);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistentFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDownloaded";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$download$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkConfiguration$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<DownloadedLibraryState> myLibraries = new ArrayList<DownloadedLibraryState>();
    }

    @Tag(value="client-library")
    public static class DownloadedLibraryState {
        @Attribute(value="id")
        public String myId;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="file", elementValueAttribute="path")
        public List<String> myPaths = new ArrayList<String>();
    }
}

