/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import org.jetbrains.annotations.NotNull;

public class MemberInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @Override
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file2) {
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        if (nameSuggestionContext == null && editor.getCaretModel().getOffset() > 0) {
            nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        if (element == null && LookupManager.getActiveLookup(editor) != null) {
            element = PsiTreeUtil.getParentOfType((PsiElement)nameSuggestionContext, PsiNamedElement.class);
        }
        RefactoringSupportProvider supportProvider = element == null ? null : (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage());
        return editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider != null && supportProvider.isMemberInplaceRenameAvailable(element, nameSuggestionContext);
    }

    @Override
    public InplaceRefactoring doRename(final @NotNull PsiElement elementToRename, final Editor editor, final DataContext dataContext) {
        RenamePsiElementProcessor processor2;
        if (elementToRename == null) {
            MemberInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (elementToRename instanceof PsiNameIdentifierOwner && (processor2 = RenamePsiElementProcessor.forElement(elementToRename)).isInplaceRenameSupported()) {
            TemplateState templateState;
            StartMarkAction startMarkAction = StartMarkAction.canStart(elementToRename.getProject());
            if (startMarkAction == null || processor2.substituteElementToRename(elementToRename, editor) == elementToRename) {
                processor2.substituteElementToRename(elementToRename, editor, new Pass<PsiElement>(){

                    public void pass(PsiElement element) {
                        MemberInplaceRenamer renamer = MemberInplaceRenameHandler.this.createMemberRenamer(element, (PsiNameIdentifierOwner)elementToRename, editor);
                        boolean startedRename = renamer.performInplaceRename();
                        if (!startedRename) {
                            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, renamer.myInitialName);
                        }
                    }
                });
                return null;
            }
            InplaceRefactoring inplaceRefactoring = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
            if (inplaceRefactoring != null && inplaceRefactoring.getClass() == MemberInplaceRenamer.class && (templateState = TemplateManagerImpl.getTemplateState(InjectedLanguageUtil.getTopLevelEditor(editor))) != null) {
                templateState.gotoEnd(true);
            }
        }
        MemberInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, null);
        return null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        if (element == null) {
            MemberInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        MemberInplaceRenamer memberInplaceRenamer = new MemberInplaceRenamer((PsiNamedElement)elementToRename, element, editor);
        if (memberInplaceRenamer == null) {
            MemberInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        return memberInplaceRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRename";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMemberRenamer";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

