/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class VcsInitialization
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsInitialization");
    private final List<Pair<VcsInitObject, Runnable>> myList;
    private final Object myLock;
    @NotNull
    private final Project myProject;
    private Status myStatus;
    private volatile Future<?> myFuture;
    private final ProgressIndicator myIndicator;

    VcsInitialization(@NotNull Project project) {
        if (project == null) {
            VcsInitialization.$$$reportNull$$$0(0);
        }
        this.myList = new ArrayList<Pair<VcsInitObject, Runnable>>();
        this.myLock = new Object();
        this.myStatus = Status.IDLE;
        this.myIndicator = new StandardProgressIndicatorBase();
        this.myProject = project;
        if (project.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (project == null) {
                VcsInitialization.$$$reportNull$$$0(5);
            }
            if (project.isDisposed()) {
                return;
            }
            this.myFuture = ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, "VCS Initialization"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    VcsInitialization.this.execute(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsInitialization$1", "run"));
                }
            }, this.myIndicator, null);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable2) {
        if (vcsInitObject == null) {
            VcsInitialization.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            VcsInitialization.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStatus != Status.IDLE) {
                if (!vcsInitObject.isCanBeLast()) {
                    LOG.info("Registering startup activity AFTER initialization ", new Throwable());
                }
                ApplicationManager.getApplication().invokeLater(runnable2, this.myProject.getDisposed());
                return;
            }
            this.myList.add((Pair<VcsInitObject, Runnable>)Pair.create((Object)((Object)vcsInitObject), (Object)runnable2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void execute(@NotNull ProgressIndicator indicator) {
        List<Pair<VcsInitObject, Runnable>> list2;
        block18: {
            if (indicator == null) {
                VcsInitialization.$$$reportNull$$$0(3);
            }
            Iterator<Pair<VcsInitObject, Runnable>> iterator = this.myLock;
            // MONITORENTER : iterator
            list2 = this.myList;
            if (this.myStatus == Status.IDLE) break block18;
            // MONITOREXIT : iterator
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            return;
        }
        this.myStatus = Status.RUNNING;
        Future<?> future2 = this.myFuture;
        if (future2 != null && future2.isCancelled() || indicator.isCanceled()) {
            // MONITOREXIT : iterator
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            return;
        }
        try {
            // MONITOREXIT : iterator
            Collections.sort(list2, Comparator.comparingInt(o -> ((VcsInitObject)((Object)((Object)o.getFirst()))).getOrder()));
            for (Pair<VcsInitObject, Runnable> pair : list2) {
                ProgressManager.checkCanceled();
                ((Runnable)pair.getSecond()).run();
            }
            Object object = this.myLock;
        }
        catch (Throwable throwable) {
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            throw throwable;
        }
        this.myStatus = Status.FINISHED;
        // MONITOREXIT : object
    }

    public void dispose() {
        this.myIndicator.cancel();
        this.cancelBackgroundInitialization();
    }

    private void cancelBackgroundInitialization() {
        Future<?> future2 = this.myFuture;
        LOG.debug("cancelBackgroundInitialization() future=" + future2 + " from " + Thread.currentThread() + " with write access=" + ApplicationManager.getApplication().isWriteAccessAllowed());
        if (future2 != null) {
            future2.cancel(false);
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                SwingUtilities.invokeLater(this::waitNotRunning);
            } else {
                this.waitNotRunning();
            }
        }
    }

    void waitNotRunning() {
        this.waitFor(status -> status != Status.RUNNING);
    }

    void waitFinished() {
        this.waitFor(status -> status == Status.FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(@NotNull Predicate<Status> predicate) {
        if (predicate == null) {
            VcsInitialization.$$$reportNull$$$0(4);
        }
        LOG.debug("waitFor() status=" + (Object)((Object)this.myStatus));
        long start = System.currentTimeMillis();
        Status status = null;
        while (System.currentTimeMillis() < start + 10000L) {
            Object object = this.myLock;
            synchronized (object) {
                status = this.myStatus;
                if (predicate.test(status)) {
                    break;
                }
            }
            TimeoutUtil.sleep((long)10L);
        }
        if (status == Status.RUNNING) {
            LOG.error("Failed to wait for completion of VCS initialization for project " + this.myProject, new Attachment[]{new Attachment("thread dump", ThreadDumper.dumpThreadsToString())});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsInitObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsInitialization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "waitFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Status {
        IDLE,
        RUNNING,
        FINISHED;

    }
}

