/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeList");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Change> myChanges;
    private Set<Change> myReadChangesCache;
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NotNull
    private String myComment;
    @Nullable
    private Object myData;
    private boolean myIsDefault;
    private boolean myIsReadOnly;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(@NotNull Project project, @NotNull String name, @Nullable String id) {
        if (project == null) {
            LocalChangeListImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(1);
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl(project, name, id);
        if (localChangeListImpl == null) {
            LocalChangeListImpl.$$$reportNull$$$0(2);
        }
        return localChangeListImpl;
    }

    private LocalChangeListImpl(@NotNull Project project, @NotNull String name, @Nullable String id) {
        if (project == null) {
            LocalChangeListImpl.$$$reportNull$$$0(3);
        }
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(4);
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myProject = project;
        this.myId = id != null ? id : UUID.randomUUID().toString();
        this.myName = LocalChangeListImpl.validateName(name);
        this.myChanges = ContainerUtil.newHashSet();
    }

    private LocalChangeListImpl(@NotNull LocalChangeListImpl origin, @NotNull String name) {
        if (origin == null) {
            LocalChangeListImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(6);
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myId = origin.getId();
        this.myProject = origin.myProject;
        this.myName = LocalChangeListImpl.validateName(name);
        this.myComment = origin.myComment;
        this.myIsDefault = origin.myIsDefault;
        this.myIsReadOnly = origin.myIsReadOnly;
        this.myData = origin.myData;
        this.myChanges = ContainerUtil.newHashSet(origin.myChanges);
        this.myReadChangesCache = origin.myReadChangesCache;
    }

    @NotNull
    public Set<Change> getChanges() {
        if (this.myReadChangesCache == null) {
            this.myReadChangesCache = Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myChanges));
        }
        Set<Change> set2 = this.myReadChangesCache;
        if (set2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(7);
        }
        return set2;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            LocalChangeListImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LocalChangeListImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String validateName(@NotNull String name) {
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)name) && Registry.is((String)"vcs.log.empty.change.list.creation")) {
            LOG.info("Creating a changelist with empty name");
        }
        String string = name;
        if (string == null) {
            LocalChangeListImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getComment() {
        String string = this.myComment;
        if (string == null) {
            LocalChangeListImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setCommentImpl(@Nullable String comment) {
        this.myComment = comment != null ? comment : "";
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    void setDefault(boolean isDefault) {
        this.myIsDefault = isDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnlyImpl(boolean isReadOnly) {
        this.myIsReadOnly = isReadOnly;
    }

    void setData(@Nullable ChangeListData data) {
        this.myData = data;
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    void addChange(Change change) {
        this.myReadChangesCache = null;
        this.myChanges.add(change);
        if (LOG.isDebugEnabled()) {
            LOG.debug("List: " + this.myName + ". addChange: " + change);
        }
    }

    @Nullable
    Change removeChange(@Nullable Change change) {
        if (this.myChanges.remove(change)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("List: " + this.myName + ". removeChange: " + change);
            }
            this.myReadChangesCache = null;
            return change;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list2 = (LocalChangeListImpl)((Object)o);
        return this.myName.equals(list2.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName.trim();
    }

    public LocalChangeListImpl copy() {
        return new LocalChangeListImpl(this, this.myName);
    }

    public LocalChangeListImpl copy(@NotNull String newName) {
        if (newName == null) {
            LocalChangeListImpl.$$$reportNull$$$0(13);
        }
        return new LocalChangeListImpl(this, newName);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(14);
        }
        ChangeListManager.getInstance((Project)this.myProject).editName(this.myName, name);
    }

    public void setComment(@Nullable String comment) {
        ChangeListManager.getInstance((Project)this.myProject).editComment(this.myName, comment);
    }

    public void setReadOnly(boolean isReadOnly) {
        ChangeListManager.getInstance((Project)this.myProject).setReadOnly(this.myName, isReadOnly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/LocalChangeListImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/LocalChangeListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyChangeListImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "validateName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyChangeListImpl";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

