/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    @NonNls
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    @NonNls
    private static final String DATE_NAME_TEMPLATE = "(date {0})";
    @NotNull
    private final String myBasePath;
    private final boolean myIsReversePath;
    private final boolean myIsCaseSensitive;
    @Nullable
    private final Runnable myCancelChecker;

    private TextPatchBuilder(@NotNull String basePath, boolean isReversePath, boolean isCaseSensitive, @Nullable Runnable cancelChecker) {
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(0);
        }
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myIsCaseSensitive = isCaseSensitive;
        this.myCancelChecker = cancelChecker;
    }

    @NotNull
    public static List<FilePatch> buildPatch(@NotNull Collection<BeforeAfter<AirContentRevision>> changes, @NotNull String basePath, boolean reversePatch, boolean isCaseSensitive, @Nullable Runnable cancelChecker) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(1);
        }
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(2);
        }
        TextPatchBuilder builder = new TextPatchBuilder(basePath, reversePatch, isCaseSensitive, cancelChecker);
        List<FilePatch> list2 = builder.build(changes);
        if (list2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private List<FilePatch> build(@NotNull Collection<BeforeAfter<AirContentRevision>> changes) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<FilePatch> result2 = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> c : changes) {
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            FilePatch patch;
            if (this.myCancelChecker != null) {
                this.myCancelChecker.run();
            }
            if ((patch = this.createPatch(beforeRevision = this.myIsReversePath ? (AirContentRevision)c.getAfter() : (AirContentRevision)c.getBefore(), afterRevision = this.myIsReversePath ? (AirContentRevision)c.getBefore() : (AirContentRevision)c.getAfter())) == null) continue;
            result2.add(patch);
        }
        ArrayList<FilePatch> arrayList = result2;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private FilePatch createPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null && afterRevision == null) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.getPath().isDirectory()) {
            return null;
        }
        if (afterRevision != null && afterRevision.getPath().isDirectory()) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
            return this.buildBinaryPatch(beforeRevision, afterRevision);
        }
        if (beforeRevision == null) {
            return this.buildAddedFile(afterRevision);
        }
        if (afterRevision == null) {
            return this.buildDeletedFile(beforeRevision);
        }
        return this.buildModifiedFile(beforeRevision, afterRevision);
    }

    @Nullable
    private TextFilePatch buildModifiedFile(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(6);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(7);
        }
        String beforeContent = TextPatchBuilder.getContent(beforeRevision);
        String afterContent = TextPatchBuilder.getContent(afterRevision);
        TextFilePatch patch = this.buildPatchHeading(beforeRevision, afterRevision);
        if (beforeContent.equals(afterContent)) {
            if (beforeRevision.getPath().getPath().equals(afterRevision.getPath().getPath())) {
                return null;
            }
            patch.addHunk(new PatchHunk(0, 0, 0, 0));
            return patch;
        }
        List<PatchHunk> hunks = TextPatchBuilder.buildPatchHunks(beforeContent, afterContent);
        for (PatchHunk hunk : hunks) {
            patch.addHunk(hunk);
        }
        return patch;
    }

    @NotNull
    public static List<PatchHunk> buildPatchHunks(@NotNull String beforeContent, @NotNull String afterContent) {
        List<Range> hunkFragments;
        if (beforeContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(8);
        }
        if (afterContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(9);
        }
        if (beforeContent.isEmpty()) {
            List<PatchHunk> list2 = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(afterContent, true, true));
            if (list2 == null) {
                TextPatchBuilder.$$$reportNull$$$0(10);
            }
            return list2;
        }
        if (afterContent.isEmpty()) {
            List<PatchHunk> list3 = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(beforeContent, false, true));
            if (list3 == null) {
                TextPatchBuilder.$$$reportNull$$$0(11);
            }
            return list3;
        }
        ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
        List<String> beforeLines = TextPatchBuilder.tokenize(beforeContent);
        List<String> afterLines = TextPatchBuilder.tokenize(afterContent);
        boolean beforeNoNewlineAtEOF = !beforeContent.endsWith("\n");
        boolean afterNoNewlineAtEOF = !afterContent.endsWith("\n");
        List<Range> fragments = TextPatchBuilder.compareLines(beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF);
        for (int hunkStart = 0; hunkStart < fragments.size(); hunkStart += hunkFragments.size()) {
            hunkFragments = TextPatchBuilder.getAdjacentFragments(fragments, hunkStart);
            hunks.add(TextPatchBuilder.createHunk(hunkFragments, beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF));
        }
        ArrayList<PatchHunk> arrayList = hunks;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<Range> getAdjacentFragments(@NotNull List<Range> fragments, int hunkStart) {
        int hunkEnd;
        if (fragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(13);
        }
        for (hunkEnd = hunkStart + 1; hunkEnd < fragments.size(); ++hunkEnd) {
            Range lastFragment = fragments.get(hunkEnd - 1);
            Range nextFragment = fragments.get(hunkEnd);
            if (lastFragment.end1 + 3 < nextFragment.start1 - 3 && lastFragment.end2 + 3 < nextFragment.start2 - 3) break;
        }
        List<Range> list2 = fragments.subList(hunkStart, hunkEnd);
        if (list2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    private static PatchHunk createHunk(@NotNull List<Range> hunkFragments, @NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (hunkFragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(15);
        }
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(16);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(17);
        }
        Range first = hunkFragments.get(0);
        Range last = hunkFragments.get(hunkFragments.size() - 1);
        int contextStart1 = Math.max(first.start1 - 3, 0);
        int contextStart2 = Math.max(first.start2 - 3, 0);
        int contextEnd1 = Math.min(last.end1 + 3, beforeLines.size());
        int contextEnd2 = Math.min(last.end2 + 3, afterLines.size());
        PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
        int lastLine1 = contextStart1;
        int lastLine2 = contextStart2;
        for (Range fragment : hunkFragments) {
            int i;
            int start1 = fragment.start1;
            int start2 = fragment.start2;
            int end1 = fragment.end1;
            int end2 = fragment.end2;
            assert (start1 - lastLine1 == start2 - lastLine2);
            for (i = lastLine1; i < start1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
            }
            for (i = start1; i < end1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.REMOVE, i, beforeNoNewlineAtEOF);
            }
            for (i = start2; i < end2; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, afterLines, PatchLine.Type.ADD, i, afterNoNewlineAtEOF);
            }
            lastLine1 = end1;
            lastLine2 = end2;
        }
        assert (contextEnd1 - lastLine1 == contextEnd2 - lastLine2);
        for (int i = lastLine1; i < contextEnd1; ++i) {
            TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(18);
        }
        return patchHunk;
    }

    @NotNull
    private static List<Range> compareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(19);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(20);
        }
        if (!beforeNoNewlineAtEOF && !afterNoNewlineAtEOF) {
            List<Range> list2 = TextPatchBuilder.doCompareLines(beforeLines, afterLines);
            if (list2 == null) {
                TextPatchBuilder.$$$reportNull$$$0(21);
            }
            return list2;
        }
        int beforeLastLine = beforeLines.size() - 1;
        int afterLastLine = afterLines.size() - 1;
        List<String> beforeComparedLines = beforeNoNewlineAtEOF ? beforeLines.subList(0, beforeLastLine) : beforeLines;
        List<String> afterComparedLines = afterNoNewlineAtEOF ? afterLines.subList(0, afterLastLine) : afterLines;
        List<Range> ranges = TextPatchBuilder.doCompareLines(beforeComparedLines, afterComparedLines);
        if (beforeNoNewlineAtEOF && afterNoNewlineAtEOF) {
            if (beforeLines.get(beforeLastLine).equals(afterLines.get(afterLastLine))) {
                List<Range> list3 = ranges;
                if (list3 == null) {
                    TextPatchBuilder.$$$reportNull$$$0(22);
                }
                return list3;
            }
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
            List<Range> list4 = TextPatchBuilder.appendRange(ranges, range);
            if (list4 == null) {
                TextPatchBuilder.$$$reportNull$$$0(23);
            }
            return list4;
        }
        if (beforeNoNewlineAtEOF) {
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine + 1, afterLastLine + 1);
            List<Range> list5 = TextPatchBuilder.appendRange(ranges, range);
            if (list5 == null) {
                TextPatchBuilder.$$$reportNull$$$0(24);
            }
            return list5;
        }
        Range range = new Range(beforeLastLine + 1, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
        List<Range> list6 = TextPatchBuilder.appendRange(ranges, range);
        if (list6 == null) {
            TextPatchBuilder.$$$reportNull$$$0(25);
        }
        return list6;
    }

    @NotNull
    private static List<Range> appendRange(@NotNull List<Range> ranges, @NotNull Range change) {
        if (ranges == null) {
            TextPatchBuilder.$$$reportNull$$$0(26);
        }
        if (change == null) {
            TextPatchBuilder.$$$reportNull$$$0(27);
        }
        if (ranges.isEmpty()) {
            List<Range> list2 = Collections.singletonList(change);
            if (list2 == null) {
                TextPatchBuilder.$$$reportNull$$$0(28);
            }
            return list2;
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.end1 == change.start1 && lastRange.end2 == change.start2) {
            Range mergedChange = new Range(lastRange.start1, change.end1, lastRange.start2, change.end2);
            List list3 = ContainerUtil.append(ranges.subList(0, ranges.size() - 1), (Object[])new Range[]{mergedChange});
            if (list3 == null) {
                TextPatchBuilder.$$$reportNull$$$0(29);
            }
            return list3;
        }
        List list4 = ContainerUtil.append(ranges, (Object[])new Range[]{change});
        if (list4 == null) {
            TextPatchBuilder.$$$reportNull$$$0(30);
        }
        return list4;
    }

    @NotNull
    private static List<Range> doCompareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines) {
        ArrayList arrayList;
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(31);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(32);
        }
        try {
            FairDiffIterable iterable = ByLine.compare(beforeLines, afterLines, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            arrayList = ContainerUtil.newArrayList(iterable.iterateChanges());
        }
        catch (DiffTooBigException e) {
            List<Range> list2 = Collections.singletonList(new Range(0, beforeLines.size(), 0, afterLines.size()));
            if (list2 == null) {
                TextPatchBuilder.$$$reportNull$$$0(34);
            }
            return list2;
        }
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private FilePatch buildBinaryPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        assert (beforeRevision != null || afterRevision != null);
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading((FilePatch)patch, headingBeforeRevision, headingAfterRevision);
        BinaryFilePatch binaryFilePatch = patch;
        if (binaryFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(35);
        }
        return binaryFilePatch;
    }

    @NotNull
    private TextFilePatch buildAddedFile(@NotNull AirContentRevision afterRevision) throws VcsException {
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(36);
        }
        TextFilePatch result2 = this.buildPatchHeading(afterRevision, afterRevision);
        String content = TextPatchBuilder.getContent(afterRevision);
        result2.addHunk(TextPatchBuilder.createWholeFileHunk(content, true, false));
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(37);
        }
        return textFilePatch;
    }

    @NotNull
    private TextFilePatch buildDeletedFile(@NotNull AirContentRevision beforeRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(38);
        }
        TextFilePatch result2 = this.buildPatchHeading(beforeRevision, beforeRevision);
        String content = TextPatchBuilder.getContent(beforeRevision);
        result2.addHunk(TextPatchBuilder.createWholeFileHunk(content, false, false));
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(39);
        }
        return textFilePatch;
    }

    private static void addLineToHunk(@NotNull PatchHunk hunk, @NotNull List<String> lines2, @NotNull PatchLine.Type type, int index, boolean noNewlineAtEOF) {
        if (hunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(40);
        }
        if (lines2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(41);
        }
        if (type == null) {
            TextPatchBuilder.$$$reportNull$$$0(42);
        }
        String line = lines2.get(index);
        boolean isLastLine = index == lines2.size() - 1;
        PatchLine patchLine = new PatchLine(type, line);
        patchLine.setSuppressNewLine(noNewlineAtEOF && isLastLine);
        hunk.addLine(patchLine);
    }

    @NotNull
    private static PatchHunk createWholeFileHunk(@NotNull String content, boolean isInsertion, boolean isWithEmptyFile) {
        if (content == null) {
            TextPatchBuilder.$$$reportNull$$$0(43);
        }
        PatchLine.Type type = isInsertion ? PatchLine.Type.ADD : PatchLine.Type.REMOVE;
        List<String> lines2 = TextPatchBuilder.tokenize(content);
        boolean noNewlineAtEOF = !content.endsWith("\n");
        int contentStart = 0;
        int contentEnd = lines2.size();
        int emptyStart = isWithEmptyFile ? 0 : -1;
        int emptyEnd = isWithEmptyFile ? 0 : -1;
        PatchHunk hunk = new PatchHunk(isInsertion ? emptyStart : contentStart, isInsertion ? emptyEnd : contentEnd, isInsertion ? contentStart : emptyStart, isInsertion ? contentEnd : emptyEnd);
        for (int i = 0; i < lines2.size(); ++i) {
            TextPatchBuilder.addLineToHunk(hunk, lines2, type, i, noNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(44);
        }
        return patchHunk;
    }

    @NotNull
    private String getRelativePath(@NotNull String secondPath) {
        String secondModified;
        String baseModified;
        String relPath;
        if (secondPath == null) {
            TextPatchBuilder.$$$reportNull$$$0(45);
        }
        if ((relPath = FileUtil.getRelativePath((String)(baseModified = FileUtil.toSystemIndependentName((String)this.myBasePath)), (String)(secondModified = FileUtil.toSystemIndependentName((String)secondPath)), (char)'/', (boolean)this.myIsCaseSensitive)) == null) {
            String string = secondModified;
            if (string == null) {
                TextPatchBuilder.$$$reportNull$$$0(46);
            }
            return string;
        }
        String string = relPath;
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private TextFilePatch buildPatchHeading(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(48);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(49);
        }
        TextFilePatch result2 = new TextFilePatch(afterRevision.getCharset(), afterRevision.getLineSeparator());
        this.setPatchHeading((FilePatch)result2, beforeRevision, afterRevision);
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(50);
        }
        return textFilePatch;
    }

    private void setPatchHeading(@NotNull FilePatch result2, @NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (result2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(51);
        }
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(52);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(53);
        }
        result2.setBeforeName(this.getRelativePath(beforeRevision.getPath().getPath()));
        result2.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result2.setAfterName(this.getRelativePath(afterRevision.getPath().getPath()));
        result2.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }

    @NotNull
    private static String getRevisionName(@NotNull AirContentRevision revision) {
        String revisionName;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(54);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(revisionName = revision.getRevisionNumber()))) {
            String string = MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
            if (string == null) {
                TextPatchBuilder.$$$reportNull$$$0(55);
            }
            return string;
        }
        String string = MessageFormat.format(DATE_NAME_TEMPLATE, Long.toString(revision.getPath().lastModified()));
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    private static String getContent(@NotNull AirContentRevision revision) throws VcsException {
        String beforeContent;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(57);
        }
        if ((beforeContent = revision.getContentAsString()) == null) {
            throw new VcsException("Failed to fetch old content for file " + revision.getPath().getPath());
        }
        String string = beforeContent;
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    private static List<String> tokenize(@NotNull String text) {
        if (text == null) {
            TextPatchBuilder.$$$reportNull$$$0(59);
        }
        List list2 = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)true);
        if (list2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(60);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 6: 
            case 38: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRevision";
                break;
            }
            case 7: 
            case 36: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRevision";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterContent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunkFragments";
                break;
            }
            case 16: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLines";
                break;
            }
            case 17: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLines";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPath";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHunks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentFragments";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHunk";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRange";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompareLines";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBinaryPatch";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAddedFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeletedFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createWholeFileHunk";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHeading";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildModifiedFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHunks";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentFragments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHunk";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendRange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doCompareLines";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildAddedFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildDeletedFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addLineToHunk";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createWholeFileHunk";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHeading";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setPatchHeading";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

