/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    private String myText;

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list2, (Object)null, index, isSelected, cellHasFocus);
        this.customizeCellRenderer(value, index, isSelected, cellHasFocus);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    protected void customizeCellRenderer(Object value, int index, boolean selected, boolean hasFocus) {
        PsiElement element;
        this.myText = "";
        if (value instanceof PsiElement && (element = (PsiElement)value).isValid()) {
            VirtualFile vFile;
            PsiFile psiFile = element.getContainingFile();
            Module module2 = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            boolean isInLibraries = false;
            if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                boolean bl = isInLibraries = fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile);
                if (isInLibraries) {
                    this.showLibraryLocation(fileIndex, vFile);
                }
            }
            if (module2 != null && !isInLibraries) {
                this.showProjectLocation(psiFile, module2, fileIndex);
            }
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
        this.setForeground(selected ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor());
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            this.setOpaque(false);
        }
    }

    private void showProjectLocation(PsiFile psiFile, Module module2, ProjectFileIndex fileIndex) {
        VirtualFile vFile;
        boolean inTestSource = false;
        if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
            inTestSource = fileIndex.isInTestSourceContent(vFile);
        }
        this.myText = module2.getName();
        if (inTestSource) {
            this.setIcon(AllIcons.Modules.TestSourceFolder);
        } else {
            this.setIcon(ModuleType.get((Module)module2).getIcon());
        }
    }

    private void showLibraryLocation(ProjectFileIndex fileIndex, VirtualFile vFile) {
        this.setIcon(AllIcons.Nodes.PpLibFolder);
        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            this.myText = this.getPresentableName(order, vFile);
            break;
        }
        this.myText = this.myText.substring(this.myText.lastIndexOf(File.separatorChar) + 1);
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
        if (jar != null && !this.myText.equals(jar.getName())) {
            this.myText = this.myText + " (" + jar.getName() + ")";
        }
    }

    protected String getPresentableName(OrderEntry order, VirtualFile vFile) {
        return order.getPresentableName();
    }
}

