/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField2) {
        super(textField2);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return MacIntelliJIconCache.getIcon(clickable ? "searchFieldWithHistory" : "search");
    }

    @Override
    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : MacIntelliJIconCache.getIcon("searchFieldClear");
    }

    @Override
    protected int getMinimumHeight() {
        return DarculaEditorTextFieldBorder.isComboBoxEditor(this.getComponent()) ? JBUI.scale((int)18) : JBUI.scale((int)28);
    }

    @Override
    protected int getClearIconPreferredSpace() {
        return super.getClearIconPreferredSpace() - this.getClearIconGap();
    }

    @Override
    protected void updateIconsLayout(Rectangle bounds) {
        super.updateIconsLayout(bounds);
        JTextComponent component = this.getComponent();
        if (component == null || component.hasFocus()) {
            return;
        }
        TextFieldWithPopupHandlerUI.IconHolder clear = (TextFieldWithPopupHandlerUI.IconHolder)this.icons.get("clear");
        if (clear == null || clear.icon != null) {
            return;
        }
        TextFieldWithPopupHandlerUI.IconHolder search2 = (TextFieldWithPopupHandlerUI.IconHolder)this.icons.get("search");
        if (search2 == null || search2.icon == null || search2.isClickable()) {
            return;
        }
        search2.bounds.x = bounds.x + (bounds.width - search2.bounds.width) / 2;
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            Container parent = component.getParent();
            if (parent != null && component.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, component.getWidth(), component.getHeight());
            }
            if (MacIntelliJTextFieldUI.isSearchField(component)) {
                MacIntelliJTextFieldUI.paintSearchField((Graphics2D)g, component, new Rectangle(component.getWidth(), component.getHeight()));
            } else if (component.getBorder() instanceof MacIntelliJTextBorder) {
                g.setColor(component.getBackground());
                g.fillRect(JBUI.scale((int)3), JBUI.scale((int)3), component.getWidth() - JBUI.scale((int)3) * 2, component.getHeight() - JBUI.scale((int)3) * 2);
            } else if (component.isOpaque()) {
                super.paintBackground(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = JBUI.scale((float)6.0f);
            double lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
            RoundRectangle2D.Double outerShape = new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), r.width - JBUI.scale((int)3) * 2, r.height - JBUI.scale((int)3) * 2, arc, arc);
            g2.setColor(c.getBackground());
            g2.fill(outerShape);
            Path2D.Double path = new Path2D.Double(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)r.width - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)r.height - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)arc - lw, (double)arc - lw), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(path);
            if (c.hasFocus() && c.getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAquaSearchFocusRing(Graphics2D g, Rectangle r, Component c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = JBUI.scale((int)6);
            double lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
            RoundRectangle2D.Double outerShape = new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), r.width - JBUI.scale((int)3) * 2, r.height - JBUI.scale((int)3) * 2, arc, arc);
            g2.setColor(c.getBackground());
            g2.fill(outerShape);
            Path2D.Double path = new Path2D.Double(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)r.width - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)r.height - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)arc - lw, (double)arc - lw), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(path);
            if (c.hasFocus()) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

