/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionStructureUtil {
    public static Collection<StructureViewTreeElement> groupByCustomRegions(@NotNull PsiElement rootElement, @NotNull Collection<StructureViewTreeElement> originalElements) {
        if (rootElement == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(0);
        }
        if (originalElements == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(1);
        }
        if (rootElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)rootElement).getStub() != null) {
            return originalElements;
        }
        Set childrenRanges = ContainerUtil.map2SetNotNull(originalElements, element -> {
            Object value = element.getValue();
            return value instanceof PsiElement ? CustomRegionStructureUtil.getTextRange((PsiElement)value) : null;
        });
        Collection<CustomRegionTreeElement> customRegions = CustomRegionStructureUtil.collectCustomRegions(rootElement, childrenRanges);
        if (customRegions.size() > 0) {
            ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(customRegions);
            for (StructureViewTreeElement element2 : originalElements) {
                ProgressManager.checkCanceled();
                boolean isInCustomRegion = false;
                for (CustomRegionTreeElement customRegion : customRegions) {
                    if (!customRegion.containsElement(element2)) continue;
                    customRegion.addChild(element2);
                    isInCustomRegion = true;
                    break;
                }
                if (isInCustomRegion) continue;
                result2.add(element2);
            }
            return result2;
        }
        return originalElements;
    }

    private static TextRange getTextRange(@NotNull PsiElement element) {
        PsiElement first;
        if (element == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(2);
        }
        if ((first = element.getFirstChild()) instanceof PsiComment && !first.textContains('\n')) {
            PsiElement next = first.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next != null) {
                return new TextRange(next.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
            }
        }
        return element.getTextRange();
    }

    private static Collection<CustomRegionTreeElement> collectCustomRegions(@NotNull PsiElement rootElement, @NotNull Set<TextRange> ranges) {
        if (rootElement == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(3);
        }
        if (ranges == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(4);
        }
        TextRange rootRange = CustomRegionStructureUtil.getTextRange(rootElement);
        Iterator iterator = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)rootElement).filter(element -> {
            if (ranges == null) {
                CustomRegionStructureUtil.$$$reportNull$$$0(9);
            }
            return CustomRegionStructureUtil.isCustomRegionCommentCandidate(element) && rootRange.contains(element.getTextRange()) && !CustomRegionStructureUtil.isInsideRanges(element, ranges);
        })).iterator();
        List customRegions = ContainerUtil.newSmartList();
        CustomRegionTreeElement currRegionElement = null;
        CustomFoldingProvider provider = null;
        while (iterator.hasNext()) {
            ProgressManager.checkCanceled();
            PsiElement child = (PsiElement)iterator.next();
            if (provider == null) {
                provider = CustomRegionStructureUtil.getProvider(child);
            }
            if (provider == null) continue;
            String commentText = child.getText();
            if (provider.isCustomRegionStart(commentText)) {
                if (currRegionElement == null) {
                    currRegionElement = new CustomRegionTreeElement(child, provider);
                    customRegions.add(currRegionElement);
                    continue;
                }
                currRegionElement = currRegionElement.createNestedRegion(child);
                continue;
            }
            if (!provider.isCustomRegionEnd(commentText) || currRegionElement == null) continue;
            currRegionElement = currRegionElement.endRegion(child);
        }
        return customRegions;
    }

    @Nullable
    static CustomFoldingProvider getProvider(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(5);
        }
        if ((node = element.getNode()) != null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(node.getText())) continue;
                return provider;
            }
        }
        return null;
    }

    private static boolean isInsideRanges(@NotNull PsiElement element, @NotNull Set<TextRange> ranges) {
        if (element == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(6);
        }
        if (ranges == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(7);
        }
        for (TextRange range : ranges) {
            TextRange elementRange;
            if (!range.contains((elementRange = element.getTextRange()).getStartOffset()) && !range.contains(elementRange.getEndOffset())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomRegionCommentCandidate(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(8);
        }
        if (!Language.ANY.is(language = element.getLanguage())) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder instanceof CustomFoldingBuilder) {
                return ((CustomFoldingBuilder)foldingBuilder).isCustomFoldingCandidate(element);
            }
            if (foldingBuilder instanceof CompositeFoldingBuilder) {
                for (FoldingBuilder simpleBuilder : ((CompositeFoldingBuilder)foldingBuilder).getAllBuilders()) {
                    if (!(simpleBuilder instanceof CustomFoldingBuilder) || !((CustomFoldingBuilder)simpleBuilder).isCustomFoldingCandidate(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "groupByCustomRegions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCustomRegions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideRanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomRegionCommentCandidate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectCustomRegions$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

