/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileDirPathFromParentMacro
extends Macro {
    private static final String PATH_DELIMITER = "/";

    @Override
    public String getName() {
        return "FileDirPathFromParent";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.directory.from.parent", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        return null;
    }

    @Override
    public String expand(DataContext dataContext, String ... args) throws Macro.ExecutionCancelledException {
        if (args.length == 0) {
            return super.expand(dataContext, args);
        }
        VirtualFile dir = FileDirPathFromParentMacro.getVirtualDirOrParent(dataContext);
        if (dir == null) {
            return "";
        }
        String dirPath = dir.getPath();
        String surroundedSubDir = FileDirPathFromParentMacro.surroundWithSlashes(FileUtil.toSystemIndependentName((String)args[0]));
        String surroundedDirPath = FileDirPathFromParentMacro.surroundWithSlashes(dirPath);
        if (surroundedSubDir.length() == 1) {
            return FileUtil.toSystemDependentName((String)surroundedDirPath.substring(1));
        }
        int ind = FileDirPathFromParentMacro.lastIndexOf(surroundedDirPath, surroundedSubDir, surroundedDirPath.length(), !SystemInfo.isFileSystemCaseSensitive);
        if (ind >= 0) {
            return FileUtil.toSystemDependentName((String)surroundedDirPath.substring(ind + surroundedSubDir.length()));
        }
        return FileUtil.toSystemDependentName((String)(dirPath.endsWith(PATH_DELIMITER) ? dirPath : dirPath + PATH_DELIMITER));
    }

    private static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex, boolean ignoreCase) {
        if (buffer == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(1);
        }
        int patternLength = pattern.length();
        int end = buffer.length() - patternLength;
        if (maxIndex > end) {
            maxIndex = end;
        }
        for (int i = maxIndex; i >= 0; --i) {
            boolean found = true;
            for (int j = 0; j < patternLength; ++j) {
                if (ignoreCase) {
                    if (StringUtil.charsEqualIgnoreCase((char)pattern.charAt(j), (char)buffer.charAt(i + j))) continue;
                    found = false;
                    break;
                }
                if (pattern.charAt(j) == buffer.charAt(i + j)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static String surroundWithSlashes(@NotNull String path) {
        boolean append;
        if (path == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(2);
        }
        if (path.isEmpty()) {
            if (PATH_DELIMITER == null) {
                FileDirPathFromParentMacro.$$$reportNull$$$0(3);
            }
            return PATH_DELIMITER;
        }
        boolean prepend = !path.startsWith(PATH_DELIMITER);
        boolean bl = append = !path.endsWith(PATH_DELIMITER);
        if (prepend && append) {
            String string = PATH_DELIMITER + path + PATH_DELIMITER;
            if (string == null) {
                FileDirPathFromParentMacro.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (prepend) {
            path = PATH_DELIMITER + path;
        }
        if (append) {
            path = path + PATH_DELIMITER;
        }
        String string = path;
        if (string == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/FileDirPathFromParentMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/FileDirPathFromParentMacro";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundWithSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithSlashes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

