/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.process.ScriptRunnerUtil");
    public static final Condition<Key> STDOUT_OUTPUT_KEY_FILTER = key -> ProcessOutputTypes.STDOUT.equals(key);
    public static final Condition<Key> STDERR_OUTPUT_KEY_FILTER = key -> ProcessOutputTypes.STDERR.equals(key);
    public static final Condition<Key> STDOUT_OR_STDERR_OUTPUT_KEY_FILTER = Conditions.or(STDOUT_OUTPUT_KEY_FILTER, STDERR_OUTPUT_KEY_FILTER);
    private static final int DEFAULT_TIMEOUT = 30000;

    private ScriptRunnerUtil() {
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(0);
        }
        return ScriptRunnerUtil.getProcessOutput(commandLine, STDOUT_OUTPUT_KEY_FILTER, 30000L);
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine, @NotNull Condition<Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (commandLine == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(1);
        }
        if (outputTypeFilter == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(2);
        }
        return ScriptRunnerUtil.getProcessOutput((ProcessHandler)new OSProcessHandler(commandLine), outputTypeFilter, timeout);
    }

    public static String getProcessOutput(@NotNull ProcessHandler processHandler2, final @NotNull Condition<Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (processHandler2 == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(3);
        }
        if (outputTypeFilter == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!processHandler2.isStartNotified());
        final StringBuilder outputBuilder = new StringBuilder();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputTypeFilter.value((Object)outputType)) {
                    String text = event.getText();
                    outputBuilder.append(text);
                    LOG.debug(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        return outputBuilder.toString();
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters) throws ExecutionException {
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(5);
        }
        OSProcessHandler oSProcessHandler = ScriptRunnerUtil.execute(exePath, workingDirectory, scriptFile, parameters, null, (ThrowableNotNullFunction<GeneralCommandLine, OSProcessHandler, ExecutionException>)((ThrowableNotNullFunction)commandLine -> new ColoredProcessHandler((GeneralCommandLine)commandLine)));
        if (oSProcessHandler == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(6);
        }
        return oSProcessHandler;
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters, @Nullable Charset charset, @NotNull ThrowableNotNullFunction<GeneralCommandLine, OSProcessHandler, ExecutionException> creator) throws ExecutionException {
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(7);
        }
        if (creator == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(8);
        }
        GeneralCommandLine commandLine = ScriptRunnerUtil.getBasicCommandLine(exePath);
        if (scriptFile != null) {
            commandLine.addParameter(scriptFile.getPresentableUrl());
        }
        commandLine.addParameters(parameters);
        if (workingDirectory != null) {
            commandLine.setWorkDirectory(workingDirectory);
        }
        LOG.debug("Command line: ", new Object[]{commandLine.getCommandLineString()});
        LOG.debug("Command line env: ", new Object[]{commandLine.getEnvironment()});
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        commandLine.setCharset(charset);
        OSProcessHandler processHandler2 = (OSProcessHandler)creator.fun((Object)commandLine);
        if (LOG.isDebugEnabled()) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    LOG.debug(outputType + ": " + event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$2";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        OSProcessHandler oSProcessHandler = processHandler2;
        if (oSProcessHandler == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(9);
        }
        return oSProcessHandler;
    }

    @NotNull
    private static GeneralCommandLine getBasicCommandLine(@NotNull String exePath) {
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(10);
        }
        exePath = PathEnvironmentVariableUtil.toLocatableExePath((String)exePath);
        exePath = PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)exePath);
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{exePath});
        if (generalCommandLine == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    public static boolean isExecutableInPath(@NotNull String exePath) {
        GeneralCommandLine commandLine;
        String initialExePath;
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(12);
        }
        if (!(initialExePath = exePath).equals(exePath = (commandLine = ScriptRunnerUtil.getBasicCommandLine(exePath)).getExePath())) {
            return true;
        }
        String path = (String)commandLine.getEffectiveEnvironment().get("PATH");
        File file2 = PathEnvironmentVariableUtil.findInPath((String)exePath, (String)path, null);
        return file2 != null;
    }

    public static ScriptOutput executeScriptInConsoleWithFullOutput(String exePathString, @Nullable VirtualFile scriptFile, @Nullable String workingDirectory, long timeout, Condition<Key> scriptOutputType, String ... parameters) throws ExecutionException {
        OSProcessHandler processHandler2 = ScriptRunnerUtil.execute(exePathString, workingDirectory, scriptFile, parameters);
        ScriptOutput output = new ScriptOutput(scriptOutputType);
        processHandler2.addProcessListener((ProcessListener)output);
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            LOG.warn("Process did not complete in " + timeout / 1000L + "s");
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        LOG.debug("script output: ", new Object[]{output.myFilteredOutput});
        return output;
    }

    public static void terminateProcessHandler(@NotNull ProcessHandler processHandler2, long millisTimeout, @Nullable String string) {
        KillableProcess killableProcess;
        if (processHandler2 == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(13);
        }
        if (processHandler2.isProcessTerminated()) {
            String commandLine;
            if (commandLine == null && processHandler2 instanceof BaseOSProcessHandler) {
                commandLine = ((BaseOSProcessHandler)processHandler2).getCommandLine();
            }
            LOG.warn("Process '" + commandLine + "' is already terminated!");
            return;
        }
        processHandler2.destroyProcess();
        if (processHandler2 instanceof KillableProcess && (killableProcess = (KillableProcess)processHandler2).canKillProcess() && !processHandler2.waitFor(millisTimeout)) {
            killableProcess.killProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputTypeFilter";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ScriptRunnerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ScriptRunnerUtil";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasicCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBasicCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExecutableInPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "terminateProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScriptOutput
    extends ProcessAdapter {
        private final Condition<Key> myScriptOutputType;
        public final StringBuilder myFilteredOutput;
        public final StringBuffer myMergedOutput;

        private ScriptOutput(Condition<Key> scriptOutputType) {
            this.myScriptOutputType = scriptOutputType;
            this.myFilteredOutput = new StringBuilder();
            this.myMergedOutput = new StringBuffer();
        }

        public String getFilteredOutput() {
            return this.myFilteredOutput.toString();
        }

        public String getMergedOutput() {
            return this.myMergedOutput.toString();
        }

        public String[] getOutputToParseArray() {
            return this.getFilteredOutput().split("\n");
        }

        public String getDescriptiveOutput() {
            String outputToParse = this.getFilteredOutput();
            return StringUtil.isEmpty((String)outputToParse) ? this.getMergedOutput() : outputToParse;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ScriptOutput.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ScriptOutput.$$$reportNull$$$0(1);
            }
            String text = event.getText();
            if (this.myScriptOutputType.value((Object)outputType)) {
                this.myFilteredOutput.append(text);
            }
            this.myMergedOutput.append(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$ScriptOutput";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

