/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CleanupInspectionIntention.class);
    private final InspectionToolWrapper myToolWrapper;
    private final FileModifier myQuickfix;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull FileModifier quickFix, String text) {
        if (toolWrapper == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(0);
        }
        if (quickFix == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(1);
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfix = quickFix;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        List descriptions;
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(4);
        }
        if (!(descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            if (project == null) {
                CleanupInspectionIntention.$$$reportNull$$$0(15);
            }
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
            return InspectionEngine.runInspectionOnFile(file2, this.myToolWrapper, inspectionManager.createNewGlobalContext(false));
        }, (ProgressIndicator)new EmptyProgressIndicator())).isEmpty() && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionIntention.applyFixes(project, "Apply Fixes", descriptions, this.myQuickfix.getClass(), this.myQuickfix.startInWriteAction());
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, "Unfortunately '" + this.myText + "' is currently not available for batch mode\n User interaction is required for each problem found");
        }
    }

    public static AbstractPerformFixesTask applyFixes(@NotNull Project project, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(5);
        }
        if (presentationText == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(6);
        }
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(7);
        }
        CleanupInspectionIntention.sortDescriptions(descriptions);
        return CleanupInspectionIntention.applyFixesNoSort(project, presentationText, descriptions, quickfixClass, startInWriteAction);
    }

    public static AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass, boolean startInWriteAction) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(8);
        }
        if (presentationText == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(9);
        }
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(10);
        }
        boolean isBatch = quickfixClass != null && BatchQuickFix.class.isAssignableFrom(quickfixClass);
        AbstractPerformFixesTask fixesTask = isBatch ? new PerformBatchFixesTask(project, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), quickfixClass) : new PerformFixesTask(project, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), quickfixClass);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                CleanupInspectionIntention.$$$reportNull$$$0(13);
            }
            if (presentationText == null) {
                CleanupInspectionIntention.$$$reportNull$$$0(14);
            }
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            if (quickfixClass != null && startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithProgressInDispatchThread(presentationText, project, null, null, (Consumer<ProgressIndicator>)((Consumer)fixesTask::doRun));
            } else {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, presentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(fixesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        }, presentationText, null);
        return fixesTask;
    }

    public static void sortDescriptions(@NotNull List<ProblemDescriptor> descriptions) {
        if (descriptions == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(11);
        }
        Collections.sort(descriptions, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(12);
        }
        return this.myQuickfix.getClass() != EmptyIntentionAction.class && editor != null && (!(this.myToolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationText";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFixes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFixesNoSort";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortDescriptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFixesNoSort$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PerformFixesTask
    extends AbstractPerformFixesTask {
        public PerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @Nullable Class quickFixClass) {
            if (project == null) {
                PerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformFixesTask.$$$reportNull$$$0(1);
            }
            super(project, descriptors, quickFixClass);
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor2, Project project) {
            fix.applyFix(project, (CommonProblemDescriptor)descriptor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PerformBatchFixesTask
    extends AbstractPerformFixesTask {
        private final List<ProblemDescriptor> myBatchModeDescriptors;
        private boolean myApplied;

        public PerformBatchFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Class quickfixClass) {
            if (project == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(1);
            }
            if (quickfixClass == null) {
                PerformBatchFixesTask.$$$reportNull$$$0(2);
            }
            super(project, descriptors, quickfixClass);
            this.myBatchModeDescriptors = new ArrayList<ProblemDescriptor>();
            this.myApplied = false;
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor2, Project project) {
            this.myBatchModeDescriptors.add(descriptor2);
        }

        @Override
        public boolean isDone() {
            if (super.isDone()) {
                if (!this.myApplied && !this.myBatchModeDescriptors.isEmpty()) {
                    ProblemDescriptor representative = this.myBatchModeDescriptors.get(0);
                    LOG.assertTrue(representative.getFixes() != null);
                    for (QuickFix fix : representative.getFixes()) {
                        if (fix == null || !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                        ((BatchQuickFix)fix).applyFix(this.myProject, (CommonProblemDescriptor[])this.myBatchModeDescriptors.toArray(new ProblemDescriptor[this.myBatchModeDescriptors.size()]), new ArrayList(), null);
                        break;
                    }
                    this.myApplied = true;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "quickfixClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformBatchFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AbstractPerformFixesTask
    extends PerformFixesModalTask {
        private boolean myApplicableFixFound;
        protected final Class myQuickfixClass;

        public AbstractPerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @Nullable Class quickfixClass) {
            if (project == null) {
                AbstractPerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                AbstractPerformFixesTask.$$$reportNull$$$0(1);
            }
            super(project, descriptors);
            this.myApplicableFixFound = false;
            this.myQuickfixClass = quickfixClass;
        }

        protected abstract void collectFix(QuickFix var1, ProblemDescriptor var2, Project var3);

        @Override
        protected final void applyFix(Project project, CommonProblemDescriptor descriptor2) {
            QuickFix[] fixes = descriptor2.getFixes();
            if (fixes != null && fixes.length > 0) {
                for (QuickFix fix : fixes) {
                    if (fix == null || this.myQuickfixClass != null && !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                    ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor2;
                    PsiElement element = problemDescriptor.getPsiElement();
                    if (element == null || !element.isValid()) break;
                    this.collectFix(fix, problemDescriptor, project);
                    this.myApplicableFixFound = true;
                    break;
                }
            }
        }

        public final boolean isApplicableFixFound() {
            return this.myApplicableFixFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention$AbstractPerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

