/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorNotificationActions;
import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.ShowIntentionsPass");
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private volatile boolean myShowBulb;
    private volatile boolean myHasToRecreate;

    ShowIntentionsPass(@NotNull Project project, @NotNull Editor editor, int passId) {
        if (project == null) {
            ShowIntentionsPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(1);
        }
        super(project, editor.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myPassIdToShowIntentionsFor = passId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        this.myFile = documentManager.getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor, @NotNull PsiFile file2, int passId) {
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(3);
        }
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        Project project = file2.getProject();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        infos.forEach(info -> {
            if (editor == null) {
                ShowIntentionsPass.$$$reportNull$$$0(26);
            }
            if (file2 == null) {
                ShowIntentionsPass.$$$reportNull$$$0(27);
            }
            ShowIntentionsPass.addAvailableFixesForGroups(info, editor, file2, result2, passId, offset);
        });
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result2;
        if (arrayList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static boolean markActionInvoked(@NotNull Project project, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (project == null) {
            ShowIntentionsPass.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(6);
        }
        if (action == null) {
            ShowIntentionsPass.$$$reportNull$$$0(7);
        }
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        boolean removed = false;
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (actionInGroup.getAction() != action) continue;
                removed |= info.quickFixActionMarkers.remove(pair);
            }
        }
        return removed;
    }

    private static void addAvailableFixesForGroups(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        if (info == null) {
            ShowIntentionsPass.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(10);
        }
        if (outList == null) {
            ShowIntentionsPass.$$$reportNull$$$0(11);
        }
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range = (RangeMarker)pair.second;
            if (!range.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty((Segment)range) || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)actionInGroup.getAction())) continue;
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            Project project = file2.getProject();
            if (start > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                }
                editorToUse = injectedFile == null ? editor : injectedEditor;
                fileToUse = injectedFile == null ? file2 : injectedFile;
            } else {
                editorToUse = editor;
                fileToUse = file2;
            }
            if (!actionInGroup.getAction().isAvailable(project, editorToUse, fileToUse)) continue;
            outList.add(actionInGroup);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        if (segment == null) {
            ShowIntentionsPass.$$$reportNull$$$0(12);
        }
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowIntentionsPass.$$$reportNull$$$0(13);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        TemplateState state2 = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state2 != null && !state2.isFinished()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        this.getIntentionActionsToShow();
        this.updateActions(codeAnalyzer);
    }

    @Override
    public void doApplyInformationToEditor() {
        Point xy;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        LogicalPosition caretPos = this.myEditor.getCaretModel().getLogicalPosition();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(xy = this.myEditor.logicalPositionToXY(caretPos))) {
            return;
        }
        TemplateState state2 = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (this.myShowBulb && (state2 == null || state2.isFinished()) && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(false)) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            codeAnalyzer.setLastIntentionHint(this.myProject, this.myFile, this.myEditor, this.myIntentionsInfo, this.myHasToRecreate);
        }
    }

    private void getIntentionActionsToShow() {
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor);
        if (this.myIntentionsInfo.isEmpty()) {
            return;
        }
        this.myShowBulb = !this.myIntentionsInfo.guttersToShow.isEmpty() || !this.myIntentionsInfo.notificationActionsToShow.isEmpty() || ContainerUtil.exists((Iterable)ContainerUtil.concat((List[])new List[]{this.myIntentionsInfo.errorFixesToShow, this.myIntentionsInfo.inspectionFixesToShow, this.myIntentionsInfo.intentionsToShow}), descriptor2 -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor2.getAction()));
    }

    private static boolean appendCleanupCode(@NotNull List<HighlightInfo.IntentionActionDescriptor> actionDescriptors, @NotNull PsiFile file2) {
        if (actionDescriptors == null) {
            ShowIntentionsPass.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            ShowIntentionsPass.$$$reportNull$$$0(15);
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor2 : actionDescriptors) {
            if (!descriptor2.canCleanup((PsiElement)file2)) continue;
            IntentionManager manager = IntentionManager.getInstance();
            actionDescriptors.add(new HighlightInfo.IntentionActionDescriptor(manager.createCleanupAllIntention(), manager.getCleanupIntentionOptions(), "Code Cleanup Options"));
            return true;
        }
        return false;
    }

    private void updateActions(@NotNull DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (codeAnalyzer == null) {
            ShowIntentionsPass.$$$reportNull$$$0(16);
        }
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (!this.myShowBulb || hintComponent == null || !hintComponent.isForEditor(this.myEditor)) {
            return;
        }
        IntentionHintComponent.PopupUpdateResult result2 = hintComponent.updateActions(this.myIntentionsInfo);
        if (result2 != IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE && result2 == IntentionHintComponent.PopupUpdateResult.CHANGED_INVISIBLE) {
            this.myHasToRecreate = true;
        }
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        Document hostDocument;
        PsiElement psiElement;
        if (hostEditor == null) {
            ShowIntentionsPass.$$$reportNull$$$0(17);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(18);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(19);
        }
        if ((psiElement = hostFile.findElementAt(hostEditor.getCaretModel().getOffset())) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        int offset = hostEditor.getCaretModel().getOffset();
        Project project = hostFile.getProject();
        List<HighlightInfo.IntentionActionDescriptor> fixes = ShowIntentionsPass.getAvailableFixes(hostEditor, hostFile, passIdToShowIntentionsFor);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        HighlightInfo infoAtCursor = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(hostDocument = hostEditor.getDocument(), offset, true);
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
            for (HighlightInfo.IntentionActionDescriptor fix : fixes) {
                if (fix.isError() && isError) {
                    intentions.errorFixesToShow.add(fix);
                    continue;
                }
                intentions.inspectionFixesToShow.add(fix);
            }
        }
        for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
            Pair<PsiFile, Editor> place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<PsiFile, Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
            if (place == null) continue;
            ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
            enableDisableIntentionAction.add(new IntentionHintComponent.EnableDisableIntentionAction(action));
            enableDisableIntentionAction.add(new IntentionHintComponent.EditIntentionSettingsAction(action));
            HighlightInfo.IntentionActionDescriptor descriptor2 = new HighlightInfo.IntentionActionDescriptor(action, enableDisableIntentionAction, null);
            if (fixes.contains(descriptor2)) continue;
            intentions.intentionsToShow.add(descriptor2);
        }
        if (HighlightingLevelManager.getInstance(project).shouldInspect((PsiElement)hostFile)) {
            PsiElement prev;
            PsiElement intentionElement = psiElement;
            int intentionOffset = offset;
            if (psiElement instanceof PsiWhiteSpace && offset == psiElement.getTextRange().getStartOffset() && offset > 0 && (prev = hostFile.findElementAt(offset - 1)) != null && prev.isValid()) {
                intentionElement = prev;
                intentionOffset = offset - 1;
            }
            if (intentionElement != null && intentionElement.getManager().isInProject(intentionElement)) {
                ShowIntentionsPass.collectIntentionsFromDoNotShowLeveledInspections(project, hostFile, intentionElement, intentionOffset, intentions);
            }
        }
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project, true);
        ArrayList<RangeHighlighterEx> result2 = new ArrayList<RangeHighlighterEx>();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), (Processor<? super RangeHighlighterEx>)processor2);
        GutterIntentionAction.addActions(hostEditor, intentions, project, result2);
        boolean cleanup = ShowIntentionsPass.appendCleanupCode(intentions.inspectionFixesToShow, hostFile);
        if (!cleanup) {
            ShowIntentionsPass.appendCleanupCode(intentions.errorFixesToShow, hostFile);
        }
        EditorNotificationActions.collectDescriptorsForEditor(hostEditor, intentions.notificationActionsToShow);
        intentions.filterActions(hostFile);
    }

    private static void collectIntentionsFromDoNotShowLeveledInspections(@NotNull Project project, @NotNull PsiFile hostFile, PsiElement psiElement, final int offset, final @NotNull IntentionsInfo intentions) {
        if (project == null) {
            ShowIntentionsPass.$$$reportNull$$$0(20);
        }
        if (hostFile == null) {
            ShowIntentionsPass.$$$reportNull$$$0(21);
        }
        if (intentions == null) {
            ShowIntentionsPass.$$$reportNull$$$0(22);
        }
        if (psiElement != null) {
            InspectionToolWrapper[] tools;
            if (!psiElement.isPhysical()) {
                VirtualFile virtualFile = hostFile.getVirtualFile();
                String text = hostFile.getText();
                LOG.error("not physical: '" + psiElement.getText() + "' @" + offset + psiElement.getTextRange() + " elem:" + psiElement + " (" + psiElement.getClass().getName() + ") in:" + psiElement.getContainingFile() + " host:" + hostFile + "(" + hostFile.getClass().getName() + ")", new Attachment[]{new Attachment(virtualFile != null ? virtualFile.getPresentableUrl() : "null", text != null ? text : "null")});
            }
            if (DumbService.isDumb((Project)project)) {
                return;
            }
            ArrayList<LocalInspectionToolWrapper> intentionTools = new ArrayList<LocalInspectionToolWrapper>();
            InspectionProfile profile2 = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            for (InspectionToolWrapper toolWrapper2 : tools = profile2.getInspectionTools((PsiElement)hostFile)) {
                HighlightDisplayKey key;
                if (toolWrapper2 instanceof GlobalInspectionToolWrapper) {
                    toolWrapper2 = ((GlobalInspectionToolWrapper)toolWrapper2).getSharedLocalInspectionToolWrapper();
                }
                if (!(toolWrapper2 instanceof LocalInspectionToolWrapper) || ((LocalInspectionToolWrapper)toolWrapper2).isUnfair() || !profile2.isToolEnabled(key = HighlightDisplayKey.find((String)toolWrapper2.getShortName()), (PsiElement)hostFile) || !HighlightDisplayLevel.DO_NOT_SHOW.equals(profile2.getErrorLevel(key, (PsiElement)hostFile))) continue;
                intentionTools.add((LocalInspectionToolWrapper)toolWrapper2);
            }
            if (!intentionTools.isEmpty()) {
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                for (PsiElement el = psiElement; el != null; el = el.getParent()) {
                    elements.add(el);
                    if (el instanceof PsiFile) break;
                }
                Set<String> dialectIds = InspectionEngine.calcElementDialectIds(elements);
                LocalInspectionToolSession session2 = new LocalInspectionToolSession(hostFile, 0, hostFile.getTextLength());
                Processor processor2 = toolWrapper -> {
                    if (project == null) {
                        ShowIntentionsPass.$$$reportNull$$$0(23);
                    }
                    if (hostFile == null) {
                        ShowIntentionsPass.$$$reportNull$$$0(24);
                    }
                    if (intentions == null) {
                        ShowIntentionsPass.$$$reportNull$$$0(25);
                    }
                    LocalInspectionTool localInspectionTool = (LocalInspectionTool)toolWrapper.getTool();
                    final HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                    final String displayName = toolWrapper.getDisplayName();
                    ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project), hostFile, true){

                        public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
                            QuickFix[] fixes;
                            TextRange range;
                            if (problemDescriptor == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.registerProblem(problemDescriptor);
                            if (problemDescriptor instanceof ProblemDescriptorBase && (range = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) != null && range.contains(offset) && (fixes = problemDescriptor.getFixes()) != null) {
                                for (int k = 0; k < fixes.length; ++k) {
                                    IntentionAction intentionAction = QuickFixWrapper.wrap(problemDescriptor, k);
                                    HighlightInfo.IntentionActionDescriptor actionDescriptor = new HighlightInfo.IntentionActionDescriptor(intentionAction, null, displayName, null, key, null, HighlightSeverity.INFORMATION);
                                    intentions.intentionsToShow.add(actionDescriptor);
                                }
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$1", "registerProblem"));
                        }
                    };
                    InspectionEngine.createVisitorAndAcceptElements(localInspectionTool, holder, true, session2, elements, dialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(toolWrapper));
                    localInspectionTool.inspectionFinished(session2, holder);
                    return true;
                };
                ProgressIndicator progress = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressIndicatorProvider.getGlobalProgressIndicator(), (Object)new DaemonProgressIndicator());
                JobLauncher.getInstance().invokeConcurrentlyUnderProgress(intentionTools, progress, false, processor2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 10: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionDescriptors";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeAnalyzer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableFixes";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markActionInvoked";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAvailableFixesForGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendCleanupCode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getActionsToShow";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectIntentionsFromDoNotShowLeveledInspections";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectIntentionsFromDoNotShowLeveledInspections$3";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAvailableFixes$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();

        void filterActions(@Nullable PsiFile psiFile) {
            IntentionActionFilter[] filters = (IntentionActionFilter[])IntentionActionFilter.EXTENSION_POINT_NAME.getExtensions();
            IntentionsInfo.filter(this.intentionsToShow, psiFile, filters);
            IntentionsInfo.filter(this.errorFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.inspectionFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.guttersToShow, psiFile, filters);
            IntentionsInfo.filter(this.notificationActionsToShow, psiFile, filters);
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @Nullable PsiFile psiFile, @NotNull IntentionActionFilter[] filters) {
            if (descriptors == null) {
                IntentionsInfo.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                IntentionsInfo.$$$reportNull$$$0(1);
            }
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            block0: while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                for (IntentionActionFilter filter2 : filters) {
                    if (filter2.accept(actionDescriptor.getAction(), psiFile)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "Notifications: " + this.notificationActionsToShow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo";
            objectArray[2] = "filter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

