/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorSettingsUtil {
    private ColorSettingsUtil() {
    }

    public static Map<TextAttributesKey, String> keyToDisplayTextMap(ColorSettingsPage page) {
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)page);
        HashMap displayText = new HashMap();
        for (AttributesDescriptor attributeDescriptor : attributeDescriptors) {
            TextAttributesKey key = attributeDescriptor.getKey();
            displayText.put(key, attributeDescriptor.getDisplayName());
        }
        return displayText;
    }

    public static List<AttributesDescriptor> getAllAttributeDescriptors(@NotNull ColorAndFontDescriptorsProvider provider) {
        if (provider == null) {
            ColorSettingsUtil.$$$reportNull$$$0(0);
        }
        ArrayList<AttributesDescriptor> result2 = new ArrayList<AttributesDescriptor>();
        Collections.addAll(result2, provider.getAttributeDescriptors());
        if (ColorSettingsUtil.isInspectionColorsPage(provider)) {
            ColorSettingsUtil.addInspectionSeverityAttributes(result2);
        }
        return result2;
    }

    private static boolean isInspectionColorsPage(ColorAndFontDescriptorsProvider provider) {
        if (!(provider instanceof InspectionColorSettingsPage)) {
            return false;
        }
        for (ColorSettingsPage settingsPage : (ColorSettingsPage[])Extensions.getExtensions((ExtensionPointName)ColorSettingsPage.EP_NAME)) {
            if (settingsPage == provider) break;
            if (!(settingsPage instanceof InspectionColorSettingsPage)) continue;
            return false;
        }
        return true;
    }

    private static void addInspectionSeverityAttributes(List<AttributesDescriptor> descriptors) {
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unknown.symbol", (Object[])new Object[0]), CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.deprecated.symbol", (Object[])new Object[0]), CodeInsightColors.DEPRECATED_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.marked.for.removal.symbol", (Object[])new Object[0]), CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unused.symbol", (Object[])new Object[0]), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]), CodeInsightColors.ERRORS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.warning", (Object[])new Object[0]), CodeInsightColors.WARNINGS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.weak.warning", (Object[])new Object[0]), CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.problems", (Object[])new Object[0]), CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.duplicate", (Object[])new Object[0]), CodeInsightColors.DUPLICATE_FROM_SERVER));
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                descriptors.add(new AttributesDescriptor(ColorSettingsUtil.toDisplayName(attributesKey), attributesKey));
            }
        }
    }

    @NotNull
    private static String toDisplayName(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            ColorSettingsUtil.$$$reportNull$$$0(1);
        }
        String string = OptionsBundle.message((String)"options.java.attribute.descriptor.errors.group", (Object[])new Object[]{StringUtil.capitalize((String)attributesKey.getExternalName().toLowerCase().replaceAll("_", " "))});
        if (string == null) {
            ColorSettingsUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorSettingsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorSettingsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toDisplayName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

