/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import dk.brics.automaton.TransitionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShuffleOperations {
    private ShuffleOperations() {
    }

    public static Automaton shuffle(Automaton a1, Automaton a2) {
        State s;
        a1.determinize();
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        c.initial = s = new State();
        StatePair p = new StatePair(s, a1.initial, a2.initial);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            p.s.accept = p.s1.accept && p.s2.accept;
            Transition[] t1 = transitions1[p.s1.number];
            for (int n1 = 0; n1 < t1.length; ++n1) {
                StatePair q = new StatePair(t1[n1].to, p.s2);
                StatePair r = (StatePair)newstates.get(q);
                if (r == null) {
                    q.s = new State();
                    worklist.add(q);
                    newstates.put(q, q);
                    r = q;
                }
                p.s.transitions.add(new Transition(t1[n1].min, t1[n1].max, r.s));
            }
            Transition[] t2 = transitions2[p.s2.number];
            for (int n2 = 0; n2 < t2.length; ++n2) {
                StatePair q = new StatePair(p.s1, t2[n2].to);
                StatePair r = (StatePair)newstates.get(q);
                if (r == null) {
                    q.s = new State();
                    worklist.add(q);
                    newstates.put(q, q);
                    r = q;
                }
                p.s.transitions.add(new Transition(t2[n2].min, t2[n2].max, r.s));
            }
        }
        c.deterministic = false;
        c.removeDeadTransitions();
        c.checkMinimizeAlways();
        return c;
    }

    public static String shuffleSubsetOf(Collection<Automaton> ca, Automaton a, Character suspend_shuffle, Character resume_shuffle) {
        if (ca.size() == 0) {
            return null;
        }
        if (ca.size() == 1) {
            Automaton a1 = ca.iterator().next();
            if (a1.isSingleton()) {
                if (a.run(a1.singleton)) {
                    return null;
                }
                return a1.singleton;
            }
            if (a1 == a) {
                return null;
            }
        }
        a.determinize();
        Transition[][][] ca_transitions = new Transition[ca.size()][][];
        int i = 0;
        for (Automaton a1 : ca) {
            ca_transitions[i++] = Automaton.getSortedTransitions(a1.getStates());
        }
        Transition[][] a_transitions = Automaton.getSortedTransitions(a.getStates());
        TransitionComparator tc = new TransitionComparator(false);
        ShuffleConfiguration init = new ShuffleConfiguration(ca, a);
        LinkedList<ShuffleConfiguration> pending = new LinkedList<ShuffleConfiguration>();
        HashSet<ShuffleConfiguration> visited = new HashSet<ShuffleConfiguration>();
        pending.add(init);
        visited.add(init);
        block1: while (!pending.isEmpty()) {
            ShuffleConfiguration c = (ShuffleConfiguration)pending.removeFirst();
            boolean good = true;
            for (int i1 = 0; i1 < ca.size(); ++i1) {
                if (c.ca_states[i1].accept) continue;
                good = false;
                break;
            }
            if (c.a_state.accept) {
                good = false;
            }
            if (good) {
                StringBuilder sb = new StringBuilder();
                while (c.prev != null) {
                    sb.append(c.min);
                    c = c.prev;
                }
                StringBuilder sb2 = new StringBuilder();
                for (int j = sb.length() - 1; j >= 0; --j) {
                    sb2.append(sb.charAt(j));
                }
                return sb2.toString();
            }
            Transition[] ta2 = a_transitions[c.a_state.number];
            for (int i1 = 0; i1 < ca.size(); ++i1) {
                if (c.shuffle_suspended) {
                    i1 = c.suspended1;
                }
                block6: for (Transition t1 : ca_transitions[i1][c.ca_states[i1].number]) {
                    char min;
                    ArrayList<Transition> lt = new ArrayList<Transition>();
                    int j = Arrays.binarySearch(ta2, t1, tc);
                    if (j < 0) {
                        j = -j - 1;
                    }
                    if (j > 0 && ta2[j - 1].max >= t1.min) {
                        --j;
                    }
                    while (j < ta2.length) {
                        Transition t2 = ta2[j++];
                        min = t1.min;
                        char max = t1.max;
                        if (t2.min > min) {
                            min = t2.min;
                        }
                        if (t2.max < max) {
                            max = t2.max;
                        }
                        if (min > max) break;
                        ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, min, max);
                        lt.add(new Transition(min, max, null));
                    }
                    Transition[] at = lt.toArray(new Transition[lt.size()]);
                    Arrays.sort(at, tc);
                    min = t1.min;
                    for (int k = 0; k < at.length && at[k].min <= min; ++k) {
                        if (at[k].max >= t1.max) continue block6;
                        min = (char)(at[k].max + '\u0001');
                    }
                    ShuffleConfiguration nc = new ShuffleConfiguration(c, i1, t1.to, min);
                    StringBuilder sb = new StringBuilder();
                    ShuffleConfiguration b = nc;
                    while (b.prev != null) {
                        sb.append(b.min);
                        b = b.prev;
                    }
                    StringBuilder sb2 = new StringBuilder();
                    for (int m = sb.length() - 1; m >= 0; --m) {
                        sb2.append(sb.charAt(m));
                    }
                    if (c.shuffle_suspended) {
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[c.suspended1], true));
                    }
                    for (i1 = 0; i1 < ca.size(); ++i1) {
                        if (c.shuffle_suspended && i1 == c.suspended1) continue;
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[i1], true));
                    }
                    return sb2.toString();
                }
                if (c.shuffle_suspended) continue block1;
            }
        }
        return null;
    }

    private static void add(Character suspend_shuffle, Character resume_shuffle, LinkedList<ShuffleConfiguration> pending, Set<ShuffleConfiguration> visited, ShuffleConfiguration c, int i1, Transition t1, Transition t2, char min, char max) {
        int HIGH_SURROGATE_BEGIN = 55296;
        int HIGH_SURROGATE_END = 56319;
        if (suspend_shuffle != null && min <= suspend_shuffle.charValue() && suspend_shuffle.charValue() <= max && min != max) {
            if (min < suspend_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, min, (char)(suspend_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, suspend_shuffle.charValue(), suspend_shuffle.charValue());
            if (suspend_shuffle.charValue() < max) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, (char)(suspend_shuffle.charValue() + '\u0001'), max);
            }
        } else if (resume_shuffle != null && min <= resume_shuffle.charValue() && resume_shuffle.charValue() <= max && min != max) {
            if (min < resume_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, min, (char)(resume_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, resume_shuffle.charValue(), resume_shuffle.charValue());
            if (resume_shuffle.charValue() < max) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, (char)(resume_shuffle.charValue() + '\u0001'), max);
            }
        } else if (min < '\ud800' && max >= '\ud800') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, min, '\ud7ff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, '\ud800', max);
        } else if (min <= '\udbff' && max > '\udbff') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, min, '\udbff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c, i1, t1, t2, '\udc00', max);
        } else {
            ShuffleConfiguration nc = new ShuffleConfiguration(c, i1, t1.to, t2.to, min);
            if (suspend_shuffle != null && min == suspend_shuffle.charValue()) {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
            } else if (resume_shuffle != null && min == resume_shuffle.charValue()) {
                nc.shuffle_suspended = false;
            }
            if (min >= '\ud800' && min <= '\ud800') {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
                nc.surrogate = true;
            }
            if (!visited.contains(nc)) {
                pending.add(nc);
                visited.add(nc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShuffleConfiguration {
        ShuffleConfiguration prev;
        State[] ca_states;
        State a_state;
        char min;
        int hash;
        boolean shuffle_suspended;
        boolean surrogate;
        int suspended1;

        private ShuffleConfiguration() {
        }

        ShuffleConfiguration(Collection<Automaton> ca, Automaton a) {
            this.ca_states = new State[ca.size()];
            int i = 0;
            for (Automaton a1 : ca) {
                this.ca_states[i++] = a1.getInitialState();
            }
            this.a_state = a.getInitialState();
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c, int i1, State s1, char min) {
            this.prev = c;
            this.ca_states = (State[])c.ca_states.clone();
            this.a_state = c.a_state;
            this.ca_states[i1] = s1;
            this.min = min;
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c, int i1, State s1, State s2, char min) {
            this.prev = c;
            this.ca_states = (State[])c.ca_states.clone();
            this.a_state = c.a_state;
            this.ca_states[i1] = s1;
            this.a_state = s2;
            this.min = min;
            if (!this.surrogate) {
                this.shuffle_suspended = c.shuffle_suspended;
                this.suspended1 = c.suspended1;
            }
            this.computeHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShuffleConfiguration) {
                ShuffleConfiguration c = (ShuffleConfiguration)obj;
                return this.shuffle_suspended == c.shuffle_suspended && this.surrogate == c.surrogate && this.suspended1 == c.suspended1 && Arrays.equals(this.ca_states, c.ca_states) && this.a_state == c.a_state;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        private void computeHash() {
            this.hash = 0;
            for (int i = 0; i < this.ca_states.length; ++i) {
                this.hash ^= this.ca_states[i].hashCode();
            }
            this.hash ^= this.a_state.hashCode() * 100;
            if (this.shuffle_suspended || this.surrogate) {
                this.hash += this.suspended1;
            }
        }
    }
}

