/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;

public class JPEGImageWriter
implements ImageWriter {
    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        this.writeImage(renderedImage, outputStream, null);
    }

    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) throws IOException {
        BufferedImage bufferedImage = renderedImage instanceof BufferedImage ? (BufferedImage)renderedImage : GraphicsUtil.makeLinearBufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), false);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        if (imageWriterParams != null) {
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            if (imageWriterParams.getJPEGQuality() != null) {
                jPEGEncodeParam.setQuality(imageWriterParams.getJPEGQuality().floatValue(), imageWriterParams.getJPEGForceBaseline().booleanValue());
            }
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
        } else {
            jPEGImageEncoder.encode(bufferedImage);
        }
    }

    @Override
    public String getMIMEType() {
        return "image/jpeg";
    }
}

